/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.duals;

import com.suncode.plugin.pluspekaosaintegrator.Categories;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.services.ArchiveDocumentService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ElixirAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ParameterAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.PlaBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.PlaBankTransferParametersDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.services.ElixirService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="/dist/pluspekaosa/duals/PlaBankTransfer/pwe_dynamic_form.js")
public class PlaBankTransfer {
    private static final Logger log = LoggerFactory.getLogger(PlaBankTransfer.class);
    public static final String APP_ID = "pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer";
    private static final String[] stringParams = new String[]{"documentClassName", "documentName", "reference", "principalName", "principalAddress", "filename"};
    private static final String[] stringArrayParams = new String[]{"transferType", "signature", "currency", "beneficiaryCountryCode", "beneficiaryBankCountryCode", "beneficiaryAccountNumber", "beneficiaryName", "paymentDetails", "feesPaymentMode", "referenceCurrencyCode", "principalAccountNumber", "feesAccountNumber"};
    private static final String[] optionalStringArrayParams = new String[]{"shipmentNumber", "transferNumber", "beneficiaryAddress", "beneficiaryBankSwiftCode", "beneficiaryBankNumber", "beneficiaryBankName", "beneficiaryBankAddress", "extraData"};
    private final AtomicInteger shipmentCounter = new AtomicInteger(1);
    private final AtomicInteger transferCounter = new AtomicInteger(1);
    @Autowired
    private ElixirService elixirService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id(APP_ID)).name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.name")).description("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.desc")).icon((Icon)DivanteIcon.MONEY)).category(new Category[]{Categories.PLUS_PEKAO_SA})).parameter().id("transferDate").name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.transferDate.name").type((Type)Types.DATE_ARRAY).arrayMinLength(1).create()).parameter().id("amount").name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.amount.name").type((Type)Types.FLOAT_ARRAY).arrayMinLength(1).create()).parameter().id("referenceCurrencyAmount").name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.referenceCurrencyAmount.name").type((Type)Types.FLOAT_ARRAY).arrayMinLength(1).create()).parameter().id("decimalSeparator").name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.decimalSeparator.name").description("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.decimalSeparator.desc").type((Type)Types.STRING).defaultValue((Object)",").create()).parameter().id("principalBankSwiftCode").name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.principalBankSwiftCode.name").type((Type)Types.STRING).defaultValue((Object)"PKOPPLPWXXX").create();
        Arrays.stream(stringParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param." + key + ".name").type((Type)Types.STRING).create();
        });
        Arrays.stream(optionalStringArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).create();
        });
        Arrays.stream(stringArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param." + key + ".name").type((Type)Types.STRING_ARRAY).arrayMinLength(1).create();
        });
    }

    public void set(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        this.run(parameters, workflowContext, translator);
    }

    public void execute(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        this.run(parameters, workflowContext, translator);
    }

    public void run(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        PlaBankTransferParametersDto.PlaHeader headerParameters = PlaBankTransferParametersDto.PlaHeader.builder().reference((String)parameters.get("reference", String.class)).principalName((String)parameters.get("principalName", String.class)).principalAddress((String)parameters.get("principalAddress", String.class)).principalBankSwiftCode((String)parameters.get("principalBankSwiftCode", String.class)).filename((String)parameters.get("filename", String.class)).build();
        PlaBankTransferParametersDto.PlaTransfers transferParameters = PlaBankTransferParametersDto.PlaTransfers.builder().shipmentNumber((String[])parameters.get("shipmentNumber", String[].class)).transferNumber((String[])parameters.get("transferNumber", String[].class)).beneficiaryBankSwiftCode((String[])parameters.get("beneficiaryBankSwiftCode", String[].class)).beneficiaryBankNumber((String[])parameters.get("beneficiaryBankNumber", String[].class)).transferType((String[])parameters.get("transferType", String[].class)).signature((String[])parameters.get("signature", String[].class)).transferDate((LocalDate[])parameters.get("transferDate", LocalDate[].class)).currency((String[])parameters.get("currency", String[].class)).amount((Double[])parameters.get("amount", Double[].class)).principalAccountNumber((String[])parameters.get("principalAccountNumber", String[].class)).feesAccountNumber((String[])parameters.get("feesAccountNumber", String[].class)).referenceCurrencyAmount((Double[])parameters.get("referenceCurrencyAmount", Double[].class)).referenceCurrencyCode((String[])parameters.get("referenceCurrencyCode", String[].class)).beneficiaryCountryCode((String[])parameters.get("beneficiaryCountryCode", String[].class)).beneficiaryBankCountryCode((String[])parameters.get("beneficiaryBankCountryCode", String[].class)).beneficiaryBankName((String[])parameters.get("beneficiaryBankName", String[].class)).beneficiaryBankAddress((String[])parameters.get("beneficiaryBankAddress", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).beneficiaryName((String[])parameters.get("beneficiaryName", String[].class)).beneficiaryAddress((String[])parameters.get("beneficiaryAddress", String[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).feesPaymentMode((String[])parameters.get("feesPaymentMode", String[].class)).extraData((String[])parameters.get("extraData", String[].class)).build();
        ParameterAssertions.assertEqualArrayLength(transferParameters.getTransferType(), transferParameters.getSignature(), transferParameters.getTransferDate(), transferParameters.getCurrency(), transferParameters.getAmount(), transferParameters.getPrincipalAccountNumber(), transferParameters.getFeesAccountNumber(), transferParameters.getReferenceCurrencyAmount(), transferParameters.getReferenceCurrencyCode(), transferParameters.getBeneficiaryCountryCode(), transferParameters.getBeneficiaryAccountNumber(), transferParameters.getBeneficiaryName(), transferParameters.getPaymentDetails(), transferParameters.getBeneficiaryBankCountryCode(), transferParameters.getFeesPaymentMode());
        this.assertHeaderValues(headerParameters, translator);
        this.assertTransferValues(transferParameters, translator);
        PlaBankTransferDto.PlaTransferHeaderDto plaHeaderDto = this.buildHeaderDto(headerParameters);
        List<PlaBankTransferDto.PlaTransferDto> plaTransferDto = this.buildTransferDto(headerParameters, transferParameters);
        plaHeaderDto.setTotalAmount(Arrays.stream(transferParameters.getAmount()).mapToDouble(Double::doubleValue).sum());
        plaHeaderDto.setTransferCount(transferParameters.getAmount().length);
        PlaBankTransferDto plaDto = PlaBankTransferDto.builder().header(plaHeaderDto).transfers(plaTransferDto).decimalSeparator((String)parameters.get("decimalSeparator", String.class)).build();
        TempFile tempFile = new TempFile();
        String documentName = this.getFilename((String)parameters.get("documentName", String.class));
        try (InputStream inputStream = tempFile.getInputStream();){
            this.elixirService.createPlaTransferFile(plaDto, tempFile.getFile());
            this.archiveDocumentService.addNewDocumentToArchive(documentClassName, documentName, inputStream, workflowContext);
        }
        catch (IOException e) {
            throw new AcceptanceException("IOException occurred!");
        }
        finally {
            tempFile.delete();
        }
    }

    private PlaBankTransferDto.PlaTransferHeaderDto buildHeaderDto(PlaBankTransferParametersDto.PlaHeader parameters) {
        return PlaBankTransferDto.PlaTransferHeaderDto.builder().reference(parameters.getReference()).principalName(parameters.getPrincipalName()).principalAddress(parameters.getPrincipalAddress()).principalBankSwiftCode(parameters.getPrincipalBankSwiftCode()).filename(parameters.getFilename()).build();
    }

    private List<PlaBankTransferDto.PlaTransferDto> buildTransferDto(PlaBankTransferParametersDto.PlaHeader header, PlaBankTransferParametersDto.PlaTransfers transfers) {
        ArrayList<PlaBankTransferDto.PlaTransferDto> list = new ArrayList<PlaBankTransferDto.PlaTransferDto>();
        IntStream.range(0, transfers.getAmount().length).forEach(index -> {
            String providedShipmentNumber = this.getOptionalParameterValue(transfers.getShipmentNumber(), index);
            String shipmentNumber = StringUtils.isEmpty((CharSequence)providedShipmentNumber) ? this.getIncrementedValue(this.shipmentCounter, 4) : providedShipmentNumber;
            String providedTransferNumber = this.getOptionalParameterValue(transfers.getTransferNumber(), index);
            String transferNumber = StringUtils.isEmpty((CharSequence)providedTransferNumber) ? this.getIncrementedValue(this.transferCounter, 6) : providedTransferNumber;
            list.add(PlaBankTransferDto.PlaTransferDto.builder().shipmentNumber(shipmentNumber).transferNumber(transferNumber).beneficiaryBankSwiftCode(this.getOptionalParameterValue(transfers.getBeneficiaryBankSwiftCode(), index)).beneficiaryBankNumber(this.getOptionalParameterValue(transfers.getBeneficiaryBankNumber(), index)).transferType(transfers.getTransferType()[index]).signature(transfers.getSignature()[index]).transferDate(transfers.getTransferDate()[index]).currency(transfers.getCurrency()[index]).amount(transfers.getAmount()[index]).principalName(header.getPrincipalName()).principalAddress(header.getPrincipalAddress()).principalBankSwiftCode(header.getPrincipalBankSwiftCode()).principalAccountNumber(transfers.getPrincipalAccountNumber()[index]).feesAccountNumber(transfers.getFeesAccountNumber()[index]).referenceCurrencyCode(transfers.getReferenceCurrencyCode()[index]).referenceCurrencyAmount(transfers.getReferenceCurrencyAmount()[index]).beneficiaryCountryCode(transfers.getBeneficiaryCountryCode()[index]).beneficiaryBankCountryCode(transfers.getBeneficiaryBankCountryCode()[index]).beneficiaryBankName(this.getOptionalParameterValue(transfers.getBeneficiaryBankName(), index)).beneficiaryBankAddress(this.getOptionalParameterValue(transfers.getBeneficiaryBankAddress(), index)).beneficiaryAccountNumber(transfers.getBeneficiaryAccountNumber()[index]).beneficiaryName(transfers.getBeneficiaryName()[index]).beneficiaryAddress(this.getOptionalParameterValue(transfers.getBeneficiaryAddress(), index)).paymentDetails(transfers.getPaymentDetails()[index]).feesPaymentMode(transfers.getFeesPaymentMode()[index]).extraData(this.getOptionalParameterValue(transfers.getExtraData(), index)).build());
        });
        return list;
    }

    private void assertHeaderValues(PlaBankTransferParametersDto.PlaHeader dto, Translator t) {
        ElixirAssertions.assertAlphanumeric(dto.getReference(), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.reference.name"), 16, false, false);
        ElixirAssertions.assertNonNull(dto.getPrincipalName(), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.principalName.name"));
        ElixirAssertions.assertNonNull(dto.getPrincipalAddress(), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.principalAddress.name"));
        ElixirAssertions.assertAlphanumericSpecialChars(dto.getPrincipalName() + dto.getPrincipalAddress(), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.principalNameAndAddress.name"), 140, false, false);
        ElixirAssertions.assertAlphanumericSpecialChars(dto.getFilename(), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.filename.name"), 12, false, false);
        ElixirAssertions.assertAlphanumeric(dto.getPrincipalBankSwiftCode(), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.principalBankSwiftCode.name"), 11, false, false);
    }

    private void assertTransferValues(PlaBankTransferParametersDto.PlaTransfers dto, Translator t) {
        IntStream.range(0, dto.getAmount().length).forEach(index -> {
            ElixirAssertions.assertNumeric(dto.getPrincipalAccountNumber()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.principalAccountNumber.name"), 26, false, true);
            ElixirAssertions.assertNumeric(dto.getFeesAccountNumber()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.feesAccountNumber.name"), 26, false, true);
            if (dto.getShipmentNumber().length > index) {
                ElixirAssertions.assertNumeric(dto.getShipmentNumber()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.shipmentNumber.name"), 4, true, true);
            }
            if (dto.getTransferNumber().length > index) {
                ElixirAssertions.assertNumeric(dto.getTransferNumber()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.transferNumber.name"), 6, true, true);
            }
            ElixirAssertions.assertAlphanumeric(dto.getTransferType()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.transferType.name"), 1, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getSignature()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.signature.name"), 16, false, false);
            ElixirAssertions.assertNonNull(dto.getTransferDate()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.transferDate.name"));
            ElixirAssertions.assertAlphanumeric(dto.getCurrency()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.currency.name"), 3, false, true);
            ElixirAssertions.assertNonNull(dto.getAmount()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.amount.name"));
            ElixirAssertions.assertNonNull(dto.getReferenceCurrencyAmount()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.referenceCurrencyAmount.name"));
            ElixirAssertions.assertAlphanumeric(dto.getReferenceCurrencyCode()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.referenceCurrencyCode.name"), 3, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryCountryCode()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryCountryCode.name"), 2, false, true);
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankCountryCode()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryBankCountryCode.name"), 2, false, true);
            if (StringUtils.isNotBlank((CharSequence)dto.getBeneficiaryBankSwiftCode()[index])) {
                ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryBankSwiftCode()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryBankSwiftCode.name"), 11, false, false);
            } else {
                ElixirAssertions.assertAlphanumericSpecialChars(dto.getBeneficiaryBankNumber()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryBankNumber.name"), 11, false, false);
                ElixirAssertions.assertNonNull(dto.getBeneficiaryBankName()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryBankName.name"));
                ElixirAssertions.assertNonNull(dto.getBeneficiaryBankAddress()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryBankAddress.name"));
                ElixirAssertions.assertAlphanumericSpecialChars(dto.getBeneficiaryBankName()[index] + dto.getBeneficiaryBankAddress()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryBankNameAndAddress.name"), 140, false, false);
            }
            ElixirAssertions.assertAlphanumeric(dto.getBeneficiaryAccountNumber()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryAccountNumber.name"), 34, false, false);
            ElixirAssertions.assertNonNull(dto.getBeneficiaryName()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryName.name"));
            if (dto.getBeneficiaryAddress().length == dto.getBeneficiaryName().length) {
                ElixirAssertions.assertAlphanumericSpecialChars(dto.getBeneficiaryName()[index] + (dto.getBeneficiaryAddress()[index] != null ? dto.getBeneficiaryAddress()[index] : ""), t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryNameAndAddress.name"), 140, false, false);
            } else {
                ElixirAssertions.assertAlphanumericSpecialChars(dto.getBeneficiaryName()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.beneficiaryName.name"), 140, false, false);
            }
            ElixirAssertions.assertAlphanumericSpecialChars(dto.getPaymentDetails()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.paymentDetails.name"), 140, false, false);
            ElixirAssertions.assertAlphanumeric(dto.getFeesPaymentMode()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.feesPaymentMode.name"), 3, false, true);
            if (dto.getExtraData().length > index) {
                ElixirAssertions.assertAlphanumericSpecialChars(dto.getExtraData()[index], t.getMessage("pluspekaosaintegrator.pluspekaosa.duals.PlaBankTransfer.param.extraData.name"), 140, true, false);
            }
        });
    }

    private String getFilename(String filename) {
        if (StringUtils.endsWithIgnoreCase((CharSequence)filename, (CharSequence)".pla")) {
            return filename;
        }
        return filename + ".pla";
    }

    private String getIncrementedValue(AtomicInteger counter, int length) {
        int value = counter.getAndIncrement();
        return String.format("%0" + length + "d", value);
    }

    private String getOptionalParameterValue(String[] array, int index) {
        if (array != null && array.length > index) {
            return array[index];
        }
        return "";
    }
}

