/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.duals;

import com.suncode.plugin.pluspekaosaintegrator.Categories;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.services.ArchiveDocumentService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ElixirAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ParameterAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.ForeignBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.ForeignBankTransferParametersDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.services.ElixirService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils.Formatter;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils.ParamUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="dist/pluspekaosa/duals/ForeignBankTransfer/pwe_dynamic_form.js")
public class ForeignBankTransfer {
    private static final Logger log = LoggerFactory.getLogger(ForeignBankTransfer.class);
    private static final String[] stringArrayParams = new String[]{"beneficiaryBankCountryCode", "beneficiaryCountryCode", "beneficiaryBankSwiftCode", "beneficiaryCityName", "beneficiaryName", "beneficiaryAccountNumber", "principalAccountNumber", "paymentDetails", "beneficiaryStreetName", "currency", "beneficiaryBankAddress", "annotations", "ignoreField", "paymentMethod", "beneficiaryBankName", "costAccountingMethod", "signature", "endToEndId", "paymentMode", "contractorType", "principalBicId", "principalOrganizationId", "beneficiaryBicId", "beneficiaryOrganizationId", "beneficiaryOtherId", "beneficiaryDateOfBirth", "beneficiaryBirthCityName", "beneficiaryBirthDistrictName", "beneficiaryBirthCountryCode", "confirmationEmailAddress", "confirmationSmsAddress"};
    @Autowired
    private ElixirService elixirService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer")).name("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.name")).description("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.desc")).category(new Category[]{Categories.PLUS_PEKAO_SA})).icon((Icon)DivanteIcon.MONEY)).parameter().id("documentClassName").name("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.documentClassName.name").description("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.documentName.name").description("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("amount").name("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.amount.name").description("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.amount.desc").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("executionDate").name("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.executionDate.name").description("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.executionDate.desc").type((Type)Types.DATE_ARRAY).create();
        Arrays.stream(stringArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param." + key + ".name").description("pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param." + key + ".desc").type((Type)Types.STRING_ARRAY).create();
        });
    }

    public void execute(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        this.run(parameters, workflowContext, translator);
    }

    public void set(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        this.run(parameters, workflowContext, translator);
    }

    private void run(Parameters parameters, WorkflowContext context, Translator translator) throws AcceptanceException {
        ForeignBankTransferParametersDto dto = ForeignBankTransferParametersDto.builder().beneficiaryBankCountryCode((String[])parameters.get("beneficiaryBankCountryCode", String[].class)).beneficiaryCountryCode((String[])parameters.get("beneficiaryCountryCode", String[].class)).beneficiaryBankSwiftCode((String[])parameters.get("beneficiaryBankSwiftCode", String[].class)).amount((Double[])parameters.get("amount", Double[].class)).beneficiaryCityName((String[])parameters.get("beneficiaryCityName", String[].class)).beneficiaryName((String[])parameters.get("beneficiaryName", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).principalAccountNumber((String[])parameters.get("principalAccountNumber", String[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).beneficiaryStreetName((String[])parameters.get("beneficiaryStreetName", String[].class)).currency((String[])parameters.get("currency", String[].class)).annotations((String[])parameters.get("annotations", String[].class)).beneficiaryBankAddress((String[])parameters.get("beneficiaryBankAddress", String[].class)).executionDate((LocalDate[])parameters.get("executionDate", LocalDate[].class)).ignoreField((String[])parameters.get("ignoreField", String[].class)).paymentMethod((String[])parameters.get("paymentMethod", String[].class)).beneficiaryBankName((String[])parameters.get("beneficiaryBankName", String[].class)).costAccountingMethod((String[])parameters.get("costAccountingMethod", String[].class)).signature((String[])parameters.get("signature", String[].class)).endToEndId((String[])parameters.get("endToEndId", String[].class)).paymentMode((String[])parameters.get("paymentMode", String[].class)).contractorType((String[])parameters.get("contractorType", String[].class)).principalBicId((String[])parameters.get("principalBicId", String[].class)).principalOrganizationId((String[])parameters.get("principalOrganizationId", String[].class)).beneficiaryBicId((String[])parameters.get("beneficiaryBicId", String[].class)).beneficiaryOrganizationId((String[])parameters.get("beneficiaryOrganizationId", String[].class)).beneficiaryOtherId((String[])parameters.get("beneficiaryOtherId", String[].class)).beneficiaryDateOfBirth((String[])parameters.get("beneficiaryDateOfBirth", String[].class)).beneficiaryBirthCityName((String[])parameters.get("beneficiaryBirthCityName", String[].class)).beneficiaryBirthDistrictName((String[])parameters.get("beneficiaryBirthDistrictName", String[].class)).beneficiaryBirthCountryCode((String[])parameters.get("beneficiaryBirthCountryCode", String[].class)).confirmationEmailAddress((String[])parameters.get("confirmationEmailAddress", String[].class)).confirmationSmsAddress((String[])parameters.get("confirmationSmsAddress", String[].class)).build();
        String documentName = (String)parameters.get("documentName", String.class);
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        this.assertParameters(documentName, dto);
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            List<ForeignBankTransferDto> bankTransfers = this.buildBankTransferList(dto, translator);
            this.elixirService.writeToFileForeignTransfer(bankTransfers, tempFile.getFile());
            this.archiveDocumentService.addNewDocumentToArchive(documentClassName, documentName, inputStream, context);
        }
        catch (IOException e) {
            throw new AcceptanceException("IO Exception occurred");
        }
        finally {
            tempFile.delete();
        }
    }

    private void assertParameters(String documentName, ForeignBankTransferParametersDto dto) throws AcceptanceException {
        try {
            ParameterAssertions.assertDocumentName(documentName);
            ParameterAssertions.assertEqualArrayLength(dto.getBeneficiaryBankCountryCode(), dto.getBeneficiaryCountryCode(), dto.getBeneficiaryBankSwiftCode(), dto.getAmount(), dto.getBeneficiaryCityName(), dto.getBeneficiaryName(), dto.getBeneficiaryAccountNumber(), dto.getPrincipalAccountNumber(), dto.getPaymentDetails(), dto.getBeneficiaryStreetName(), dto.getCurrency(), dto.getExecutionDate());
        }
        catch (IllegalArgumentException e) {
            throw new AcceptanceException(e.getMessage());
        }
    }

    private List<ForeignBankTransferDto> buildBankTransferList(ForeignBankTransferParametersDto dto, Translator t) {
        String prefix = "pluspekaosaintegrator.pluspekaosa.duals.ForeignBankTransfer.param.";
        LinkedList<ForeignBankTransferDto> list = new LinkedList<ForeignBankTransferDto>();
        IntStream.range(0, dto.getAmount().length).forEach(index -> {
            ElixirAssertions.assertCountryCode(dto.getBeneficiaryBankCountryCode()[index], t.getMessage(prefix + "beneficiaryBankCountryCode.name"));
            ElixirAssertions.assertCountryCode(dto.getBeneficiaryCountryCode()[index], t.getMessage(prefix + "beneficiaryCountryCode.name"));
            ElixirAssertions.assertSwiftCode(dto.getBeneficiaryBankSwiftCode()[index], t.getMessage(prefix + "beneficiaryBankSwiftCode.name"));
            ElixirAssertions.assertAmount(dto.getAmount()[index], t.getMessage(prefix + "amount.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryCityName()[index], t.getMessage(prefix + "beneficiaryCityName.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryName()[index], t.getMessage(prefix + "beneficiaryName.name"));
            ElixirAssertions.assertIbanAccountNumber(dto.getBeneficiaryAccountNumber()[index], t.getMessage(prefix + "beneficiaryAccountNumber.name"));
            ElixirAssertions.assertPolishAccountNumber(dto.getPrincipalAccountNumber()[index], t.getMessage(prefix + "principalAccountNumber.name"));
            ElixirAssertions.assertNotEmpty(dto.getPaymentDetails()[index], t.getMessage(prefix + "paymentDetails.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryStreetName()[index], t.getMessage(prefix + "beneficiaryStreetName.name"));
            ElixirAssertions.assertCurrency(dto.getCurrency()[index], t.getMessage(prefix + "currency.name"));
            ElixirAssertions.assertExecutionDate(dto.getExecutionDate()[index], t.getMessage(prefix + "executionDate.name"));
            list.add(ForeignBankTransferDto.builder().beneficiaryBankCountryCode(dto.getBeneficiaryBankCountryCode()[index]).beneficiaryCountryCode(dto.getBeneficiaryCountryCode()[index]).beneficiaryBankSwiftCode(dto.getBeneficiaryBankSwiftCode()[index]).amount(dto.getAmount()[index]).beneficiaryCityName(Formatter.substringAndReplace(dto.getBeneficiaryCityName()[index], 35, new String[0])).beneficiaryName(Formatter.substringAndReplace(dto.getBeneficiaryName()[index], 70, new String[0])).beneficiaryAccountNumber(dto.getBeneficiaryAccountNumber()[index]).principalAccountNumber(dto.getPrincipalAccountNumber()[index]).paymentDetails(Formatter.substringAndReplace(dto.getPaymentDetails()[index], 140, new String[0])).beneficiaryStreetName(Formatter.substringAndReplace(dto.getBeneficiaryStreetName()[index], 35, new String[0])).currency(dto.getCurrency()[index]).annotations(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getAnnotations(), index), 35, new String[0])).beneficiaryBankAddress(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryBankAddress(), index), 70, new String[0])).executionDate(dto.getExecutionDate()[index]).ignoreField(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getIgnoreField(), index), 140, new String[0])).statisticsCode("").paymentMethod(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getPaymentMethod(), index), 1, "0-9")).beneficiaryBankName(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryBankName(), index), 35, new String[0])).contactPerson("").costAccountingAccountNumber("").costAccountingMethod(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getCostAccountingMethod(), index), 1, "0-9")).signature(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getSignature(), index), 16, "A-Za-z", "0-9")).endToEndId(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getEndToEndId(), index), 35, new String[0])).contactPhoneNumber("").paymentMode(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getPaymentMode(), index), 3, "A-Za-z", "0-9")).contractorType(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getContractorType(), index), 2, "A-Za-z")).principalBicId(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getPrincipalBicId(), index), 11, "A-Za-z", "0-9")).principalOrganizationId(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getPrincipalOrganizationId(), index), 35, new String[0])).beneficiaryBicId(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryBicId(), index), 11, "A-Za-z", "0-9")).beneficiaryOrganizationId(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryOrganizationId(), index), 35, new String[0])).beneficiaryOtherId(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryOtherId(), index), 35, new String[0])).beneficiaryDateOfBirth(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryDateOfBirth(), index), 10, new String[0])).beneficiaryBirthCityName(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryBirthCityName(), index), 35, new String[0])).beneficiaryBirthDistrictName(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryBirthDistrictName(), index), 35, "A-Za-z")).beneficiaryBirthCountryCode(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryBirthCountryCode(), index), 2, "A-Za-z")).confirmationEmailAddress(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getConfirmationEmailAddress(), index), 70, new String[0])).confirmationSmsNumber(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getConfirmationSmsAddress(), index), 20, new String[0])).build());
        });
        return list;
    }
}

