/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.duals;

import com.suncode.plugin.pluspekaosaintegrator.Categories;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.services.ArchiveDocumentService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ElixirAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ParameterAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.DomesticBankTransferDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.dto.DomesticBankTransferParametersDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.services.ElixirService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils.Formatter;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.utils.ParamUtils;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="dist/pluspekaosa/duals/DomesticBankTransfer/pwe_dynamic_form.js")
public class DomesticBankTransfer {
    private static final Logger log = LoggerFactory.getLogger(DomesticBankTransfer.class);
    private static final String[] stringArrayParams = new String[]{"beneficiaryName", "beneficiaryAccountNumber", "principalAccountNumber", "paymentDetails", "ignoreField", "beneficiaryCityName", "signature", "processingType", "beneficiaryStreetName", "confirmationEmailAddress", "confirmationSmsNumber"};
    @Autowired
    private ElixirService elixirService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer")).name("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.name")).description("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.desc")).category(new Category[]{Categories.PLUS_PEKAO_SA})).icon((Icon)DivanteIcon.MONEY)).parameter().id("documentClassName").name("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.documentClassName.name").description("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.documentName.name").description("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("amount").name("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.amount.name").description("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.amount.desc").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("executionDate").name("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.executionDate.name").description("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.executionDate.desc").type((Type)Types.DATE_ARRAY).create();
        Arrays.stream(stringArrayParams).forEach(key -> {
            CommonDefinitionBuilder cfr_ignored_0 = (CommonDefinitionBuilder)builder.parameter().id(key).name("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param." + key + ".name").description("pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param." + key + ".desc").type((Type)Types.STRING_ARRAY).create();
        });
    }

    public void execute(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        this.run(parameters, workflowContext, translator);
    }

    public void set(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        this.run(parameters, workflowContext, translator);
    }

    private void run(Parameters parameters, WorkflowContext workflowContext, Translator translator) throws AcceptanceException {
        DomesticBankTransferParametersDto dto = DomesticBankTransferParametersDto.builder().amount((Double[])parameters.get("amount", Double[].class)).beneficiaryName((String[])parameters.get("beneficiaryName", String[].class)).beneficiaryAccountNumber((String[])parameters.get("beneficiaryAccountNumber", String[].class)).principalAccountNumber((String[])parameters.get("principalAccountNumber", String[].class)).paymentDetails((String[])parameters.get("paymentDetails", String[].class)).executionDate((LocalDate[])parameters.get("executionDate", LocalDate[].class)).ignoreField((String[])parameters.get("ignoreField", String[].class)).beneficiaryCityName((String[])parameters.get("beneficiaryCityName", String[].class)).signature((String[])parameters.get("signature", String[].class)).processingType((String[])parameters.get("processingType", String[].class)).beneficiaryStreetName((String[])parameters.get("beneficiaryStreetName", String[].class)).confirmationEmailAddress((String[])parameters.get("confirmationEmailAddress", String[].class)).confirmationSmsNumber((String[])parameters.get("confirmationSmsNumber", String[].class)).build();
        String documentName = (String)parameters.get("documentName", String.class);
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        this.assertParameters(documentName, dto);
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            List<DomesticBankTransferDto> bankTransfers = this.buildBankTransferList(dto, translator);
            this.elixirService.writeToFileDomesticTransfer(bankTransfers, tempFile.getFile());
            this.archiveDocumentService.addNewDocumentToArchive(documentClassName, documentName, inputStream, workflowContext);
        }
        catch (IOException e) {
            throw new AcceptanceException("IO Exception occurred");
        }
        finally {
            tempFile.delete();
        }
    }

    private void assertParameters(String documentName, DomesticBankTransferParametersDto dto) throws AcceptanceException {
        try {
            ParameterAssertions.assertDocumentName(documentName);
            ParameterAssertions.assertEqualArrayLength(dto.getAmount(), dto.getBeneficiaryName(), dto.getBeneficiaryAccountNumber(), dto.getPrincipalAccountNumber(), dto.getPaymentDetails(), dto.getExecutionDate());
        }
        catch (IllegalArgumentException e) {
            throw new AcceptanceException(e.getMessage());
        }
    }

    private List<DomesticBankTransferDto> buildBankTransferList(DomesticBankTransferParametersDto dto, Translator t) {
        String prefix = "pluspekaosaintegrator.pluspekaosa.duals.DomesticBankTransfer.param.";
        LinkedList<DomesticBankTransferDto> list = new LinkedList<DomesticBankTransferDto>();
        IntStream.range(0, dto.getAmount().length).forEach(index -> {
            ElixirAssertions.assertAmount(dto.getAmount()[index], t.getMessage(prefix + "amount.name"));
            ElixirAssertions.assertNotEmpty(dto.getBeneficiaryName()[index], t.getMessage(prefix + "beneficiaryName.name"));
            ElixirAssertions.assertPolishAccountNumber(dto.getBeneficiaryAccountNumber()[index], t.getMessage(prefix + "beneficiaryAccountNumber.name"));
            ElixirAssertions.assertPolishAccountNumber(dto.getPrincipalAccountNumber()[index], t.getMessage(prefix + "principalAccountNumber.name"));
            ElixirAssertions.assertNotEmpty(dto.getPaymentDetails()[index], t.getMessage(prefix + "paymentDetails.name"));
            ElixirAssertions.assertExecutionDate(dto.getExecutionDate()[index], t.getMessage(prefix + "executionDate.name"));
            list.add(DomesticBankTransferDto.builder().amount(dto.getAmount()[index]).beneficiaryName(Formatter.substringAndReplace(dto.getBeneficiaryName()[index], 70, new String[0])).beneficiaryAccountNumber(dto.getBeneficiaryAccountNumber()[index]).principalAccountNumber(dto.getPrincipalAccountNumber()[index]).paymentDetails(Formatter.substringAndReplace(dto.getPaymentDetails()[index], 140, new String[0])).executionDate(dto.getExecutionDate()[index]).ignoreField(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getIgnoreField(), index), 140, new String[0])).beneficiaryCityName(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryCityName(), index), 35, new String[0])).signature(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getSignature(), index), 16, "A-Za-z", "0-9")).processingType(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getProcessingType(), index), 2, "A-Za-z")).beneficiaryStreetName(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getBeneficiaryStreetName(), index), 35, new String[0])).confirmationEmailAddress(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getConfirmationEmailAddress(), index), 70, new String[0])).confirmationSmsNumber(Formatter.substringAndReplace(ParamUtils.getStringValue(dto.getConfirmationSmsNumber(), index), 20, new String[0])).build());
        });
        return list;
    }
}

