/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.duals;

import com.suncode.plugin.pluspekaosaintegrator.Categories;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.services.ArchiveDocumentService;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions.ParameterAssertions;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.elixir.services.ElixirService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="dist/pluspekaosa/duals/CustomBankTransfer/pwe_dynamic_form.js")
public class CustomBankTransfer {
    private static final Logger log = LoggerFactory.getLogger(CustomBankTransfer.class);
    @Autowired
    private ElixirService elixirService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer")).name("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.name")).description("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.desc")).icon((Icon)DivanteIcon.MONEY)).category(new Category[]{Categories.PLUS_PEKAO_SA})).parameter().id("documentClassName").name("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.documentClassName.name").description("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.documentClassName.desc").type((Type)Types.STRING).create()).parameter().id("documentName").name("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.documentName.name").description("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.documentName.desc").type((Type)Types.STRING).create()).parameter().id("fileHeaderLine").name("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.fileHeaderLine.name").description("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.fileHeaderLine.desc").type((Type)Types.BOOLEAN).create()).parameter().id("variable").name("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.param.variable.name").description("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.param.variable.desc").type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("key").name("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.key.name").description("pluspekaosaintegrator.pluspekaosa.duals.CustomBankTransfer.param.key.desc").type((Type)Types.STRING_ARRAY).create();
    }

    public void set(Parameters parameters, WorkflowContext workflowContext) throws AcceptanceException {
        this.run(parameters, workflowContext);
    }

    public void execute(Parameters parameters, WorkflowContext workflowContext) throws AcceptanceException {
        this.run(parameters, workflowContext);
    }

    public void run(Parameters parameters, WorkflowContext workflowContext) throws AcceptanceException {
        Variable[] variables = (Variable[])parameters.get("variable", Variable[].class);
        String[] keys = (String[])parameters.get("key", String[].class);
        LinkedHashMap<String, Variable> mappings = new LinkedHashMap<String, Variable>();
        IntStream.range(0, variables.length).forEach(i -> mappings.put(keys[i], variables[i]));
        Map<String, List<?>> converted = this.elixirService.convertFromRawData(mappings);
        String documentName = (String)parameters.get("documentName", String.class);
        Boolean fileHeaderLine = (Boolean)parameters.get("fileHeaderLine", Boolean.class);
        String documentClassName = (String)parameters.get("documentClassName", String.class);
        this.assertParameters(documentName, converted);
        TempFile tempFile = new TempFile();
        try (InputStream inputStream = tempFile.getInputStream();){
            this.elixirService.createBankTransferFile(converted, fileHeaderLine, tempFile.getFile());
            this.archiveDocumentService.addNewDocumentToArchive(documentClassName, documentName, inputStream, workflowContext);
        }
        catch (IOException e) {
            throw new AcceptanceException("IOException occurred!");
        }
        finally {
            tempFile.delete();
        }
    }

    private void assertParameters(String documentName, Map<String, List<?>> convertedMap) throws AcceptanceException {
        try {
            ParameterAssertions.assertDocumentName(documentName);
            ParameterAssertions.assertEqualArrayLength(convertedMap.values());
            this.elixirService.validate(convertedMap);
        }
        catch (IllegalArgumentException e) {
            throw new AcceptanceException(e.getMessage());
        }
    }
}

