/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.assertions;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class ElixirAssertions {
    private static final String ALPHANUMERIC_SPECIAL_CHARS = "[Aa\u0104\u0105BbCc\u0106\u0107DdEe\u0118\u0119FfGgHhIiJjKkLl\u0141\u0142MmNn\u0143\u0144Oo\u00d3\u00f3PpQqRrSs\u015a\u015bTtUuVvWwXxYyZz\u0179\u017a\u017b\u017c0-9/\\-?:().,'+\\s\\\\]";
    private static final String ALPHANUMERIC = "[Aa\u0104\u0105BbCc\u0106\u0107DdEe\u0118\u0119FfGgHhIiJjKkLl\u0141\u0142MmNn\u0143\u0144Oo\u00d3\u00f3PpQqRrSs\u015a\u015bTtUuVvWwXxYyZz\u0179\u017a\u017b\u017c0-9]";
    private static final String NUMERIC = "[0-9]";

    public static void assertNumeric(String value, String name, int maxLength, boolean optional, boolean fixedLength) {
        ElixirAssertions.checkOptional(value, name, optional);
        ElixirAssertions.checkFixedLength(value, name, maxLength, fixedLength);
        if (!value.matches("^[0-9]{0," + maxLength + "}$")) {
            throw new IllegalArgumentException("\"" + name + "\" must have " + maxLength + " numeric characters at most: " + value);
        }
    }

    public static void assertAlphanumericSpecialChars(String value, String name, int maxLength, boolean optional, boolean fixedLength) {
        ElixirAssertions.checkOptional(value, name, optional);
        ElixirAssertions.checkFixedLength(value, name, maxLength, fixedLength);
        if (!value.matches("^[Aa\u0104\u0105BbCc\u0106\u0107DdEe\u0118\u0119FfGgHhIiJjKkLl\u0141\u0142MmNn\u0143\u0144Oo\u00d3\u00f3PpQqRrSs\u015a\u015bTtUuVvWwXxYyZz\u0179\u017a\u017b\u017c0-9/\\-?:().,'+\\s\\\\]{0," + maxLength + "}$")) {
            throw new IllegalArgumentException("\"" + name + "\" must have " + maxLength + " alphanumeric with allowed special characters at most: " + value);
        }
    }

    public static void assertAlphanumeric(String value, String name, int maxLength, boolean optional, boolean fixedLength) {
        ElixirAssertions.checkOptional(value, name, optional);
        ElixirAssertions.checkFixedLength(value, name, maxLength, fixedLength);
        if (!value.matches("^[Aa\u0104\u0105BbCc\u0106\u0107DdEe\u0118\u0119FfGgHhIiJjKkLl\u0141\u0142MmNn\u0143\u0144Oo\u00d3\u00f3PpQqRrSs\u015a\u015bTtUuVvWwXxYyZz\u0179\u017a\u017b\u017c0-9]{0," + maxLength + "}$")) {
            throw new IllegalArgumentException("\"" + name + "\" must have " + maxLength + " alphanumeric characters at most: " + value);
        }
    }

    public static void assertNonNull(Object value, String name) {
        if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) {
            throw new IllegalArgumentException("\"" + name + "\" is mandatory");
        }
    }

    private static void checkOptional(String value, String name, boolean optional) {
        if (!optional && StringUtils.isBlank((CharSequence)value)) {
            throw new IllegalArgumentException("\"" + name + "\" is mandatory");
        }
    }

    private static void checkFixedLength(String value, String name, int length, boolean fixedLength) {
        if (fixedLength && StringUtils.trimToEmpty((String)value).length() != length) {
            throw new IllegalArgumentException("\"" + name + "\" must be exactly " + length + " characters");
        }
    }

    public static void assertNotEmpty(String param, String name) {
        if (StringUtils.isBlank((CharSequence)param)) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void assertNotEmpty(Integer param, String name) {
        if (param == null) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void assertNotEmpty(Object value, String name) {
        if (StringUtils.isBlank((CharSequence)((String)value))) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    public static void assertEmpty(Object value, String name) {
        if (StringUtils.isNotBlank((CharSequence)((String)value))) {
            throw new IllegalArgumentException(name + " must be empty");
        }
    }

    public static void assertAmount(Object amount, String name) {
        if (amount == null || (Double)amount <= 0.0) {
            throw new IllegalArgumentException(name + " must be greater than 0");
        }
    }

    public static void assertVatAmount(Object vatAmount, String name) {
        if (vatAmount == null || (Double)vatAmount < 0.0) {
            throw new IllegalArgumentException(name + " must be greater or equal than 0");
        }
    }

    public static void assertExecutionDate(Object executionDate, String name) {
        LocalDate date = new LocalDate(executionDate);
        if (date.isBefore((ReadablePartial)LocalDate.now())) {
            throw new IllegalArgumentException(name + " cannot be set in the past");
        }
    }

    public static void assertSwiftCode(Object swiftCode, String name) {
        String code = (String)swiftCode;
        ElixirAssertions.assertNotEmpty(code, name);
        if (!code.matches("^[0-9A-Za-z]{1,11}$")) {
            throw new IllegalArgumentException("Wrong SWIFT code format: " + code);
        }
    }

    public static void assertCountryCode(Object countryCode, String name) {
        String code = (String)countryCode;
        ElixirAssertions.assertNotEmpty(code, name);
        if (!code.matches("^[A-Za-z]{2}$")) {
            throw new IllegalArgumentException("Wrong country code format: " + code);
        }
    }

    public static void assertCurrency(Object currency, String name) {
        String value = (String)currency;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[A-Z]{3}$")) {
            throw new IllegalArgumentException("Wrong currency format: " + value);
        }
    }

    public static void assertPolishAccountNumber(Object accountNumber, String name) {
        String value = (String)accountNumber;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[Pp][Ll][0-9]{26}$") && !value.matches("^[0-9]{26}$")) {
            throw new IllegalArgumentException("Wrong polish account number format: " + value);
        }
    }

    public static void assertIbanAccountNumber(Object accountNumber, String name) {
        String value = (String)accountNumber;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[A-Za-z0-9]{1,34}$")) {
            throw new IllegalArgumentException("Wrong account number format: " + value);
        }
    }

    public static void assertTransferType(Object transferType, String name) {
        String value = (String)transferType;
        ElixirAssertions.assertNotEmpty(value, name);
        if (!value.matches("^[ZzPpSs][Vv]?$")) {
            throw new IllegalArgumentException("Incorrect transfer type value");
        }
    }

    private ElixirAssertions() {
    }
}

