/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.services;

import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.dto.DocumentClassDto;
import com.suncode.plugin.pluspekaosaintegrator.pluspekaosa.archive.services.ArchiveDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.workflow.WorkflowContext;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ArchiveDocumentServiceImpl
implements ArchiveDocumentService {
    private static final String USER_LOGIN = "admin";
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;

    @Override
    public void addNewDocumentToArchive(String documentClassName, String documentName, InputStream inputStream, WorkflowContext workflowContext) {
        DocumentClass documentClass = this.documentClassService.getDocumentClass(documentClassName, new String[0]);
        Assert.notNull((Object)documentClass, (String)("Document Class: '" + documentClassName + "' doesn't exist"));
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(documentClass.getId());
        documentDefinition.setProcessId(workflowContext.getProcessId());
        documentDefinition.setInputStream(inputStream);
        documentDefinition.setUserName(USER_LOGIN);
        documentDefinition.setFileName(documentName);
        documentDefinition.setActivityId(workflowContext.getActivityId());
        this.documentService.addDocument(documentDefinition);
    }

    @Override
    public CountedResult<DocumentClassDto> getDocumentClasses(String query, Integer start, Integer limit) {
        List documentClasses = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((CharSequence)documentClass.getName(), (CharSequence)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        if (documentClasses.size() >= start) {
            result.setData(documentClasses.subList(start, Integer.min(start + limit, documentClasses.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        result.setTotal((long)documentClasses.size());
        return this.convertDocClassToDto((CountedResult<DocumentClass>)result);
    }

    private CountedResult<DocumentClassDto> convertDocClassToDto(CountedResult<DocumentClass> documentClasses) {
        List data = documentClasses.getData().stream().map(DocumentClassDto::fromEntity).collect(Collectors.toList());
        return new CountedResult(documentClasses.getTotal(), data);
    }
}

