/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.dto.ConnectionConfigurationDto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationService {
    public static final String PCM_CONFIGURATION_FILE_ID = "config";
    private final ObjectMapper mapper = new ObjectMapper();
    private final ConfigurationFileService configurationFileService;
    private final Plugin plugin;

    @Autowired
    public ConfigurationService(ConfigurationFileService configurationFileService, Plugin plugin) {
        this.configurationFileService = configurationFileService;
        this.plugin = plugin;
    }

    public ConnectionConfigurationDto readConfigurationFile() throws IOException {
        try (InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), PCM_CONFIGURATION_FILE_ID);){
            String configuration = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            ConnectionConfigurationDto connectionConfigurationDto = (ConnectionConfigurationDto)this.mapper.readValue(configuration, ConnectionConfigurationDto.class);
            return connectionConfigurationDto;
        }
    }
}

