/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusoptimaintegrator.optima.applications;

import com.suncode.plugin.plusoptimaintegrator.Categories;
import com.suncode.plugin.plusoptimaintegrator.exceptions.PlusOptimaIntegratorException;
import com.suncode.plugin.plusoptimaintegrator.optima.applications.parameters.ExportInvoiceToOptimaApplicationParameters;
import com.suncode.plugin.plusoptimaintegrator.optima.client.OptimaExecutor;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.AttributeDto;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.ContractorPaymentDto;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.DecreePositionDto;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.InvoiceDto;
import com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.dto.ConnectionConfigurationDto;
import com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.services.ConfigurationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.Parameters;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/optima/applications/ExportInvoiceToOptimaApplication/pwe_dynamic_form.js")
public class ExportInvoiceToOptimaApplication {
    private static final Logger log = LoggerFactory.getLogger(ExportInvoiceToOptimaApplication.class);
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private OptimaExecutor optimaExecutor;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication")).name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.name")).description("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.desc")).category(new Category[]{Categories.OPTIMA})).icon((Icon)DivanteIcon.DOCUMENT2)).parameter().id("invoiceNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.invoiceNumber.name").type((Type)Types.STRING).create()).parameter().id("supplierNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.supplierNumber.name").type((Type)Types.STRING).create()).parameter().id("dateOfIssueOfTheDocument").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.dateOfIssueOfTheDocument.name").type((Type)Types.STRING).create()).parameter().id("documentReceiptDate").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.documentReceiptDate.name").type((Type)Types.STRING).create()).parameter().id("purchaseDate").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.purchaseDate.name").type((Type)Types.STRING).create()).parameter().id("paymentDeadline").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.paymentDeadline.name").type((Type)Types.STRING).create()).parameter().id("costDocumentDescription").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.costDocumentDescription.name").type((Type)Types.STRING).optional().create()).parameter().id("currency").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.currency.name").type((Type)Types.STRING).create()).parameter().id("grossAmountInCurrency").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.grossAmountInCurrency.name").type((Type)Types.FLOAT).create()).parameter().id("netAmountInCurrency").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.netAmountInCurrency.name").type((Type)Types.FLOAT).create()).parameter().id("paymentMethod").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.paymentMethod.name").type((Type)Types.STRING).create()).parameter().id("category").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.category.name").type((Type)Types.STRING).optional().create()).parameter().id("mainCategory").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.mainCategory.name").type((Type)Types.STRING).optional().create()).parameter().id("registerName").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.registerName.name").type((Type)Types.STRING).create()).parameter().id("registerType").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.registerType.name").type((Type)Types.INTEGER).create()).parameter().id("ksefNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.ksefNumber.name").type((Type)Types.STRING).optional().create()).parameter().id("ksefRegistrationDate").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.ksefRegistrationDate.name").type((Type)Types.STRING).optional().create()).parameter().id("bankAccountNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.bankAccountNumber.name").type((Type)Types.STRING).optional().create()).parameter().id("bankAccountNumberIdentifier").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.bankAccountNumberIdentifier.name").type((Type)Types.INTEGER).optional().create()).parameter().id("payerIdentifier").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.payerIdentifier.name").type((Type)Types.STRING).optional().create()).parameter().id("cashMethod").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.cashMethod.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("jpkFa").name("JPK_FA").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("settleVat").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.settleVat.name").type((Type)Types.STRING).defaultValue((Object)"DO_NOT_PASS").create()).parameter().id("settleVat27").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.settleVat27.name").type((Type)Types.STRING).defaultValue((Object)"DO_NOT_PASS").create()).parameter().id("settleVatUe").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.settleVatUe.name").type((Type)Types.STRING).defaultValue((Object)"DO_NOT_PASS").create()).parameter().id("splitPayment").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.splitPayment.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("payerType").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.payerType.name").type((Type)Types.STRING).optional().create()).parameter().id("applyCorrection").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.applyCorrection.name").type((Type)Types.BOOLEAN).defaultValue((Object)false).create()).parameter().id("correction").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.correction.name").type((Type)Types.STRING).optional().create()).parameter().id("contractorBankAcronym").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorBankAcronym.name").type((Type)Types.STRING).optional().create()).parameter().id("contractorBankNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorBankNumber.name").type((Type)Types.STRING).optional().create()).parameter().id("contractorBankName").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorBankName.name").type((Type)Types.STRING).optional().create()).parameter().id("contractorForeignBankAccount").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorForeignBankAccount.name").type((Type)Types.BOOLEAN).optional().create()).parameter().id("contractorSwiftBankAccountNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorSwiftBankAccountNumber.name").type((Type)Types.STRING).optional().create()).parameter().id("attributeId").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.attributeId.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("attributeName").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.attributeName.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("attributeValue").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.attributeValue.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("contractorPaymentAmount").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorPaymentAmount.name").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("contractorPaymentMethod").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorPaymentMethod.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("contractorPaymentDeadline").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorPaymentDeadline.name").type((Type)Types.DATE_ARRAY).create()).parameter().id("contractorPaymentCurrency").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.contractorPaymentCurrency.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("MPKNumber").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.MPKNumber.name").description("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.MPKNumber.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("account").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.account.name").description("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.account.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("positionDescription").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.positionDescription.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("VATRate").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.VATRate.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("VATAmount").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.VATAmount.name").type((Type)Types.FLOAT_ARRAY).optional().create()).parameter().id("positionGrossAmount").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.positionGrossAmount.name").type((Type)Types.FLOAT_ARRAY).optional().create()).parameter().id("positionNetAmount").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.positionNetAmount.name").type((Type)Types.FLOAT_ARRAY).optional().create()).parameter().id("costType").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.costType.name").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("deduction").name("plusoptimaintegrator.optima.application.ExportInvoiceToOptimaApplication.param.deduction.name").type((Type)Types.STRING_ARRAY).optional().create();
    }

    public void execute(ApplicationContext context, Parameters parameters, Translator translator) throws AcceptanceException {
        ExportInvoiceToOptimaApplicationParameters applicationParameters = new ExportInvoiceToOptimaApplicationParameters(parameters);
        try {
            this.validatePassedParameters(applicationParameters);
            InvoiceDto invoice = this.createInvoice(applicationParameters);
            this.sendInvoiceToOptima(invoice);
        }
        catch (PlusOptimaIntegratorException e) {
            log.error("An error occurred within ExportInvoiceToOptimaApplication application in process id: " + context.getProcessId() + ", activity id: " + context.getActivityId());
            throw new AcceptanceException(translator.getMessage(e.getTranslatorKey()), (Throwable)e);
        }
    }

    private void validatePassedParameters(ExportInvoiceToOptimaApplicationParameters applicationParameters) throws PlusOptimaIntegratorException {
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getInvoiceNumber()), (String)"Invoice number is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getSupplierNumber()), (String)"Supplier number is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getDateOfIssueOfTheDocument()), (String)"Date of issue of the document is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getDocumentReceiptDate()), (String)"Document receipt date is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getPurchaseDate()), (String)"Purchase date is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getPaymentDeadline()), (String)"Payment deadline is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getCurrency()), (String)"Currency is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getPaymentMethod()), (String)"Payment method is null, empty or whitespace only");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getRegisterName()), (String)"Register name is null, empty or whitespace only");
            if (applicationParameters.getApplyCorrection().booleanValue()) {
                Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)applicationParameters.getCorrection()), (String)"Correction is null, empty or whitespace only");
            }
            Assert.isTrue((applicationParameters.getMPKNumber().length > 0 ? 1 : 0) != 0, (String)"MPK number is empty column");
            int decreeColumnLength = applicationParameters.getMPKNumber().length;
            Assert.isTrue((applicationParameters.getAccount().length == decreeColumnLength ? 1 : 0) != 0, (String)"Account has a different length than the other columns");
            Assert.isTrue((applicationParameters.getPositionDescription().length == decreeColumnLength ? 1 : 0) != 0, (String)"Position description has a different length than the other columns");
            Assert.isTrue((applicationParameters.getVATRate().length == decreeColumnLength ? 1 : 0) != 0, (String)"VAT rate has a different length than the other columns");
            Assert.isTrue((applicationParameters.getVATAmount().length == decreeColumnLength ? 1 : 0) != 0, (String)"VAT amount has a different length than the other columns");
            Assert.isTrue((applicationParameters.getPositionGrossAmount().length == decreeColumnLength ? 1 : 0) != 0, (String)"Position gross amount has a different length than the other columns");
            Assert.isTrue((applicationParameters.getPositionNetAmount().length == decreeColumnLength ? 1 : 0) != 0, (String)"Position net amount has a different length than the other columns");
            Assert.isTrue((applicationParameters.getCostType().length == decreeColumnLength ? 1 : 0) != 0, (String)"Cost type has a different length than the other columns");
            Assert.isTrue((applicationParameters.getDeduction().length == decreeColumnLength ? 1 : 0) != 0, (String)"Deduction has a different length than the other columns");
        }
        catch (IllegalArgumentException e) {
            String message = "Incorrect passed parameter values";
            PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
            plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.passedParameterValuesFailure.errorMessage");
            throw plusOptimaIntegratorException;
        }
    }

    private InvoiceDto createInvoice(ExportInvoiceToOptimaApplicationParameters applicationParameters) {
        ArrayList<DecreePositionDto> decreePositionList = new ArrayList<DecreePositionDto>();
        IntStream.range(0, applicationParameters.getMPKNumber().length).forEach(row -> {
            DecreePositionDto decreePosition = this.createDecreePosition(applicationParameters, row);
            decreePositionList.add(decreePosition);
        });
        return InvoiceDto.builder().invoiceNumber(applicationParameters.getInvoiceNumber()).supplierNumber(applicationParameters.getSupplierNumber()).dateOfIssueOfTheDocument(applicationParameters.getDateOfIssueOfTheDocument()).documentReceiptDate(applicationParameters.getDocumentReceiptDate()).purchaseDate(applicationParameters.getPurchaseDate()).paymentDeadline(applicationParameters.getPaymentDeadline()).costDocumentDescription(applicationParameters.getCostDocumentDescription()).currency(applicationParameters.getCurrency()).netAmountInCurrency(applicationParameters.getNetAmountInCurrency()).grossAmountInCurrency(applicationParameters.getGrossAmountInCurrency()).paymentMethod(applicationParameters.getPaymentMethod()).category(applicationParameters.getCategory()).mainCategory(applicationParameters.getMainCategory()).registerName(applicationParameters.getRegisterName()).registerType(applicationParameters.getRegisterType()).ksefNumber(applicationParameters.getKsefNumber()).ksefRegistrationDate(applicationParameters.getKsefRegistrationDate()).bankAccountNumber(applicationParameters.getBankAccountNumber()).bankAccountNumberIdentifier(applicationParameters.getBankAccountNumberIdentifier()).payerIdentifier(applicationParameters.getPayerIdentifier()).cashMethod(applicationParameters.getCashMethod()).jpkFa(applicationParameters.getJpkFa()).settleVat(applicationParameters.getSettleVat().equalsIgnoreCase("DO_NOT_PASS") ? null : Boolean.valueOf(applicationParameters.getSettleVat())).settleVat27(applicationParameters.getSettleVat27().equalsIgnoreCase("DO_NOT_PASS") ? null : Boolean.valueOf(applicationParameters.getSettleVat27())).settleVatUe(applicationParameters.getSettleVatUe().equalsIgnoreCase("DO_NOT_PASS") ? null : Boolean.valueOf(applicationParameters.getSettleVatUe())).splitPayment(applicationParameters.getSplitPayment()).payerType(applicationParameters.getPayerType()).applyCorrection(applicationParameters.getApplyCorrection()).correction(applicationParameters.getCorrection()).contractorBankAcronym(applicationParameters.getContractorBankAcronym()).contractorBankNumber(applicationParameters.getContractorBankNumber()).contractorBankName(applicationParameters.getContractorBankName()).contractorForeignBankAccount(applicationParameters.getContractorForeignBankAccount()).contractorSwiftBankAccountNumber(applicationParameters.getContractorSwiftBankAccountNumber()).attributes(applicationParameters.getAttributeId().length == 0 ? Collections.emptyList() : this.createAttributeList(applicationParameters.getAttributeId(), applicationParameters.getAttributeName(), applicationParameters.getAttributeValue())).contractorPayments(applicationParameters.getContractorPaymentAmount().length == 0 ? Collections.emptyList() : this.createContractorPaymentList(applicationParameters.getContractorPaymentAmount(), applicationParameters.getContractorPaymentMethod(), applicationParameters.getContractorPaymentDeadline(), applicationParameters.getContractorPaymentCurrency())).decreePositions(decreePositionList).build();
    }

    private List<AttributeDto> createAttributeList(String[] ids, String[] names, String[] values) {
        Assert.isTrue((ids.length == names.length && ids.length == values.length ? 1 : 0) != 0, (String)"Attribute length parameters mismatch");
        return IntStream.range(0, ids.length).boxed().map(index -> AttributeDto.builder().id(ids[index]).name(names[index]).value(values[index]).build()).collect(Collectors.toList());
    }

    private List<ContractorPaymentDto> createContractorPaymentList(Double[] amounts, String[] paymentMethods, LocalDate[] paymentDeadlines, String[] currencies) {
        Assert.isTrue((amounts.length == paymentMethods.length && amounts.length == paymentDeadlines.length && amounts.length == currencies.length ? 1 : 0) != 0, (String)"Contractor payment length parameters mismatch");
        return IntStream.range(0, amounts.length).boxed().map(index -> ContractorPaymentDto.builder().amount(amounts[index]).paymentMethod(paymentMethods[index]).paymentDeadline(paymentDeadlines[index]).currency(currencies[index]).build()).collect(Collectors.toList());
    }

    private DecreePositionDto createDecreePosition(ExportInvoiceToOptimaApplicationParameters applicationParameters, int row) {
        return DecreePositionDto.builder().MPKNumber(applicationParameters.getMPKNumber()[row]).account(applicationParameters.getAccount()[row]).positionDescription(applicationParameters.getPositionDescription()[row]).VATRate(applicationParameters.getVATRate()[row]).VATAmount(applicationParameters.getVATAmount()[row]).positionGrossAmount(applicationParameters.getPositionGrossAmount()[row]).positionNetAmount(applicationParameters.getPositionNetAmount()[row]).costType(applicationParameters.getCostType()[row]).deduction(applicationParameters.getDeduction()[row]).build();
    }

    private void sendInvoiceToOptima(InvoiceDto invoice) throws PlusOptimaIntegratorException {
        try {
            ConnectionConfigurationDto connectionConfiguration = this.configurationService.readConfigurationFile();
            this.optimaExecutor.executeWithLogin(connectionConfiguration, client -> client.sendInvoiceToVATRegister(invoice));
        }
        catch (IOException e) {
            String message = "Incorrect JSON configuration of the connection to the CDN Optima system in the Plugin Configuration Manager panel";
            PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
            plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.pluginConfigurationManagerJsonFailure.errorMessage");
            throw plusOptimaIntegratorException;
        }
    }
}

