/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusoptimaintegrator.optima.client;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.suncode.plugin.plusoptimaintegrator.exceptions.PlusOptimaIntegratorException;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.InvoiceDto;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.VacationDto;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceClient {
    private static final Logger log = LoggerFactory.getLogger(WebServiceClient.class);
    private final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JodaModule());
    private Client client;

    public WebServiceClient(String wsdlURL) throws PlusOptimaIntegratorException {
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
            this.client = dcf.createClient(wsdlURL);
        }
        catch (Exception e) {
            String message = "An error occured while trying to initiate connection to the CDN Optima system";
            PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
            plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.webServiceConnectionFailure.errorMessage");
            throw plusOptimaIntegratorException;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
    }

    public void loginToOptima(String username, String password, String company) throws PlusOptimaIntegratorException {
        this.doInPluginContextClassLoader(() -> {
            try {
                Object[] res = this.client.invoke("LoginToOptima", new Object[]{username, password, company});
                if (res.length <= 0 || ((String)res[0]).compareToIgnoreCase("OK") != 0) {
                    throw new Exception("Login failure");
                }
                log.debug("Successfully logged into the CDN Optima system");
            }
            catch (Exception e) {
                String message = "An error occured while trying to log into the CDN Optima system";
                PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
                plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.loginFailure.errorMessage");
                throw plusOptimaIntegratorException;
            }
        });
    }

    public void logoutFromOptima() throws PlusOptimaIntegratorException {
        this.doInPluginContextClassLoader(() -> {
            try {
                Object[] res = this.client.invoke("LogoutFromOptima", new Object[0]);
                if (res.length <= 0 || ((String)res[0]).compareToIgnoreCase("OK") != 0) {
                    throw new Exception("Logout failure");
                }
                log.debug("Successfully logged out of the CDN Optima system");
            }
            catch (Exception e) {
                String message = "An error occured while trying to log out of the CDN Optima system";
                PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
                plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.logoutFailure.errorMessage");
                throw plusOptimaIntegratorException;
            }
        });
    }

    public void sendInvoiceToVATRegister(InvoiceDto invoice) throws PlusOptimaIntegratorException {
        this.doInPluginContextClassLoader(() -> {
            try {
                String json = this.mapper.writeValueAsString((Object)invoice);
                Object[] res = this.client.invoke("DodajPozycjeDoRejestruVAT", new Object[]{json});
                if (res.length <= 0 || ((String)res[0]).compareToIgnoreCase("OK") != 0) {
                    throw new Exception("Error in sendInvoiceToOptima() : " + res[0]);
                }
                log.debug("The invoice was successfully sent to VAT register");
            }
            catch (Exception e) {
                String message = "An error occured while trying to send invoice to VAT register";
                PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
                plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.invoiceSendingToVatRegisterFailure.errorMessage");
                throw plusOptimaIntegratorException;
            }
        });
    }

    public void sendVacationToOptima(VacationDto vacation) throws PlusOptimaIntegratorException {
        this.doInPluginContextClassLoader(() -> {
            try {
                String json = this.mapper.writeValueAsString((Object)vacation);
                Object[] res = this.client.invoke("DodanieUrlopu", new Object[]{json});
                if (res.length <= 0 || ((String)res[0]).compareToIgnoreCase("OK") != 0) {
                    throw new Exception("Error in sendVacationToOptima : " + res[0]);
                }
                log.debug("The vacation was successfully sent to CDN Optima system");
            }
            catch (Exception e) {
                String message = "An error occured while trying to send vacation to CDN Optima system";
                PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
                plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.sendingVacationToOptimaFailure.errorMessage");
                throw plusOptimaIntegratorException;
            }
        });
    }

    private void doInPluginContextClassLoader(OptimaRunnable runnable) throws PlusOptimaIntegratorException {
        ClassLoader previousContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousContextClassLoader);
        }
    }

    private static interface OptimaRunnable {
        public void run() throws PlusOptimaIntegratorException;
    }
}

