/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusoptimaintegrator.optima.client;

import com.suncode.plugin.plusoptimaintegrator.exceptions.PlusOptimaIntegratorException;
import com.suncode.plugin.plusoptimaintegrator.optima.client.WebServiceClient;
import com.suncode.plugin.plusoptimaintegrator.optima.client.support.ThrowingConsumer;
import com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.dto.ConnectionConfigurationDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class OptimaExecutor {
    private static final Logger log = LoggerFactory.getLogger(OptimaExecutor.class);
    private final Object $lock = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWithLogin(ConnectionConfigurationDto connectionConfiguration, ThrowingConsumer<WebServiceClient, PlusOptimaIntegratorException> operation) throws PlusOptimaIntegratorException {
        Object object = this.$lock;
        synchronized (object) {
            WebServiceClient client = new WebServiceClient(connectionConfiguration.getWsdlURL());
            log.info("A connection has been established to the system with the address:" + connectionConfiguration.getWsdlURL());
            client.loginToOptima(connectionConfiguration.getUsername(), connectionConfiguration.getPassword(), connectionConfiguration.getCompany());
            try {
                operation.accept(client);
            }
            finally {
                client.logoutFromOptima();
            }
        }
    }
}

