/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusoptimaintegrator.optima.applications;

import com.suncode.plugin.plusoptimaintegrator.Categories;
import com.suncode.plugin.plusoptimaintegrator.exceptions.PlusOptimaIntegratorException;
import com.suncode.plugin.plusoptimaintegrator.optima.client.OptimaExecutor;
import com.suncode.plugin.plusoptimaintegrator.optima.dto.VacationDto;
import com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.dto.ConnectionConfigurationDto;
import com.suncode.plugin.plusoptimaintegrator.pluginconfigurationmanager.services.ConfigurationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/optima/applications/ExportVacationToOptimaApplication/pwe_dynamic_form.js")
public class ExportVacationToOptimaApplication {
    private static final Logger log = LoggerFactory.getLogger(ExportVacationToOptimaApplication.class);
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private OptimaExecutor optimaExecutor;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication")).name("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication.name")).description("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication.desc")).icon((Icon)DivanteIcon.FILE)).category(new Category[]{Categories.OPTIMA})).parameter().id("employeeNumber").name("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication.param.employeeNumber.name").type((Type)Types.STRING).create()).parameter().id("vacationType").name("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication.param.vacationType.name").type((Type)Types.STRING).create()).parameter().id("vacationStartDate").name("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication.param.vacationStartDate.name").type((Type)Types.STRING).create()).parameter().id("vacationEndDate").name("plusoptimaintegrator.optima.application.ExportVacationToOptimaApplication.param.vacationEndDate.name").type((Type)Types.STRING).create();
    }

    public void execute(ApplicationContext context, Translator translator, @Param String employeeNumber, @Param String vacationType, @Param String vacationStartDate, @Param String vacationEndDate) throws AcceptanceException {
        try {
            this.validatePassedParameters(employeeNumber, vacationType, vacationStartDate, vacationEndDate);
            VacationDto vacation = this.createVacation(employeeNumber, vacationType, vacationStartDate, vacationEndDate);
            this.sendVacationToOptima(vacation);
        }
        catch (PlusOptimaIntegratorException e) {
            log.error("An error occurred within ExportVacationToOptimaApplication application in process id: " + context.getProcessId() + ", activity id: " + context.getActivityId());
            throw new AcceptanceException(translator.getMessage(e.getTranslatorKey()), (Throwable)e);
        }
    }

    private void validatePassedParameters(String employeeNumber, String vacationType, String startDate, String endDate) throws PlusOptimaIntegratorException {
        try {
            Assert.isTrue((!employeeNumber.isEmpty() ? 1 : 0) != 0, (String)"Employee number is empty");
            Assert.isTrue((!vacationType.isEmpty() ? 1 : 0) != 0, (String)"Vacation type is empty");
            Assert.isTrue((!startDate.isEmpty() ? 1 : 0) != 0, (String)"Vacation start date is empty");
            Assert.isTrue((!endDate.isEmpty() ? 1 : 0) != 0, (String)"Vacation end date is empty");
        }
        catch (IllegalArgumentException e) {
            String message = "Incorrect passed parameter values";
            PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
            plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.passedParameterValuesFailure.errorMessage");
            throw plusOptimaIntegratorException;
        }
    }

    private VacationDto createVacation(String employeeNumber, String vacationType, String vacationStartDate, String vacationEndDate) {
        return VacationDto.builder().employeeNumber(employeeNumber).vacationType(vacationType).startDate(vacationStartDate).endDate(vacationEndDate).build();
    }

    private void sendVacationToOptima(VacationDto vacation) throws PlusOptimaIntegratorException {
        try {
            ConnectionConfigurationDto connectionConfiguration = this.configurationService.readConfigurationFile();
            this.optimaExecutor.executeWithLogin(connectionConfiguration, client -> client.sendVacationToOptima(vacation));
        }
        catch (IOException e) {
            String message = "Incorrect JSON configuration of the connection to the CDN Optima system in the Plugin Configuration Manager panel";
            PlusOptimaIntegratorException plusOptimaIntegratorException = new PlusOptimaIntegratorException(message, e);
            plusOptimaIntegratorException.setTranslatorKey("plusoptimaintegrator.exception.pluginConfigurationManagerJsonFailure.errorMessage");
            throw plusOptimaIntegratorException;
        }
    }
}

