/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusoptimaintegrator.optima.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import org.joda.time.LocalDate;

public class ContractorPaymentDto {
    @JsonProperty(value="kwotaPlatnosci")
    private Double amount;
    @JsonProperty(value="formaPlatnosci")
    private String paymentMethod;
    @JsonProperty(value="terminPlatnosci")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private LocalDate paymentDeadline;
    @JsonProperty(value="walutaPlatnosci")
    private String currency;

    public static ContractorPaymentDtoBuilder builder() {
        return new ContractorPaymentDtoBuilder();
    }

    @ConstructorProperties(value={"amount", "paymentMethod", "paymentDeadline", "currency"})
    public ContractorPaymentDto(Double amount, String paymentMethod, LocalDate paymentDeadline, String currency) {
        this.amount = amount;
        this.paymentMethod = paymentMethod;
        this.paymentDeadline = paymentDeadline;
        this.currency = currency;
    }

    public static class ContractorPaymentDtoBuilder {
        private Double amount;
        private String paymentMethod;
        private LocalDate paymentDeadline;
        private String currency;

        ContractorPaymentDtoBuilder() {
        }

        public ContractorPaymentDtoBuilder amount(Double amount) {
            this.amount = amount;
            return this;
        }

        public ContractorPaymentDtoBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public ContractorPaymentDtoBuilder paymentDeadline(LocalDate paymentDeadline) {
            this.paymentDeadline = paymentDeadline;
            return this;
        }

        public ContractorPaymentDtoBuilder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public ContractorPaymentDto build() {
            return new ContractorPaymentDto(this.amount, this.paymentMethod, this.paymentDeadline, this.currency);
        }

        public String toString() {
            return "ContractorPaymentDto.ContractorPaymentDtoBuilder(amount=" + this.amount + ", paymentMethod=" + this.paymentMethod + ", paymentDeadline=" + this.paymentDeadline + ", currency=" + this.currency + ")";
        }
    }
}

