/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV2;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV3;
import com.suncode.plugin.plusksef.invoice.model.ksefV2.FakturaV2;
import com.suncode.plugin.plusksef.invoice.model.ksefV2.FakturaV2ExportSchema;
import com.suncode.plugin.plusksef.invoice.model.ksefV3.FakturaV3;
import com.suncode.plugin.plusksef.invoice.model.ksefV3.FakturaV3ExportSchema;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.ArrayType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/GenerateKSeFInvoice/pwe_dynamic_form.js")
public class GenerateKSeFInvoice {
    private static final String ID = "plusksef.autotask.GenerateKSeFInvoice";
    private static final String KSEF_INVOICE_FILENAME = "ksef_invoice.xml";
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private FileService fileService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.XML)).parameter().id("documentClassName").name(ID.concat(".param.documentClassName.name")).description(ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("addDocumentToProcess").name(ID.concat(".param.addDocumentToProcess.name")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("variableToSaveFileId").name(ID.concat(".param.variableToSaveFileId.name")).description(ID.concat(".param.variableToSaveFileId.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("ksefKey").name(ID.concat(".param.ksefKey.name")).description(ID.concat(".param.ksefKey.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("variable").name(ID.concat(".param.variable.name")).description(ID.concat(".param.variable.desc")).type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("ksefKeyToFunction").name(ID.concat(".param.ksefKeyToFunction.name")).description(ID.concat(".param.ksefKeyToFunction.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("function").name(ID.concat(".param.function.name")).description(ID.concat(".param.function.desc")).type((Type)Types.FUNCTION_ARRAY).create()).parameter().id("newVersion").optional().name(ID.concat(".param.newVersion.name")).description(ID.concat(".param.newVersion.desc")).defaultValue((Object)false).type((Type)Types.BOOLEAN).create()).parameter().id("schematVersion").name(ID.concat(".param.schematVersion.name")).description(ID.concat(".param.schematVersion.desc")).type((Type)Types.STRING).defaultValue((Object)"2").create()).parameter().id("nameOfITSystem").name(ID.concat(".param.nameOfITSystem.name")).description(ID.concat(".param.nameOfITSystem.desc")).type((Type)Types.STRING).defaultValue((Object)"PlusWorkflow").create();
    }

    public void execute(@Param String documentClassName, @Param Boolean addDocumentToProcess, @Param Variable variableToSaveFileId, @Param String[] ksefKey, @Param Variable[] variable, @Param String[] ksefKeyToFunction, @Param FunctionCall[] function, @Param Boolean newVersion, @Param String schematVersion, @Param String nameOfITSystem, WorkflowContext context) throws AcceptanceException {
        try {
            Assert.isTrue((ksefKey.length == variable.length ? 1 : 0) != 0, (String)"The KSeF Keys and Variables arrays are not the same length!");
            Assert.isTrue((newVersion == false || variableToSaveFileId != null ? 1 : 0) != 0, (String)"The fileId must be saved for document versioning!");
            Object fakturaExportSchema = this.createFakturaExportSchema(Short.parseShort(schematVersion), nameOfITSystem);
            this.setInvoiceVariables(fakturaExportSchema, Short.parseShort(schematVersion), ksefKey, variable, ksefKeyToFunction, function);
            byte[] xmlData = this.marshalToXml(fakturaExportSchema, Short.parseShort(schematVersion));
            this.saveDocumentToArchive(documentClassName, addDocumentToProcess, variableToSaveFileId, newVersion, context, xmlData);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private Object createFakturaExportSchema(short schematVersion, String nameOfITSystem) throws AcceptanceException {
        return switch (schematVersion) {
            case 2 -> new FakturaV2ExportSchema(nameOfITSystem);
            case 3 -> new FakturaV3ExportSchema(nameOfITSystem);
            default -> throw new AcceptanceException("Unsupported KSeF schema version: " + schematVersion + ". Supported versions: 2, 3");
        };
    }

    private void setInvoiceVariables(Object fakturaExportSchema, short schematVersion, String[] ksefKey, Variable[] variable, String[] ksefKeyToFunction, FunctionCall[] function) {
        if (schematVersion == 2) {
            FakturaV2 fakturaV2 = (FakturaV2)fakturaExportSchema;
            IntStream.range(0, ksefKey.length).forEach(i -> this.setInvoiceVariableV2(fakturaV2, ksefKey[i], variable[i].getValue(), variable[i].getType()));
            IntStream.range(0, ksefKeyToFunction.length).forEach(i -> this.setInvoiceVariableV2(fakturaV2, ksefKeyToFunction[i], function[i].call(), function[i].getReturnType()));
        } else if (schematVersion == 3) {
            FakturaV3 fakturaV3 = (FakturaV3)fakturaExportSchema;
            IntStream.range(0, ksefKey.length).forEach(i -> this.setInvoiceVariableV3(fakturaV3, ksefKey[i], variable[i].getValue(), variable[i].getType()));
            IntStream.range(0, ksefKeyToFunction.length).forEach(i -> this.setInvoiceVariableV3(fakturaV3, ksefKeyToFunction[i], function[i].call(), function[i].getReturnType()));
        }
    }

    private byte[] marshalToXml(Object fakturaExportSchema, short schematVersion) throws Exception {
        Class jaxbClass = schematVersion == 2 ? FakturaV2.class : FakturaV3.class;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbClass});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            marshaller.marshal(fakturaExportSchema, (OutputStream)byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    private void saveDocumentToArchive(String documentClassName, Boolean addDocumentToProcess, Variable variableToSaveFileId, Boolean newVersion, WorkflowContext context, byte[] xmlData) throws Exception {
        WfFile parentFile = newVersion != false ? this.getParentFile(variableToSaveFileId.getValue()) : null;
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(documentClassName, KSEF_INVOICE_FILENAME, xmlData, null, (boolean)newVersion, (boolean)addDocumentToProcess, context.getActivityId(), context.getProcessId(), parentFile);
        if (variableToSaveFileId != null) {
            variableToSaveFileId.setValue((Object)wfDocument.getFile().getId());
        }
    }

    private WfFile getParentFile(Object fileId) {
        WfFile parentFile = null;
        if (fileId != null && Long.parseLong(fileId.toString()) > 0L) {
            parentFile = this.fileService.getFile(Long.valueOf(Long.parseLong(fileId.toString())), new String[0]);
        }
        return parentFile;
    }

    private void setInvoiceVariableV2(FakturaV2 fakturaV2, String ksefKey, Object value, Type type) {
        if (value != null && !value.equals(type.defaultValue()) && !this.isEmptyArray(value, type)) {
            KsefKeysV2 ksefKeysV2 = Objects.requireNonNull(KsefKeysV2.findByKey(ksefKey), "Incorrect KSeF key: " + ksefKey);
            ksefKeysV2.setValue(fakturaV2, type, value);
        }
    }

    private void setInvoiceVariableV3(FakturaV3 fakturaV3, String ksefKey, Object value, Type type) {
        boolean shouldSetValue;
        KsefKeysV3 ksefKeysV3 = Objects.requireNonNull(KsefKeysV3.findByKey(ksefKey), "Incorrect KSeF key: " + ksefKey);
        if (ksefKeysV3.isRequired()) {
            shouldSetValue = true;
            if (value == null) {
                value = type.defaultValue();
            }
        } else {
            boolean bl = shouldSetValue = value != null && !this.isEmptyArray(value, type) && !value.equals(type.defaultValue());
        }
        if (shouldSetValue) {
            ksefKeysV3.setValue(fakturaV3, type, value);
        }
    }

    private boolean isEmptyArray(Object value, Type type) {
        if (!value.getClass().isArray()) {
            return false;
        }
        int length = Array.getLength(value);
        if (length == 0) {
            return true;
        }
        String defaultValue = Types.isArray((Type)type) ? ((ArrayType)type).getElementType().defaultValue() : "";
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(value, i);
            if (element == null || element.equals(defaultValue)) continue;
            return false;
        }
        return true;
    }
}

