/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.v1.service;

import com.google.common.io.ByteStreams;
import com.google.common.io.Resources;
import com.suncode.plugin.plusksef.api.v1.enums.KsefV1SystemType;
import com.suncode.plugin.plusksef.api.v1.enums.SessionStatus;
import com.suncode.plugin.plusksef.api.v1.model.auth.AuthorisationChallengeRequest;
import com.suncode.plugin.plusksef.api.v1.model.auth.AuthorisationChallengeResponse;
import com.suncode.plugin.plusksef.api.v1.model.auth.ContextIdentifier;
import com.suncode.plugin.plusksef.api.v1.model.auth.InitSignedResponse;
import com.suncode.plugin.plusksef.api.v1.model.auth.ReferenceNumberStatus;
import com.suncode.plugin.plusksef.api.v1.model.invoice.InvoiceStatusResponse;
import com.suncode.plugin.plusksef.api.v1.model.invoice.SendInvoiceRequest;
import com.suncode.plugin.plusksef.api.v1.model.invoice.SendInvoiceResponse;
import com.suncode.plugin.plusksef.api.v1.model.query.InvoiceQueryRequest;
import com.suncode.plugin.plusksef.api.v1.model.query.InvoiceQueryResponse;
import com.suncode.plugin.plusksef.api.v1.model.session.SessionTerminateResponse;
import com.suncode.plugin.plusksef.api.v1.service.ApiException;
import com.suncode.plugin.plusksef.api.v1.service.BaseKsefService;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.crypto.Cipher;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KsEFServiceApiV1Impl
extends BaseKsefService
implements KSeFServiceApiV1 {
    private static final Logger log = LoggerFactory.getLogger(KsEFServiceApiV1Impl.class);
    public static final String RSA_ECB_PKCS_1_PADDING = "RSA/ECB/PKCS1Padding";
    private static final ClassLoader CLASS_LOADER = KsEFServiceApiV1Impl.class.getClassLoader();
    private static final String TOKEN_REQUEST_TEMPLATE_PATH = "xml/InitSessionTokenRequest_template.xml";
    private static final String PUBLIC_KEY_PATH = "publickey/<SYSTEM_TYPE>/publicKey.der";
    private static final MediaType OCTET = MediaType.get((String)"application/octet-stream; charset=utf-8");
    private static final String RSA = "RSA";
    private static final String SHA_256 = "SHA-256";
    private static final String BASE64 = "Base64";
    private static final List<SessionInfo> activeSessions = new LinkedList<SessionInfo>();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    @Override
    public AuthorisationChallengeResponse authorisationChallenge(String ksefApiUrl, String vatNo, AuthorisationChallengeRequest.IdentifierType type) throws IOException, ApiException {
        AuthorisationChallengeRequest authorisationChallengeRequest = this.getAuthorisationChallengeRequest(vatNo, type);
        Request request = new Request.Builder().url(ksefApiUrl + "/online/Session/AuthorisationChallenge").method("POST", this.jsonRequestBody(authorisationChallengeRequest)).build();
        return this.executeRequest(request, AuthorisationChallengeResponse.class);
    }

    @NotNull
    private AuthorisationChallengeRequest getAuthorisationChallengeRequest(String identifier, AuthorisationChallengeRequest.IdentifierType identifierType) {
        return AuthorisationChallengeRequest.builder().contextIdentifier(ContextIdentifier.builder().type(identifierType).identifier(identifier).build()).build();
    }

    @Override
    public InitSignedResponse initToken(String ksefApiUrl, byte[] body) throws IOException, ApiException {
        Request request = new Request.Builder().url(ksefApiUrl + "/online/Session/InitToken").method("POST", this.octetRequestBody(body)).build();
        return this.executeRequest(request, InitSignedResponse.class);
    }

    @Override
    public InvoiceQueryResponse invoiceQuery(String ksefApiUrl, String token, Date dateFrom, Date dateTo, int pageSize, int offset) throws IOException, ApiException {
        InvoiceQueryRequest invoiceQueryRequest = this.getInvoiceQueryRequest("subject2", "incremental", dateFrom, dateTo);
        String endpoint = String.format("/online/Query/Invoice/Sync?PageSize=%d&PageOffset=%d", pageSize, offset);
        log.debug(this.jsonRequestBody(invoiceQueryRequest).toString());
        Request request = new Request.Builder().url(ksefApiUrl + endpoint).method("POST", this.jsonRequestBody(invoiceQueryRequest)).addHeader("SessionToken", token).build();
        return this.executeRequest(request, InvoiceQueryResponse.class);
    }

    @NotNull
    private InvoiceQueryRequest getInvoiceQueryRequest(String subjectType, String type, Date dateFrom, Date dateTo) {
        return InvoiceQueryRequest.builder().queryCriteria(InvoiceQueryRequest.QueryCriteria.builder().subjectType(subjectType).type(type).acquisitionTimestampThresholdFrom(this.dateFormat.format(dateFrom)).acquisitionTimestampThresholdTo(this.dateFormat.format(dateTo)).build()).build();
    }

    @Override
    @NotNull
    public byte[] getInvoice(String ksefApiUrl, String referenceNumber, String token) throws ApiException {
        String endpoint = String.format("/online/Invoice/Get/%s", referenceNumber);
        Request request = new Request.Builder().url(ksefApiUrl + endpoint).addHeader("SessionToken", token).build();
        return this.getDocumentByteArray(request);
    }

    @Override
    public SessionInfo getSession(KsefImportConfig config) throws Exception {
        Optional<SessionInfo> sessionInfo = activeSessions.stream().filter(callInfo -> callInfo.getNip().equals(config.getNip()) && callInfo.getKsefSystemType().equals(config.getKsefSystemType())).findFirst();
        if (sessionInfo.isPresent()) {
            if (this.isSessionActive(config.getKsefUrl(), sessionInfo.get().getReferenceNumber())) {
                return sessionInfo.get();
            }
            activeSessions.remove(sessionInfo.get());
        }
        SessionInfo newSessionInfo = this.createNewSession(config);
        activeSessions.add(newSessionInfo);
        this.waitingForSessionActivation(config.getKsefUrl(), newSessionInfo.getReferenceNumber(), 180);
        return newSessionInfo;
    }

    private SessionInfo createNewSession(KsefImportConfig config) throws Exception {
        log.info("Generate new SessionToken");
        AuthorisationChallengeResponse authorisationChallengeResponse = this.authorisationChallenge(config.getKsefUrl(), config.getNip(), AuthorisationChallengeRequest.IdentifierType.onip);
        String tokenRequestMessage = this.getTokenRequestMessage(authorisationChallengeResponse.getChallenge(), authorisationChallengeResponse.getTimestamp(), config.getNip(), config.getTokenAuth(), KsefV1SystemType.valueOf(config.getKsefSystemType()));
        InitSignedResponse initSignedResponse = this.initToken(config.getKsefUrl(), tokenRequestMessage.getBytes());
        return SessionInfo.builder().nip(config.getNip()).sessionToken(initSignedResponse.getSessionToken().getToken()).referenceNumber(initSignedResponse.getReferenceNumber()).ksefSystemType(config.getKsefSystemType()).build();
    }

    @Override
    public SessionTerminateResponse terminateSession(String ksefApiUrl, String token) throws IOException, ApiException {
        Request request = new Request.Builder().url(ksefApiUrl + "/online/Session/Terminate").addHeader("SessionToken", token).build();
        return this.executeRequest(request, SessionTerminateResponse.class);
    }

    @Override
    public void waitingForUPOGenerated(String ksefUrl, String referenceNumber, int maxSeconds) throws IOException, ApiException, InterruptedException {
        int singleWaitingTime = 5;
        for (int totalWaitTimeInSec = 0; totalWaitTimeInSec < maxSeconds; totalWaitTimeInSec += singleWaitingTime) {
            Thread.sleep((long)singleWaitingTime * 1000L);
            if (this.getReferenceNumberStatus(ksefUrl, referenceNumber).getProcessingCode() != SessionStatus.GENERATE_UPO.getSuccessStatus()) continue;
            return;
        }
        throw new ApiException("Session activation timed out");
    }

    @Override
    public Optional<byte[]> getUPO(String ksefApiUrl, String referenceNumber) throws IOException, ApiException {
        ReferenceNumberStatus referenceNumberStatus = this.getReferenceNumberStatus(ksefApiUrl, referenceNumber);
        if (referenceNumberStatus != null && !StringUtils.isBlank((CharSequence)referenceNumberStatus.getUpo())) {
            return Optional.of(Base64.getDecoder().decode(referenceNumberStatus.getUpo()));
        }
        return Optional.empty();
    }

    private String getTokenRequestMessage(String challenge, String timestamp, String nip, String authToken, KsefV1SystemType systemType) throws Exception {
        URL tokenRequestXmlUrl = CLASS_LOADER.getResource(TOKEN_REQUEST_TEMPLATE_PATH);
        return Resources.toString((URL)tokenRequestXmlUrl, (Charset)StandardCharsets.UTF_8).replace("timestamp_to_replace", timestamp).replace("challenge_to_replace", challenge).replace("identifier_to_replace", nip).replace("token_to_replace", this.encryptAuthorizationToken(timestamp, authToken, this.getPublicKey(systemType)));
    }

    private boolean isSessionActive(String ksefUrl, String referenceNumber) throws IOException, ApiException {
        int processingCode = this.getReferenceNumberStatus(ksefUrl, referenceNumber).getProcessingCode();
        return processingCode == SessionStatus.AUTHORISE.getSuccessStatus() || processingCode == SessionStatus.SECURITY.getSuccessStatus();
    }

    private void waitingForSessionActivation(String ksefUrl, String referenceNumber, int maxSeconds) throws InterruptedException, IOException, ApiException {
        int singleWaitingTime = 10;
        for (int totalWaitingTimeInSec = 0; totalWaitingTimeInSec < maxSeconds; totalWaitingTimeInSec += singleWaitingTime) {
            Thread.sleep((long)singleWaitingTime * 1000L);
            if (!this.isSessionActive(ksefUrl, referenceNumber)) continue;
            return;
        }
        throw new ApiException("Session activation timed out");
    }

    private PublicKey getPublicKey(KsefV1SystemType systemType) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        URL url = CLASS_LOADER.getResource(PUBLIC_KEY_PATH.replace("<SYSTEM_TYPE>", systemType.toString()));
        byte[] keyBytes = Resources.toByteArray((URL)url);
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    private ReferenceNumberStatus getReferenceNumberStatus(String ksefApiUrl, String referenceNumber) throws IOException, ApiException {
        String endpoint = String.format("/common/Status/%s", referenceNumber);
        Request request = new Request.Builder().url(ksefApiUrl + endpoint).build();
        return this.executeRequest(request, ReferenceNumberStatus.class);
    }

    @NotNull
    private RequestBody octetRequestBody(byte[] body) {
        return RequestBody.create((byte[])body, (MediaType)OCTET);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] getDocumentByteArray(Request request) throws ApiException {
        block15: {
            try (Response response = client.newCall(request).execute();){
                byte[] byArray;
                block16: {
                    if (!response.isSuccessful()) {
                        throw new ApiException("Unsuccessful response from KSeF", response.code(), response.message());
                    }
                    if (response.body() == null) break block15;
                    InputStream is = response.body().byteStream();
                    try {
                        byArray = ByteStreams.toByteArray((InputStream)is);
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return byArray;
            }
            catch (IOException ex) {
                throw new ApiException(ex);
            }
        }
        return new byte[0];
    }

    @Override
    public String encryptAuthorizationToken(String challengeTime, String tokenAuth, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(RSA_ECB_PKCS_1_PADDING);
        cipher.init(1, publicKey);
        Date challengeTimeStamp = this.dateFormat.parse(challengeTime);
        byte[] message = (tokenAuth + "|" + challengeTimeStamp.getTime()).getBytes(StandardCharsets.UTF_8);
        byte[] messageEncrypted = cipher.doFinal(message);
        return Base64.getEncoder().encodeToString(messageEncrypted);
    }

    @Override
    public SendInvoiceResponse sendInvoice(String ksefApiUrl, String token, byte[] invoiceBytes) throws IOException, ApiException {
        SendInvoiceRequest invoiceRequest = this.prepareSendInvoiceRequest(invoiceBytes);
        Request request = new Request.Builder().url(ksefApiUrl + "/online/Invoice/Send").method("PUT", this.jsonRequestBody(invoiceRequest)).addHeader("SessionToken", token).build();
        return this.executeRequest(request, SendInvoiceResponse.class);
    }

    @Override
    public InvoiceStatusResponse loadInvoiceStatus(String ksefApiUrl, String token, String invoiceElementReferenceNumber) throws IOException, ApiException {
        String endpoint = String.format("/online/Invoice/Status/%s", invoiceElementReferenceNumber);
        Request request = new Request.Builder().url(ksefApiUrl + endpoint).addHeader("SessionToken", token).addHeader("accept", "application/json").build();
        return this.executeRequest(request, InvoiceStatusResponse.class);
    }

    private SendInvoiceRequest prepareSendInvoiceRequest(byte[] invoiceBytes) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(SHA_256);
            byte[] digest = messageDigest.digest(invoiceBytes);
            String digestBase64 = Base64.getEncoder().encodeToString(digest);
            String contentBase64 = Base64.getEncoder().encodeToString(invoiceBytes);
            return SendInvoiceRequest.builder().invoiceHash(SendInvoiceRequest.InvoiceHash.builder().fileSize(invoiceBytes.length).hashSHA(SendInvoiceRequest.InvoiceHash.HashSHA.builder().algorithm(SHA_256).encoding(BASE64).value(digestBase64).build()).build()).invoicePayload(SendInvoiceRequest.InvoicePayload.builder().type("plain").invoiceBody(contentBase64).build()).build();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No SHA-256 checksum calculation algorithm ", e);
        }
    }
}

