/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.model.query.InvoiceQueryResponse;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.enums.MappingsForIndexesApiV1Enum;
import com.suncode.plugin.plusksef.configuration.enums.MappingsForIndexesApiV2Enum;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.service.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.db.service.LastInvoiceQueryTimeService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.scheduledtask.ImportDocumentsFromKSeFSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceMetadata;
import pl.akmf.ksef.sdk.client.model.invoice.QueryInvoiceMetadataResponse;

@ScheduledTask
public class ImportDocumentsFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ImportDocumentsFromKSeF.class);
    private static final int QUERY_INVOICE_PAGE_SIZE = 50;
    private static final String LAST_CALL_DATE = "LAST_CALL_DATE";
    private static final String ID = "plusksef.scheduledTask.ImportDocumentsFromKSeF";
    private static final String XML_EXTENSION = ".xml";
    private final SimpleDateFormat dateFormatDDMMYYYY = new SimpleDateFormat("dd-MM-yyyy");
    private final SimpleDateFormat dateFormatYYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private ImportedDocumentTableService importedDocumentTableService;
    @Autowired
    private LastInvoiceQueryTimeService lastInvoiceQueryTimeService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    public ImportDocumentsFromKSeF() {
        this.dateFormatDDMMYYYY.setLenient(false);
        this.dateFormatYYYYMMDD.setLenient(false);
    }

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).parameter().id("configIds").name(ID.concat(".param.configIds.name")).description(ID.concat(".param.configIds.desc")).type((Type)Types.STRING).create()).parameter().id("readFromDate").name(ID.concat(".param.readFromDate.name")).description(ID.concat(".param.readFromDate.desc")).type((Type)Types.STRING).create();
    }

    public String execute(@Param String configIds, @Param String readFromDate) {
        ImportDocumentsFromKSeFSummary importDocumentsFromKSeFSummaryInfo = new ImportDocumentsFromKSeFSummary();
        Arrays.stream(configIds.split(",")).filter(config -> !config.isEmpty()).distinct().forEach(configId -> this.processTask((String)configId, readFromDate, importDocumentsFromKSeFSummaryInfo));
        return importDocumentsFromKSeFSummaryInfo.buildSummary();
    }

    public void processTask(String configId, String readInvoiceFromStringParam, ImportDocumentsFromKSeFSummary summary) {
        taskLog.debug((Object)("Processing config: " + configId));
        KsefImportConfig config = this.configService.readConfigurationFromPCM(configId);
        Date readInvoiceFrom = this.getReadingDateFrom(readInvoiceFromStringParam, config);
        Date readInvoiceTo = this.getReadingDateTo();
        taskLog.debug((Object)String.format("Read invoice from %s to %s", this.dateFormatYYYYMMDD.format(readInvoiceFrom), this.dateFormatYYYYMMDD.format(readInvoiceTo)));
        Assert.isTrue((!readInvoiceFrom.after(readInvoiceTo) ? 1 : 0) != 0, (String)"Incorrect date. Date from occurs after Date to");
        if (config.getApiVersion() == KsefApiVersion.V2) {
            this.executeKSeFv2(config, readInvoiceFrom, readInvoiceTo, summary);
        } else {
            this.executeKSeFv1(config, readInvoiceFrom, readInvoiceTo, summary);
        }
    }

    private Date getReadingDateFrom(String readInvoiceFromStringParam, KsefImportConfig config) throws ParseException {
        Date readInvoiceFrom;
        Date date = readInvoiceFrom = readInvoiceFromStringParam.equals(LAST_CALL_DATE) ? this.lastInvoiceQueryTimeService.getTimeOfLastCall(config.getNip(), config.getKsefSystemType()) : this.parseDate(readInvoiceFromStringParam);
        if (readInvoiceFrom == null) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, -1);
            readInvoiceFrom = cal.getTime();
        }
        return readInvoiceFrom;
    }

    private Date parseDate(String dateString) throws ParseException {
        try {
            return this.dateFormatDDMMYYYY.parse(dateString);
        }
        catch (ParseException e) {
            return this.dateFormatYYYYMMDD.parse(dateString);
        }
    }

    private Date getReadingDateTo() {
        return this.addHoursToDate(new Date(), 1);
    }

    private Date addHoursToDate(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    private void executeKSeFv1(KsefImportConfig config, Date readInvoiceFrom, Date readInvoiceTo, ImportDocumentsFromKSeFSummary summary) {
        Timestamp invoiceQueryTime;
        InvoiceQueryResponse invoiceQueryResponse;
        SessionInfo sessionInfo = this.kSeFServiceApiV1.getSession(config);
        int offset = 0;
        do {
            invoiceQueryTime = Timestamp.from(Instant.now());
            invoiceQueryResponse = this.kSeFServiceApiV1.invoiceQuery(config.getKsefUrl(), sessionInfo.getSessionToken(), readInvoiceFrom, readInvoiceTo, 50, offset);
            taskLog.debug((Object)("Found " + invoiceQueryResponse.getInvoiceHeaderList().size() + " documents"));
            summary.increaseProcessedDocuments(invoiceQueryResponse.getInvoiceHeaderList().size());
            for (InvoiceQueryResponse.InvoiceHeader invoiceHeader : invoiceQueryResponse.getInvoiceHeaderList()) {
                this.loadDocumentV1(invoiceHeader, sessionInfo.getSessionToken(), config, summary);
            }
            offset += 50;
        } while (invoiceQueryResponse.getInvoiceHeaderList().size() >= 50);
        this.lastInvoiceQueryTimeService.addInfo(config.getNip(), config.getKsefSystemType(), invoiceQueryTime);
    }

    private void executeKSeFv2(KsefImportConfig config, Date readInvoiceFrom, Date readInvoiceTo, ImportDocumentsFromKSeFSummary summary) {
        Timestamp invoiceQueryTime;
        QueryInvoiceMetadataResponse invoiceMetadata;
        DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(config.getKsefUrl(), config.getKsefSuffixUri(), config.getKsefQrUri());
        String accessToken = this.kSeFServiceApiV2.getAuthTokens((KSeFClient)ksefClient, config).accessToken();
        int pageOffset = 0;
        do {
            invoiceQueryTime = Timestamp.from(Instant.now());
            invoiceMetadata = this.kSeFServiceApiV2.getInvoiceMetadata((KSeFClient)ksefClient, accessToken, readInvoiceFrom, readInvoiceTo, 50, pageOffset);
            taskLog.debug((Object)("Found " + invoiceMetadata.getInvoices().size() + " documents"));
            summary.increaseProcessedDocuments(invoiceMetadata.getInvoices().size());
            for (InvoiceMetadata invoiceData : invoiceMetadata.getInvoices()) {
                this.loadDocumentV2((KSeFClient)ksefClient, invoiceData, accessToken, config, summary);
            }
            ++pageOffset;
        } while (invoiceMetadata.getHasMore().booleanValue());
        this.lastInvoiceQueryTimeService.addInfo(config.getNip(), config.getKsefSystemType(), invoiceQueryTime);
    }

    private void loadDocumentV1(InvoiceQueryResponse.InvoiceHeader invoiceHeader, String sessionToken, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary) {
        if (this.importedDocumentTableService.isDocumentImportedByConfig(invoiceHeader.getKsefReferenceNumber(), config.getConfigId())) {
            taskLog.debug((Object)String.format("SKIP document: %s (already imported by config: %s)", invoiceHeader.getKsefReferenceNumber(), config.getConfigId()));
            summary.increaseSkippedDocuments();
            return;
        }
        byte[] invoice = this.kSeFServiceApiV1.getInvoice(config.getKsefUrl(), invoiceHeader.getKsefReferenceNumber(), sessionToken);
        taskLog.debug((Object)("Load document: " + invoiceHeader.getKsefReferenceNumber()));
        Map<Long, Object> indexes = this.createIndexesMapV1(invoiceHeader, config);
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(config.getDocumentClassId(), invoiceHeader.getKsefReferenceNumber() + XML_EXTENSION, invoice, indexes, true);
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        this.importedDocumentTableService.addInfo(config.getNip(), config.getConfigId(), config.getKsefSystemType(), invoiceHeader.getKsefReferenceNumber(), wfDocument.getFile().getId());
        summary.increaseLoadDocuments();
    }

    private void loadDocumentV2(KSeFClient ksefClient, InvoiceMetadata invoiceData, String accessToken, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary) {
        if (this.importedDocumentTableService.isDocumentImportedByConfig(invoiceData.getKsefNumber(), config.getConfigId())) {
            taskLog.debug((Object)String.format("SKIP document: %s (already imported by config: %s)", invoiceData.getKsefNumber(), config.getConfigId()));
            summary.increaseSkippedDocuments();
            return;
        }
        byte[] invoice = this.kSeFServiceApiV2.getInvoice(ksefClient, invoiceData.getKsefNumber(), accessToken);
        taskLog.debug((Object)("Load document: " + invoiceData.getKsefNumber()));
        Map<Long, Object> indexes = this.createIndexesMapV2(invoiceData, config);
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(config.getDocumentClassId(), invoiceData.getKsefNumber() + XML_EXTENSION, invoice, indexes, true);
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        Timestamp invoicingDate = invoiceData.getInvoicingDate() != null ? Timestamp.from(invoiceData.getInvoicingDate().toInstant()) : null;
        this.importedDocumentTableService.addInfo(invoiceData.getSeller().getNip(), config.getConfigId(), config.getKsefSystemType(), invoiceData.getKsefNumber(), wfDocument.getFile().getId(), invoiceData.getInvoiceHash(), invoicingDate, invoiceData.getInvoicingMode().name());
        summary.increaseLoadDocuments();
    }

    private Map<Long, Object> createIndexesMapV1(InvoiceQueryResponse.InvoiceHeader invoiceHeader, KsefImportConfig config) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        config.getMappings().forEach(mapping -> indexes.put(mapping.getDocClassIndex(), this.getIndexValueV1(mapping.getKsefParam(), invoiceHeader, config)));
        indexes.values().removeIf(Objects::isNull);
        return indexes;
    }

    private Map<Long, Object> createIndexesMapV2(InvoiceMetadata invoiceHeader, KsefImportConfig config) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        config.getMappings().forEach(mapping -> indexes.put(mapping.getDocClassIndex(), this.getIndexValueV2(mapping.getKsefParam(), invoiceHeader, config)));
        indexes.values().removeIf(Objects::isNull);
        return indexes;
    }

    private Object getIndexValueV2(String key, InvoiceMetadata invoiceHeader, KsefImportConfig config) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return switch (MappingsForIndexesApiV2Enum.enumByKey(key)) {
            default -> throw new IncompatibleClassChangeError();
            case MappingsForIndexesApiV2Enum.INVOICE_REFERENCE_NUMBER -> invoiceHeader.getInvoiceNumber();
            case MappingsForIndexesApiV2Enum.KSEF_REFERENCE_NUMBER -> invoiceHeader.getKsefNumber();
            case MappingsForIndexesApiV2Enum.INVOICING_DATE -> invoiceHeader.getInvoicingDate().format(formatter);
            case MappingsForIndexesApiV2Enum.ACQUISITION_TIMESTAMP -> invoiceHeader.getAcquisitionDate().format(formatter);
            case MappingsForIndexesApiV2Enum.SUBJECT_BY_NAME -> {
                if (invoiceHeader.getSeller() != null) {
                    yield invoiceHeader.getSeller().getName();
                }
                yield null;
            }
            case MappingsForIndexesApiV2Enum.SUBJECT_BY_NIP -> {
                if (invoiceHeader.getSeller() != null) {
                    yield invoiceHeader.getSeller().getNip();
                }
                yield null;
            }
            case MappingsForIndexesApiV2Enum.SUBJECT_TO_NAME -> {
                if (invoiceHeader.getBuyer() != null) {
                    yield invoiceHeader.getBuyer().getName();
                }
                yield null;
            }
            case MappingsForIndexesApiV2Enum.SUBJECT_TO_NIP -> {
                if (invoiceHeader.getBuyer() != null) {
                    yield invoiceHeader.getBuyer().getIdentifier().getValue();
                }
                yield null;
            }
            case MappingsForIndexesApiV2Enum.NET -> invoiceHeader.getNetAmount();
            case MappingsForIndexesApiV2Enum.VAT -> invoiceHeader.getVatAmount();
            case MappingsForIndexesApiV2Enum.GROSS -> invoiceHeader.getGrossAmount();
            case MappingsForIndexesApiV2Enum.CONFIG_ID -> config.getConfigId();
            case MappingsForIndexesApiV2Enum.CONFIG_NIP -> config.getNip();
            case MappingsForIndexesApiV2Enum.CONFIG_SYSTEM_TYPE -> config.getKsefSystemType();
            case MappingsForIndexesApiV2Enum.INVOICING_MODE -> invoiceHeader.getInvoicingMode().getValue();
            case MappingsForIndexesApiV2Enum.CURRENCY -> invoiceHeader.getCurrency();
            case MappingsForIndexesApiV2Enum.HAS_ATTACHMENT -> invoiceHeader.getHasAttachment();
            case MappingsForIndexesApiV2Enum.INVOICE_TYPE -> invoiceHeader.getInvoiceType().getValue();
        };
    }

    private Object getIndexValueV1(String key, InvoiceQueryResponse.InvoiceHeader invoiceHeader, KsefImportConfig config) {
        return switch (MappingsForIndexesApiV1Enum.enumByKey(key)) {
            case MappingsForIndexesApiV1Enum.SUBJECT_BY_NAME -> {
                if (invoiceHeader.getSubjectBy().getIssuedByName() != null) {
                    yield invoiceHeader.getSubjectBy().getIssuedByName().getFullName();
                }
                yield null;
            }
            case MappingsForIndexesApiV1Enum.SUBJECT_BY_NIP -> {
                if (invoiceHeader.getSubjectBy().getIssuedByIdentifier() != null) {
                    yield invoiceHeader.getSubjectBy().getIssuedByIdentifier().getIdentifier();
                }
                yield null;
            }
            case MappingsForIndexesApiV1Enum.SUBJECT_TO_NAME -> {
                if (invoiceHeader.getSubjectTo().getIssuedToName() != null) {
                    yield invoiceHeader.getSubjectTo().getIssuedToName().getFullName();
                }
                yield null;
            }
            case MappingsForIndexesApiV1Enum.SUBJECT_TO_NIP -> {
                if (invoiceHeader.getSubjectTo().getIssuedToIdentifier() != null) {
                    yield invoiceHeader.getSubjectTo().getIssuedToIdentifier().getIdentifier();
                }
                yield null;
            }
            case MappingsForIndexesApiV1Enum.CONFIG_ID -> config.getConfigId();
            case MappingsForIndexesApiV1Enum.CONFIG_NIP -> config.getNip();
            case MappingsForIndexesApiV1Enum.CONFIG_SYSTEM_TYPE -> config.getKsefSystemType();
            default -> ((Map)new ObjectMapper().convertValue((Object)invoiceHeader, Map.class)).get(key);
        };
    }
}

