/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.upgrader;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;

public class AddDocumentSchemaToTempDirectory {
    private String schemaName = "v1";
    private static final String PLUSWORKFLOW_HOME = "plusworkflow.home";
    private static final String KSEF_INVOICE_SCHEMA_DIR = "files/ksef/";

    void copyFile(String fileToCopy) {
        this.copyFile(fileToCopy, Paths.get(KSEF_INVOICE_SCHEMA_DIR, this.schemaName, FilenameUtils.getName((String)fileToCopy)).toString());
    }

    void copyFile(String fileToCopy, String homeDestinationDir) {
        Path destinationPath = Paths.get(System.getProperty(PLUSWORKFLOW_HOME), homeDestinationDir);
        try (InputStream fileInputStream = this.getClass().getClassLoader().getResource(fileToCopy).openStream();){
            Path parentDirectory = destinationPath.getParent();
            if (parentDirectory != null && !Files.exists(parentDirectory, new LinkOption[0])) {
                Files.createDirectories(parentDirectory, new FileAttribute[0]);
            }
            Files.copy(fileInputStream, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

