/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.service;

import com.suncode.plugin.plusksef.api.v2.enums.KsefV2SystemType;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.entity.ImportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.db.servicie.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.document.dto.KSeFQrInformation;
import com.suncode.plugin.plusksef.document.service.KSeFQrURLGenerator;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV3;
import com.suncode.plugin.plusksef.invoice.service.InvoiceDataService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.api.services.DefaultCryptographyService;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.qrcode.ContextIdentifierType;
import pl.akmf.ksef.sdk.system.SystemKSeFSDKException;

@Service
public class KSeFQrURLGeneratorImp
implements KSeFQrURLGenerator {
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ImportedDocumentTableService importedDocumentTableService;
    @Autowired
    private InvoiceDataService invoiceService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;
    @Autowired
    private FileService fileService;
    private static final String RSASSA_PSS = "RSASSA-PSS";
    private static final String SHA_256_WITH_ECDS_FORMAT = "SHA256withECDSA";
    private static final String MGF_1 = "MGF1";
    private static final Pattern KSEF_FILE_NAME_PATTERN = Pattern.compile("^\\d{10}-\\d{8}-[0-9A-F]{12}-[0-9A-F]{2}$");
    private static final String SHA_256 = "SHA-256";

    @Override
    public KSeFQrInformation buildInvoiceVerificationUrl(long fileId) throws Exception {
        WfFile wfFile = this.fileService.getFile(Long.valueOf(fileId), new String[0]);
        byte[] xmlDocumentBytes = Files.readAllBytes(Paths.get(wfFile.getFullPath(), new String[0]));
        return this.buildInvoiceVerificationUrl(wfFile, xmlDocumentBytes);
    }

    @Override
    public KSeFQrInformation buildInvoiceVerificationUrl(WfFile wfFile, byte[] xmlDocumentBytes) throws Exception {
        KSeFQrInformation kSeFQrInformation = this.getKSeFQrInformation(wfFile, xmlDocumentBytes);
        if (kSeFQrInformation.getKsefV2SystemType() == KsefV2SystemType.PROD && LocalDate.now().isBefore((ReadablePartial)LocalDate.parse((String)"2026-01-31"))) {
            String url = this.buildInvoiceVerificationUrlApiV1(kSeFQrInformation.getKsefBaseURL(), kSeFQrInformation.getInvoiceHash(), kSeFQrInformation.getKsefNumber());
            kSeFQrInformation.setUrl(url);
        } else {
            String url = this.buildInvoiceVerificationUrlApiV2(kSeFQrInformation.getKsefBaseURL(), kSeFQrInformation.getNip(), kSeFQrInformation.getInvoicingDate(), kSeFQrInformation.getInvoiceHash());
            kSeFQrInformation.setUrl(url);
        }
        return kSeFQrInformation;
    }

    @Override
    public KSeFQrInformation buildCertificateVerificationUrl(WfFile wfFile, byte[] xmlDocumentBytes, String pcmConfigurationId) throws Exception {
        KSeFQrInformation kSeFQrInformation = this.getKSeFQrInformation(wfFile, xmlDocumentBytes);
        String url = this.buildCertificateVerificationUrlApiV2(kSeFQrInformation.getKsefBaseURL(), pcmConfigurationId, kSeFQrInformation.getNip(), kSeFQrInformation.getInvoiceHash());
        kSeFQrInformation.setUrl(url);
        return kSeFQrInformation;
    }

    @NonNull
    private String buildInvoiceVerificationUrlApiV1(String ksefBaseURL, String hash, String ksefNumber) {
        Assert.hasText((String)ksefNumber, (String)"KSeF number is null or empty");
        Assert.hasText((String)hash, (String)"QR code hash is null or empty");
        return ksefBaseURL.replace("/api", "/web/verify/") + ksefNumber + "/" + hash;
    }

    private String buildInvoiceVerificationUrlApiV2(String ksefBaseURL, String nip, LocalDate invoicingDate, String invoiceHash) {
        Assert.hasText((String)nip, (String)"NIP is null or empty");
        Assert.hasText((String)invoiceHash, (String)"QR code hash is null or empty");
        String date = invoicingDate.toString(DateTimeFormat.forPattern((String)"dd-MM-yyyy"));
        byte[] invoiceHashBytes = Base64.getDecoder().decode(invoiceHash);
        String invoiceHashUrlEncoded = Base64.getUrlEncoder().withoutPadding().encodeToString(invoiceHashBytes);
        return String.format("%s/client-app/invoice/%s/%s/%s", ksefBaseURL, nip, date, invoiceHashUrlEncoded);
    }

    private String buildCertificateVerificationUrlApiV2(String ksefBaseURL, String pcmConfigurationId, String nip, String invoiceHash) throws IOException {
        DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(ksefBaseURL);
        DefaultCryptographyService cryptographyService = new DefaultCryptographyService((KSeFClient)ksefClient);
        KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(pcmConfigurationId);
        String certSerialNumber = ksefImportConfig.getApiV2OfflineCertificateSerialNumber();
        String privateKeyString = ksefImportConfig.getApiV2OfflinePrivateKeyPEM();
        privateKeyString = privateKeyString.replace("-----BEGIN PRIVATE KEY-----", "");
        privateKeyString = privateKeyString.replace("-----END PRIVATE KEY-----", "");
        privateKeyString = privateKeyString.replaceAll("\\s+", "");
        byte[] privateKeyBytes = Base64.getDecoder().decode(privateKeyString);
        PrivateKey privateKey = cryptographyService.parseEcdsaPrivateKeyFromPem(privateKeyBytes);
        return this.buildCertificateVerificationUrl(ksefBaseURL, nip, certSerialNumber, invoiceHash, privateKey);
    }

    private String buildCertificateVerificationUrl(String ksefBaseURL, String sellerNip, String certificateSerial, String invoiceHash, PrivateKey privateKey) {
        byte[] invoiceHashBytes = Base64.getDecoder().decode(invoiceHash);
        String invoiceHashUrlEncoded = Base64.getUrlEncoder().withoutPadding().encodeToString(invoiceHashBytes);
        String apiPath = ksefBaseURL + "/client-app";
        String pathToSign = String.format("%s/certificate/%s/%s/%s/%s/%s", apiPath, ContextIdentifierType.NIP, sellerNip, sellerNip, certificateSerial, invoiceHashUrlEncoded).replace("https://", "");
        String signedHash = this.computeUrlEncodedSignedHash(pathToSign, privateKey);
        return String.format("%s/certificate/%s/%s/%s/%s/%s/%s", apiPath, ContextIdentifierType.NIP, sellerNip, sellerNip, certificateSerial, invoiceHashUrlEncoded, signedHash);
    }

    private String computeUrlEncodedSignedHash(String pathToSign, PrivateKey privateKey) {
        try {
            Signature signature;
            if (privateKey instanceof RSAPrivateKey) {
                signature = Signature.getInstance(RSASSA_PSS);
                PSSParameterSpec pssSpec = new PSSParameterSpec(SHA_256, MGF_1, new MGF1ParameterSpec(SHA_256), 32, 1);
                signature.setParameter(pssSpec);
            } else if (privateKey instanceof ECPrivateKey) {
                signature = Signature.getInstance(SHA_256_WITH_ECDS_FORMAT);
            } else {
                throw new SystemKSeFSDKException("Certificate not support RSA or ECDsa.", null);
            }
            signature.initSign(privateKey);
            signature.update(pathToSign.getBytes(StandardCharsets.UTF_8));
            byte[] signedBytes = signature.sign();
            return Base64.getUrlEncoder().withoutPadding().encodeToString(signedBytes);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SystemKSeFSDKException("Cannot compute signature", (Throwable)e);
        }
    }

    private KSeFQrInformation getKSeFQrInformation(WfFile wfFile, byte[] xmlDocumentBytes) throws Exception {
        LocalDate invoicingDate;
        Optional<ExportedDocumentTableEntity> exportedDocumentInfo;
        String systemType = null;
        String nip = null;
        String invoicingHash = null;
        String ksefNumber = null;
        Timestamp invoicingTimestamp = null;
        Optional<ImportedDocumentTableEntity> importedDocumentInfo = this.importedDocumentTableService.getEntity(wfFile.getId());
        if (importedDocumentInfo.isPresent()) {
            ImportedDocumentTableEntity importedDocumentTableEntity = importedDocumentInfo.get();
            systemType = importedDocumentTableEntity.getSystemType();
            nip = importedDocumentTableEntity.getNip();
            invoicingTimestamp = importedDocumentTableEntity.getInvoicingDate();
            invoicingHash = importedDocumentTableEntity.getInvoicingHash();
            ksefNumber = importedDocumentTableEntity.getKsefReferenceNumber();
        }
        if ((exportedDocumentInfo = this.exportedDocumentTableService.getEntity(wfFile.getId())).isPresent()) {
            ExportedDocumentTableEntity exportedDocumentTableEntity = exportedDocumentInfo.get();
            systemType = exportedDocumentTableEntity.getSystemType();
            nip = exportedDocumentTableEntity.getNip();
            invoicingTimestamp = exportedDocumentTableEntity.getInvoicingDate();
            invoicingHash = exportedDocumentTableEntity.getInvoicingHash();
            ksefNumber = exportedDocumentTableEntity.getKsefReferenceNumber();
        }
        systemType = StringUtils.isBlank((CharSequence)systemType) ? this.configService.readFirstConfigurationFromPCM().getKsefSystemType() : systemType;
        KsefV2SystemType ksefV2SystemType = KsefV2SystemType.valueOf(systemType);
        String ksefBaseUrl = ksefV2SystemType.getUrl();
        invoicingHash = StringUtils.isBlank((CharSequence)invoicingHash) ? this.getBase64Hash(xmlDocumentBytes) : invoicingHash;
        LocalDate localDate = invoicingDate = invoicingTimestamp != null ? new LocalDate(invoicingTimestamp.getTime()) : null;
        if (StringUtils.isBlank((CharSequence)nip) || invoicingDate == null) {
            Map<String, Object> invoiceData = this.invoiceService.getInvoiceData(xmlDocumentBytes);
            nip = (String)invoiceData.get(KsefKeysV3.PODMIOT1_DANEIDENTYFIKACYJNE_NIP.getKey());
            invoicingDate = (LocalDate)invoiceData.get(KsefKeysV3.FA_P_1.getKey());
        }
        ksefNumber = StringUtils.isBlank((CharSequence)ksefNumber) ? this.getKSeFNumberFromFileName(wfFile.getFileName(), nip) : ksefNumber;
        return new KSeFQrInformation(ksefBaseUrl, ksefV2SystemType, nip, invoicingDate, invoicingHash, ksefNumber, "");
    }

    private String getBase64Hash(byte[] xmlDocumentBytes) throws NoSuchAlgorithmException {
        MessageDigest sha256 = MessageDigest.getInstance(SHA_256);
        byte[] hash = sha256.digest(xmlDocumentBytes);
        return Base64.getEncoder().encodeToString(hash);
    }

    private String getKSeFNumberFromFileName(String fileName, String nip) {
        String normalizedNip;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{fileName, nip})) {
            return "";
        }
        String baseName = FilenameUtils.getBaseName((String)fileName);
        String normalizedBaseName = baseName.toUpperCase(Locale.ROOT);
        if (!normalizedBaseName.startsWith((normalizedNip = nip.trim()) + "-")) {
            return "";
        }
        return KSEF_FILE_NAME_PATTERN.matcher(normalizedBaseName).matches() ? normalizedBaseName : "";
    }
}

