/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.db.servicie;

import com.suncode.plugin.plusksef.db.dao.ImportedDocumentTableDao;
import com.suncode.plugin.plusksef.db.entity.ImportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ImportedDocumentTableService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ImportedDocumentTableServiceImpl
extends EditableServiceImpl<ImportedDocumentTableEntity, Long, ImportedDocumentTableDao>
implements ImportedDocumentTableService {
    private static final Logger log = LoggerFactory.getLogger(ImportedDocumentTableServiceImpl.class);

    @Autowired
    public void setDao(ImportedDocumentTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void addInfo(String nip, String configId, String ksefSystemType, String ksefReferenceNumber, Long fileId) {
        ((ImportedDocumentTableDao)this.dao).save(this.createEntity(nip, configId, ksefSystemType, ksefReferenceNumber, fileId, null, null, null));
    }

    @Override
    public void addInfo(String nip, String configId, String ksefSystemType, String ksefReferenceNumber, Long fileId, String invoicingHash, Timestamp invoicingDate, String invoicingMode) {
        ((ImportedDocumentTableDao)this.dao).save(this.createEntity(nip, configId, ksefSystemType, ksefReferenceNumber, fileId, invoicingHash, invoicingDate, invoicingMode));
    }

    private ImportedDocumentTableEntity createEntity(String nip, String configId, String ksefSystemType, String ksefReferenceNumber, Long fileId, String invoicingHash, Timestamp invoicingDate, String invoicingMode) {
        return ImportedDocumentTableEntity.builder().nip(nip).ksefReferenceNumber(ksefReferenceNumber).configId(configId).systemType(ksefSystemType).insertTime(Timestamp.from(Instant.now())).fileId(fileId).invoicingHash(invoicingHash).invoicingDate(invoicingDate).invoicingMode(invoicingMode).build();
    }

    @Override
    public boolean isLoaded(String ksefReferenceNumber) {
        HibernateCriteria importedDocument = HibernateCriteria.forClass(ImportedDocumentTableEntity.class).add(Restrictions.eq((String)"ksefReferenceNumber", (Object)ksefReferenceNumber));
        return !((ImportedDocumentTableDao)this.dao).findByCriteria(importedDocument).isEmpty();
    }

    @Override
    public Optional<ImportedDocumentTableEntity> getEntity(Long fileId) {
        HibernateCriteria importedDocument = HibernateCriteria.forClass(ImportedDocumentTableEntity.class).add(Restrictions.eq((String)"fileId", (Object)fileId));
        return ((ImportedDocumentTableDao)this.dao).findByCriteria(importedDocument).stream().findFirst();
    }
}

