/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.controller;

import com.suncode.plugin.plusksef.invoice.enums.KsefCustomKeysV3;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeys;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV2;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV3;
import com.suncode.pwfl.search.CountedResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class KsefKeyController {
    private static final Logger log = LoggerFactory.getLogger(KsefKeyController.class);

    @ResponseBody
    @RequestMapping(value={"ksefKeys/v{version}"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getKsefKeys(@PathVariable Long version, @RequestParam String query, @RequestParam int start, @RequestParam int limit) {
        String finalQuery = query.toUpperCase();
        Stream<? extends KsefKeys> keysStream = this.getKsefKeysStream(version);
        List<Map<String, String>> data = keysStream.filter(key -> key.getKey().toUpperCase().contains(finalQuery) || key.getDesc().toUpperCase().contains(finalQuery)).map(this::ksefKeyMap).collect(Collectors.toList());
        return this.getMapCountedResult(data, start, limit);
    }

    @ResponseBody
    @RequestMapping(value={"ksefKeys/v{version}/toExport"}, method={RequestMethod.GET})
    public CountedResult<Map<String, String>> getKsefKeysToExport(@PathVariable Long version, @RequestParam String query, @RequestParam int start, @RequestParam int limit) {
        String finalQuery = query.toUpperCase();
        Stream<? extends KsefKeys> keysStream = this.getKsefKeysStream(version);
        List<Map<String, String>> data = keysStream.filter(key -> key.isPossibleToSet()).filter(key -> key.getKey().toUpperCase().contains(finalQuery) || key.getDesc().toUpperCase().contains(finalQuery)).map(this::ksefKeyMap).collect(Collectors.toList());
        return this.getMapCountedResult(data, start, limit);
    }

    private Map<String, String> ksefKeyMap(KsefKeys key) {
        LinkedHashMap<String, String> ksefKeyMap = new LinkedHashMap<String, String>();
        ksefKeyMap.put("key", key.getKey());
        ksefKeyMap.put("type", key.getType().name().toUpperCase());
        ksefKeyMap.put("desc", key.getDesc());
        return ksefKeyMap;
    }

    private Stream<? extends KsefKeys> getKsefKeysStream(Long version) {
        switch (version.intValue()) {
            case 2: {
                return KsefKeysV2.stream();
            }
            case 3: {
                return Stream.concat(KsefKeysV3.stream(), KsefCustomKeysV3.stream());
            }
        }
        throw new IllegalArgumentException("Unsupported schema version: " + version);
    }

    private CountedResult<Map<String, String>> getMapCountedResult(List<Map<String, String>> data, int from, int limit) {
        int to = Math.min(from + limit, data.size());
        return new CountedResult((long)data.size(), data.subList(from, to));
    }
}

