/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.plugin.plusksef.invoice.enums.KsefCustomKeysV3;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeys;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV2;
import com.suncode.plugin.plusksef.invoice.enums.KsefKeysV3;
import com.suncode.plugin.plusksef.invoice.service.InvoiceDataService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/LoadInvoiceInfoFromXml/pwe_dynamic_form.js")
public class LoadInvoiceInfoFromXml {
    private static final Logger log = LoggerFactory.getLogger(LoadInvoiceInfoFromXml.class);
    private static final String ID = "plusksef.autotask.LoadInvoiceInfoFromXml";
    @Autowired
    private KsefDocumentService ksefDocumentService;
    @Autowired
    private InvoiceDataService invoiceService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.DOCUMENT2)).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("schematVersion").name(ID.concat(".param.schematVersion.name")).description(ID.concat(".param.schematVersion.desc")).type((Type)Types.STRING).defaultValue((Object)"2").create()).parameter().id("variable").name(ID.concat(".param.variable.name")).description(ID.concat(".param.variable.desc")).type((Type)Types.VARIABLE_ARRAY).create()).parameter().id("ksefKey").name(ID.concat(".param.ksefKey.name")).description(ID.concat(".param.ksefKey.desc")).type((Type)Types.STRING_ARRAY).create()).parameter().id("variableForFunction").name(ID.concat(".param.variableForFunction.name")).description(ID.concat(".param.variableForFunction.desc")).type((Type)Types.VARIABLE_ARRAY).optional().create()).parameter().id("ksefKeyFn").name(ID.concat(".param.ksefKeyFn.name")).description(ID.concat(".param.ksefKeyFn.desc")).type((Type)Types.FUNCTION_ARRAY).optional().create();
        this.addContext(builder);
    }

    private void addContext(ApplicationDefinitionBuilder builder) {
        Set<KsefKeysV2> v2Keys = KsefKeysV2.stream().collect(Collectors.toSet());
        Set v2KeySet = v2Keys.stream().map(KsefKeysV2::getKey).collect(Collectors.toSet());
        List<KsefKeys> v3ExcessKeys = Stream.concat(KsefKeysV3.stream(), KsefCustomKeysV3.stream()).filter(v3Key -> !v2KeySet.contains(((KsefKeys)((Object)v3Key)).getKey())).collect(Collectors.toList());
        v2Keys.forEach(ksefKey -> builder.contextVariable().id(ksefKey.getKey()).name(ksefKey.getKey()).description(ksefKey.getDesc()).type(ksefKey.getType()).create());
        v3ExcessKeys.forEach(ksefKey -> builder.contextVariable().id(ksefKey.getKey()).name(ksefKey.getKey()).description(ksefKey.getDesc()).type(ksefKey.getType()).create());
    }

    public void execute(@Param Integer fileId, @Param String schematVersion, @Param Variable[] variable, @Param String[] ksefKey, @Param Variable[] variableForFunction, @Param FunctionCall[] ksefKeyFn, ContextVariables contextVariables) throws AcceptanceException {
        try {
            byte[] xmlDocumentBytes = this.ksefDocumentService.getDocumentBytes(fileId.intValue());
            Map<String, Object> invoiceData = this.invoiceService.getInvoiceDataWithCustomKeys(xmlDocumentBytes, fileId.intValue());
            IntStream.range(0, variable.length).forEach(i -> {
                variable[i].setValue(invoiceData.get(ksefKey[i]));
                log.debug("Set variable {}: {}", (Object)variable[i].getId(), variable[i].getValueAsBasicType());
            });
            this.completeContextVariables(contextVariables, invoiceData, Short.parseShort(schematVersion));
            IntStream.range(0, variableForFunction.length).forEach(i -> {
                variableForFunction[i].setValue(ksefKeyFn[i].call());
                log.debug("Set variable {}: {}", (Object)variableForFunction[i].getId(), variableForFunction[i].getValueAsBasicType());
            });
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void completeContextVariables(ContextVariables contextVariables, Map<String, Object> invoiceData, short schemaVersion) {
        switch (schemaVersion) {
            case 1: {
                log.debug("Schema v1 is no longer supported");
                break;
            }
            case 2: {
                this.processKsefKeys(contextVariables, invoiceData, KsefKeysV2.stream());
                break;
            }
            case 3: {
                this.processKsefKeys(contextVariables, invoiceData, KsefKeysV3.stream());
                break;
            }
            default: {
                log.error("Unsupported schema version: " + schemaVersion);
            }
        }
    }

    private void processKsefKeys(ContextVariables contextVariables, Map<String, Object> invoiceData, Stream<? extends KsefKeys> ksefKeysStream) {
        ksefKeysStream.forEach(ksefKey -> {
            try {
                Object value = invoiceData.get(ksefKey.getKey());
                contextVariables.set(ksefKey.getKey(), value == null ? ksefKey.getType().defaultValue() : value);
            }
            catch (Exception e) {
                log.error("completeContextVariables error: {}, value: {}", (Object)ksefKey.getKey(), invoiceData.get(ksefKey.getKey()));
                log.error(e.getMessage());
            }
        });
    }
}

