/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.v2.services;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.suncode.plugin.plusksef.api.v2.enums.KsefV2AuthenticationMethod;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.api.v2.services.dto.SendInvoiceResponseV2;
import com.suncode.plugin.plusksef.api.v2.services.dto.SessionInfoV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import java.net.http.HttpClient;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.api.KsefApiProperties;
import pl.akmf.ksef.sdk.api.builders.auth.AuthKsefTokenRequestBuilder;
import pl.akmf.ksef.sdk.api.builders.auth.AuthTokenRequestBuilder;
import pl.akmf.ksef.sdk.api.builders.auth.AuthTokenRequestSerializer;
import pl.akmf.ksef.sdk.api.builders.invoices.InvoiceQueryFiltersBuilder;
import pl.akmf.ksef.sdk.api.builders.session.OpenOnlineSessionRequestBuilder;
import pl.akmf.ksef.sdk.api.builders.session.SendInvoiceOnlineSessionRequestBuilder;
import pl.akmf.ksef.sdk.api.services.DefaultCryptographyService;
import pl.akmf.ksef.sdk.api.services.DefaultSignatureService;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.interfaces.SignatureService;
import pl.akmf.ksef.sdk.client.model.ApiException;
import pl.akmf.ksef.sdk.client.model.auth.AuthKsefTokenRequest;
import pl.akmf.ksef.sdk.client.model.auth.AuthOperationStatusResponse;
import pl.akmf.ksef.sdk.client.model.auth.AuthStatus;
import pl.akmf.ksef.sdk.client.model.auth.AuthenticationChallengeResponse;
import pl.akmf.ksef.sdk.client.model.auth.ContextIdentifier;
import pl.akmf.ksef.sdk.client.model.auth.SignatureResponse;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQueryDateRange;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQueryDateType;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQueryFilters;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQuerySubjectType;
import pl.akmf.ksef.sdk.client.model.invoice.QueryInvoiceMetadataResponse;
import pl.akmf.ksef.sdk.client.model.session.EncryptionData;
import pl.akmf.ksef.sdk.client.model.session.FileMetadata;
import pl.akmf.ksef.sdk.client.model.session.FormCode;
import pl.akmf.ksef.sdk.client.model.session.SchemaVersion;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoiceStatusResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoicesResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionStatusResponse;
import pl.akmf.ksef.sdk.client.model.session.SessionValue;
import pl.akmf.ksef.sdk.client.model.session.SystemCode;
import pl.akmf.ksef.sdk.client.model.session.online.OpenOnlineSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.online.OpenOnlineSessionResponse;
import pl.akmf.ksef.sdk.client.model.session.online.SendInvoiceOnlineSessionRequest;
import pl.akmf.ksef.sdk.client.model.session.online.SendInvoiceResponse;
import pl.akmf.ksef.sdk.client.model.xml.AuthTokenRequest;
import pl.akmf.ksef.sdk.client.model.xml.SubjectIdentifierTypeEnum;

@Service
public class KSeFServiceApiV2Impl
implements KSeFServiceApiV2 {
    private static final Logger log = LoggerFactory.getLogger(KSeFServiceApiV2Impl.class);

    @Override
    public DefaultKsefClient initKsefClient(final String ksefUrl) {
        ObjectMapper objectMapper = new ObjectMapper().configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).registerModule((Module)new JavaTimeModule());
        KsefApiProperties apiProperties = new KsefApiProperties(){

            public String getBaseUri() {
                return ksefUrl;
            }

            public Duration getRequestTimeout() {
                return Duration.ofSeconds(30L);
            }

            public Map<String, String> getDefaultHeaders() {
                return new HashMap<String, String>();
            }
        };
        HttpClient apiClient = HttpClient.newHttpClient();
        return new DefaultKsefClient(apiClient, apiProperties, objectMapper);
    }

    @Override
    public KSeFServiceApiV2.AuthTokensPair getAuthTokens(KSeFClient ksefClient, KsefImportConfig config) throws Exception {
        if (config.getApiV2authenticationMethods() == KsefV2AuthenticationMethod.KSEF_TOKEN) {
            return this.authenticateWithKsefToken(ksefClient, config);
        }
        return this.authenticateWithQualifiedSignature(ksefClient, config);
    }

    @Override
    public KSeFServiceApiV2.AuthTokensPair authenticateWithQualifiedSignature(KSeFClient ksefClient, KsefImportConfig config) throws Exception {
        AuthenticationChallengeResponse challenge = ksefClient.getAuthChallenge();
        log.debug("Received authentication challenge: {}", (Object)challenge);
        AuthTokenRequest authTokenRequest = new AuthTokenRequestBuilder().withChallenge(challenge.getChallenge()).withContextNip(config.getNip()).withSubjectType(SubjectIdentifierTypeEnum.CERTIFICATE_SUBJECT).build();
        String xml = this.runWithPluginContextClassLoader(() -> AuthTokenRequestSerializer.authTokenRequestSerializer((AuthTokenRequest)authTokenRequest));
        DefaultCryptographyService cryptographyService = new DefaultCryptographyService(ksefClient);
        X509Certificate x509Certificate = cryptographyService.parseCertificateFromBytes(config.getApiV2CertificatePEM().getBytes());
        String keyData = this.cleanPrivateKeyPem(config.getApiV2PrivateKeyPEM());
        byte[] keyBytes = Base64.getDecoder().decode(keyData);
        PrivateKey privateKey = cryptographyService.parseEcdsaPrivateKeyFromPem(keyBytes);
        SignatureService signatureService = (SignatureService)this.runWithPluginContextClassLoader(DefaultSignatureService::new);
        String signedXml = this.runWithPluginContextClassLoader(() -> signatureService.sign(xml.getBytes(), x509Certificate, privateKey));
        SignatureResponse submitAuthTokenResponse = ksefClient.submitAuthTokenRequest(signedXml, false);
        Awaitility.await().atMost(14L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> this.isAuthProcessReady(ksefClient, submitAuthTokenResponse.getReferenceNumber(), submitAuthTokenResponse.getAuthenticationToken().getToken()));
        AuthOperationStatusResponse tokenResponse = ksefClient.redeemToken(submitAuthTokenResponse.getAuthenticationToken().getToken());
        return new KSeFServiceApiV2.AuthTokensPair(tokenResponse.getAccessToken().getToken(), tokenResponse.getRefreshToken().getToken());
    }

    @Override
    public SendInvoiceResponseV2 sendInvoice(KsefImportConfig config, byte[] invoiceBytes) throws Exception {
        log.debug("Sending invoice using KSeF API v2");
        DefaultKsefClient ksefClient = this.initKsefClient(config.getKsefUrl());
        DefaultCryptographyService cryptographyService = new DefaultCryptographyService((KSeFClient)ksefClient);
        EncryptionData encryptionData = cryptographyService.getEncryptionData();
        SessionInfoV2 sessionInfo = this.openOnlineSession(config, (KSeFClient)ksefClient, encryptionData);
        byte[] encryptedInvoice = cryptographyService.encryptBytesWithAES256(invoiceBytes, encryptionData.cipherKey(), encryptionData.cipherIv());
        FileMetadata invoiceMetadata = cryptographyService.getMetaData(invoiceBytes);
        FileMetadata encryptedInvoiceMetadata = cryptographyService.getMetaData(encryptedInvoice);
        SendInvoiceOnlineSessionRequest sendInvoiceOnlineSessionRequest = new SendInvoiceOnlineSessionRequestBuilder().withInvoiceHash(invoiceMetadata.getHashSHA()).withInvoiceSize(invoiceMetadata.getFileSize().longValue()).withEncryptedInvoiceHash(encryptedInvoiceMetadata.getHashSHA()).withEncryptedInvoiceSize(encryptedInvoiceMetadata.getFileSize().longValue()).withEncryptedInvoiceContent(Base64.getEncoder().encodeToString(encryptedInvoice)).build();
        SendInvoiceResponse sendInvoiceResponse = ksefClient.onlineSessionSendInvoice(sessionInfo.getSessionReferenceNumber(), sendInvoiceOnlineSessionRequest, sessionInfo.getAccessToken());
        this.terminateSession((KSeFClient)ksefClient, sessionInfo.getSessionReferenceNumber(), sessionInfo.getAccessToken());
        Assert.notNull((Object)sendInvoiceResponse, (String)"sendInvoiceResponse is null");
        Assert.notNull((Object)sendInvoiceResponse.getReferenceNumber(), (String)"sendInvoiceResponse.getReferenceNumber() is null");
        return SendInvoiceResponseV2.builder().sessionInfo(sessionInfo).exportReferenceNumber(sendInvoiceResponse.getReferenceNumber()).build();
    }

    @Override
    public QueryInvoiceMetadataResponse getInvoiceMetadata(KSeFClient ksefClient, String accessToken, Date dateFrom, Date dateTo, int pageSize, int offset) throws ApiException {
        InvoiceQueryFilters request = new InvoiceQueryFiltersBuilder().withSubjectType(InvoiceQuerySubjectType.SUBJECT2).withDateRange(new InvoiceQueryDateRange(InvoiceQueryDateType.INVOICING, dateFrom.toInstant().atOffset(ZoneOffset.UTC), dateTo.toInstant().atOffset(ZoneOffset.UTC))).build();
        return ksefClient.queryInvoiceMetadata(Integer.valueOf(offset), Integer.valueOf(pageSize), request, accessToken);
    }

    @Override
    public List<SessionInvoiceStatusResponse> getOnlineSessionDocuments(KSeFClient ksefClient, String sessionReferenceNumber, String accessToken) throws ApiException {
        SessionInvoicesResponse page;
        int limit = 10;
        ArrayList<SessionInvoiceStatusResponse> invoiceStatusResponses = new ArrayList<SessionInvoiceStatusResponse>();
        String continuationToken = null;
        while ((page = ksefClient.getSessionInvoices(sessionReferenceNumber, continuationToken, Integer.valueOf(limit), accessToken)) != null && page.getInvoices() != null && !page.getInvoices().isEmpty()) {
            invoiceStatusResponses.addAll(page.getInvoices());
            String nextToken = page.getContinuationToken();
            if (nextToken == null || nextToken.isBlank() || nextToken.equals(continuationToken)) break;
            continuationToken = nextToken;
        }
        return invoiceStatusResponses;
    }

    @Override
    public void terminateSession(KSeFClient ksefClient, String sessionReferenceNumber, String accessToken) throws ApiException {
        ksefClient.closeOnlineSession(sessionReferenceNumber, accessToken);
    }

    @Override
    public boolean isUpoGenerated(KSeFClient ksefClient, String sessionReferenceNumber, String accessToken) throws ApiException {
        SessionStatusResponse statusResponse = ksefClient.getSessionStatus(sessionReferenceNumber, accessToken);
        return statusResponse != null && statusResponse.getStatus().getCode() == 200;
    }

    @Override
    public byte[] getInvoice(KSeFClient ksefClient, String ksefNumber, String accessToken) throws ApiException {
        log.debug("Getting invoice by KSeF number: {}", (Object)ksefNumber);
        return ksefClient.getInvoice(ksefNumber, accessToken);
    }

    @Override
    public byte[] getUPO(KSeFClient ksefClient, String sessionReferenceNumber, String ksefNumber, String accessToken) throws ApiException {
        log.debug("Getting UPO for session: {} and ksefNumber: {}", (Object)sessionReferenceNumber, (Object)ksefNumber);
        return ksefClient.getSessionInvoiceUpoByKsefNumber(sessionReferenceNumber, ksefNumber, accessToken);
    }

    private SessionInfoV2 openOnlineSession(KsefImportConfig config, KSeFClient ksefClient, EncryptionData encryptionData) throws Exception {
        log.debug("Getting session using KSeF API v2");
        KSeFServiceApiV2.AuthTokensPair authTokensPair = this.getAuthTokens(config);
        FormCode formCode = new FormCode(SystemCode.FA_3, SchemaVersion.VERSION_1_0E, SessionValue.FA);
        OpenOnlineSessionRequest sessionRequest = new OpenOnlineSessionRequestBuilder().withFormCode(formCode).withEncryptionInfo(encryptionData.encryptionInfo()).build();
        OpenOnlineSessionResponse sessionResponse = ksefClient.openOnlineSession(sessionRequest, authTokensPair.accessToken());
        log.debug("Online session opened: {}", (Object)sessionResponse.getReferenceNumber());
        return SessionInfoV2.builder().nip(config.getNip()).ksefSystemType(config.getKsefSystemType()).accessToken(authTokensPair.accessToken()).refreshToken(authTokensPair.refreshToken()).sessionReferenceNumber(sessionResponse.getReferenceNumber()).build();
    }

    private KSeFServiceApiV2.AuthTokensPair getAuthTokens(KsefImportConfig config) throws Exception {
        DefaultKsefClient ksefClient = this.initKsefClient(config.getKsefUrl());
        return this.getAuthTokens((KSeFClient)ksefClient, config);
    }

    private KSeFServiceApiV2.AuthTokensPair authenticateWithKsefToken(KSeFClient ksefClient, KsefImportConfig config) throws ApiException {
        AuthenticationChallengeResponse challenge = ksefClient.getAuthChallenge();
        DefaultCryptographyService cryptographyService = new DefaultCryptographyService(ksefClient);
        byte[] encryptedToken = cryptographyService.encryptKsefTokenWithRSAUsingPublicKey(config.getApiV2Token(), challenge.getTimestamp());
        AuthKsefTokenRequest authTokenRequest = new AuthKsefTokenRequestBuilder().withChallenge(challenge.getChallenge()).withContextIdentifier(new ContextIdentifier(ContextIdentifier.IdentifierType.NIP, config.getNip())).withEncryptedToken(Base64.getEncoder().encodeToString(encryptedToken)).build();
        SignatureResponse signatureResponse = ksefClient.authenticateByKSeFToken(authTokenRequest);
        Awaitility.await().atMost(14L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> this.isAuthProcessReady(ksefClient, signatureResponse.getReferenceNumber(), signatureResponse.getAuthenticationToken().getToken()));
        AuthOperationStatusResponse tokenResponse = ksefClient.redeemToken(signatureResponse.getAuthenticationToken().getToken());
        return new KSeFServiceApiV2.AuthTokensPair(tokenResponse.getAccessToken().getToken(), tokenResponse.getRefreshToken().getToken());
    }

    private boolean isAuthProcessReady(KSeFClient ksefClient, String referenceNumber, String tempAuthToken) throws ApiException {
        AuthStatus checkAuthStatus = ksefClient.getAuthStatus(referenceNumber, tempAuthToken);
        return checkAuthStatus.getStatus().getCode() == 200;
    }

    private String cleanPrivateKeyPem(String privateKeyPem) {
        return privateKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runWithPluginContextClassLoader(Callable<T> supplier) throws Exception {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(KSeFServiceApiV2Impl.class.getClassLoader());
            T t = supplier.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

