/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.client.model.session;

import java.util.Objects;
import pl.akmf.ksef.sdk.client.model.session.EncryptionInfo;

public class EncryptionData {
    private final byte[] cipherKey;
    private final byte[] cipherIv;
    private final String encryptedCipherKey;
    private final EncryptionInfo encryptionInfo;

    public EncryptionData(byte[] cipherKey, byte[] cipherIv, String encryptedCipherKey, EncryptionInfo encryptionInfo) {
        if (cipherKey == null) {
            throw new IllegalArgumentException("cipherKey cannot be null");
        }
        if (cipherIv == null) {
            throw new IllegalArgumentException("cipherIv cannot be null");
        }
        if (encryptedCipherKey == null) {
            throw new IllegalArgumentException("encryptedCipherKey cannot be null");
        }
        if (encryptionInfo == null) {
            throw new IllegalArgumentException("encryptionInfo cannot be null");
        }
        this.cipherKey = (byte[])cipherKey.clone();
        this.cipherIv = (byte[])cipherIv.clone();
        this.encryptedCipherKey = encryptedCipherKey;
        this.encryptionInfo = encryptionInfo;
    }

    public byte[] cipherKey() {
        return this.cipherKey;
    }

    public byte[] cipherIv() {
        return this.cipherIv;
    }

    public String encryptedCipherKey() {
        return this.encryptedCipherKey;
    }

    public EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EncryptionData that = (EncryptionData)obj;
        return Objects.equals(this.cipherKey, that.cipherKey) && Objects.equals(this.cipherIv, that.cipherIv) && Objects.equals(this.encryptedCipherKey, that.encryptedCipherKey) && Objects.equals(this.encryptionInfo, that.encryptionInfo);
    }

    public int hashCode() {
        return Objects.hash(this.cipherKey, this.cipherIv, this.encryptedCipherKey, this.encryptionInfo);
    }

    public String toString() {
        return "EncryptionData[cipherKey=" + String.valueOf(this.cipherKey) + ", cipherIv=" + String.valueOf(this.cipherIv) + ", encryptedCipherKey=" + this.encryptedCipherKey + ", encryptionInfo=" + String.valueOf(this.encryptionInfo) + "]";
    }
}

