/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.model.invoice.InvoiceStatusResponse;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.scheduledtask.LoadInvoiceStatusFromKSeFSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoiceStatusResponse;

@ScheduledTask
public class LoadInvoiceStatusFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(LoadInvoiceStatusFromKSeF.class);
    private static final String ID = "plusksef.scheduledTask.LoadInvoiceStatusFromKSeF";
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KsefActivityService activityService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).cancelable().parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("processDefId").name(ID.concat(".param.processDefId.name")).description(ID.concat(".param.processDefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(ID.concat(".param.activityDefId.name")).description(ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("referenceNumberVariableId").name(ID.concat(".param.referenceNumberVariableId.name")).description(ID.concat(".param.referenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("actionId").name(ID.concat(".param.actionId.name")).description(ID.concat(".param.actionId.desc")).type((Type)Types.STRING).create()).parameter().id("invoiceStatusVariableId").name(ID.concat(".param.invoiceStatusVariable.name")).description(ID.concat(".param.invoiceStatusVariable.desc")).type((Type)Types.STRING).create()).parameter().id("ksefReferenceNumberVariableId").name(ID.concat(".param.ksefReferenceNumberVariableId.name")).description(ID.concat(".param.ksefReferenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("ksefResponseJsonVariableId").name(ID.concat(".param.ksefResponseJsonVariableId.name")).description(ID.concat(".param.ksefResponseJsonVariableId.desc")).type((Type)Types.STRING).optional().create();
    }

    public String execute(@Param String configId, @Param String processDefId, @Param String activityDefId, @Param(value="referenceNumberVariableId") String elementReferenceNumberVariableId, @Param String actionId, @Param String invoiceStatusVariableId, @Param String ksefReferenceNumberVariableId, @Param String ksefResponseJsonVariableId, org.apache.log4j.Logger logger) throws Exception {
        try {
            List<Activity> activities = this.activityService.findOpenActivities(processDefId, activityDefId);
            logger.debug((Object)("Found " + activities.size() + " tasks."));
            if (activities.isEmpty()) {
                logger.warn((Object)"No open tasks found");
                return "No open tasks found";
            }
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary = new LoadInvoiceStatusFromKSeFSummary();
            loadInvoiceStatusFromKSeFSummary.setNumberOfDocumentsFound(activities.size());
            if (ksefImportConfig.getApiVersion() == KsefApiVersion.V2) {
                this.executeKSeFv2(ksefImportConfig, activities, elementReferenceNumberVariableId, actionId, invoiceStatusVariableId, ksefReferenceNumberVariableId, logger, loadInvoiceStatusFromKSeFSummary, ksefResponseJsonVariableId);
            } else {
                this.executeKSeFv1(ksefImportConfig, activities, elementReferenceNumberVariableId, actionId, invoiceStatusVariableId, ksefReferenceNumberVariableId, logger, loadInvoiceStatusFromKSeFSummary, ksefResponseJsonVariableId);
            }
            return loadInvoiceStatusFromKSeFSummary.buildSummary();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private void executeKSeFv1(KsefImportConfig ksefImportConfig, List<Activity> activities, String elementReferenceNumberVariableId, String actionId, String invoiceStatusVariableId, String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger, LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary, String ksefResponseJsonVariableId) throws Exception {
        SessionInfo sessionInfo = this.kSeFServiceApiV1.getSession(ksefImportConfig);
        for (Activity activity : activities) {
            this.updateActivityV1(elementReferenceNumberVariableId, actionId, invoiceStatusVariableId, ksefReferenceNumberVariableId, logger, ksefImportConfig, loadInvoiceStatusFromKSeFSummary, sessionInfo.getSessionToken(), activity, ksefResponseJsonVariableId);
        }
    }

    private void executeKSeFv2(KsefImportConfig ksefImportConfig, List<Activity> activities, String elementReferenceNumberVariableId, String actionId, String invoiceStatusVariableId, String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger, LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary, String ksefResponseJsonVariableId) {
        Map<String, List<Activity>> activitiesBySession = this.groupActivitiesBySessionReference(activities, elementReferenceNumberVariableId, logger);
        Map<String, List<SessionInvoiceStatusResponse>> sessionDocumentsMap = this.fetchSessionDocumentsMap(ksefImportConfig, activitiesBySession.keySet(), logger);
        for (Map.Entry<String, List<Activity>> sessionEntry : activitiesBySession.entrySet()) {
            String sessionReferenceNumber = sessionEntry.getKey();
            List<Activity> sessionActivities = sessionEntry.getValue();
            List<SessionInvoiceStatusResponse> invoiceStatusResponses = sessionDocumentsMap.get(sessionReferenceNumber);
            for (Activity activity : sessionActivities) {
                this.updateActivityV2(elementReferenceNumberVariableId, actionId, invoiceStatusVariableId, ksefReferenceNumberVariableId, logger, loadInvoiceStatusFromKSeFSummary, activity, invoiceStatusResponses, ksefResponseJsonVariableId);
            }
        }
    }

    private void updateActivityV1(String elementReferenceNumberVariableId, String actionId, String invoiceStatusVariableId, String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger, KsefImportConfig ksefImportConfig, LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary, String sessionToken, Activity activity, String ksefResponseJsonVariableId) {
        try {
            logger.debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
            loadInvoiceStatusFromKSeFSummary.increaseProcessedDocuments();
            Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            String elementReferenceNumber = activityContext.get(elementReferenceNumberVariableId).toString();
            String sessionReferenceNumber = this.exportedDocumentTableService.getRowByExportReferenceNumber(elementReferenceNumber).getSessionReferenceNumber();
            logger.debug((Object)String.format("Session reference number: %s. Element reference number: %s.", sessionReferenceNumber, elementReferenceNumber));
            InvoiceStatusResponse invoiceStatusResponse = this.kSeFServiceApiV1.loadInvoiceStatus(ksefImportConfig.getKsefUrl(), sessionToken, elementReferenceNumber);
            logger.debug((Object)String.format("Processing code: %s. Processing description: %s", invoiceStatusResponse.getProcessingCode(), invoiceStatusResponse.getProcessingDescription()));
            if (invoiceStatusResponse.getProcessingCode() == 200) {
                this.exportedDocumentTableService.updateRecord(elementReferenceNumber, invoiceStatusResponse.getProcessingDescription(), invoiceStatusResponse.getInvoiceStatus().getKsefReferenceNumber());
                activityContext.put(invoiceStatusVariableId, "OK");
                activityContext.put(ksefReferenceNumberVariableId, invoiceStatusResponse.getInvoiceStatus().getKsefReferenceNumber());
            } else {
                this.exportedDocumentTableService.updateRecord(elementReferenceNumber, invoiceStatusResponse.getProcessingDescription());
                activityContext.put(invoiceStatusVariableId, invoiceStatusResponse.getProcessingDescription());
            }
            if (StringUtils.isNotBlank((CharSequence)ksefResponseJsonVariableId)) {
                String responseJson = LoadInvoiceStatusFromKSeF.toJSON(invoiceStatusResponse);
                activityContext.put(ksefResponseJsonVariableId, responseJson);
            }
            this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
            loadInvoiceStatusFromKSeFSummary.increaseAcceptInvoiceProcess();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            loadInvoiceStatusFromKSeFSummary.increaseErrors();
        }
    }

    private void updateActivityV2(String elementReferenceNumberVariableId, String actionId, String invoiceStatusVariableId, String ksefReferenceNumberVariableId, org.apache.log4j.Logger logger, LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary, Activity activity, List<SessionInvoiceStatusResponse> sessionDocuments, String ksefResponseJsonVariableId) {
        try {
            logger.debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
            loadInvoiceStatusFromKSeFSummary.increaseProcessedDocuments();
            Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            String exportReferenceNumber = activityContext.get(elementReferenceNumberVariableId).toString();
            SessionInvoiceStatusResponse invoiceStatusResponse = this.findInvoiceStatusByReferenceNumber(sessionDocuments, exportReferenceNumber);
            if (invoiceStatusResponse == null) {
                logger.warn((Object)("No invoice status found for export reference number: " + exportReferenceNumber));
                String status = "Document not found in KSeF session";
                this.exportedDocumentTableService.updateRecord(exportReferenceNumber, status);
                activityContext.put(invoiceStatusVariableId, status);
                this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
                loadInvoiceStatusFromKSeFSummary.increaseErrors();
                return;
            }
            logger.debug((Object)String.format("Processing code: %s. Processing description: %s", invoiceStatusResponse.getStatus().getCode(), invoiceStatusResponse.getStatus().getDescription()));
            if (invoiceStatusResponse.getStatus().getCode() == 200) {
                this.exportedDocumentTableService.updateRecord(exportReferenceNumber, invoiceStatusResponse.getStatus().getDescription(), invoiceStatusResponse.getKsefNumber(), invoiceStatusResponse.getInvoiceHash(), invoiceStatusResponse.getInvoicingDate(), invoiceStatusResponse.getUpoDownloadUrl(), invoiceStatusResponse.getInvoicingMode().name());
                activityContext.put(invoiceStatusVariableId, "OK");
                activityContext.put(ksefReferenceNumberVariableId, invoiceStatusResponse.getKsefNumber());
            } else {
                this.exportedDocumentTableService.updateRecord(exportReferenceNumber, invoiceStatusResponse.getStatus().getDescription());
                activityContext.put(invoiceStatusVariableId, invoiceStatusResponse.getStatus().getDescription());
            }
            if (StringUtils.isNotBlank((CharSequence)ksefResponseJsonVariableId)) {
                String responseJson = LoadInvoiceStatusFromKSeF.toJSON(invoiceStatusResponse);
                activityContext.put(ksefResponseJsonVariableId, responseJson);
            }
            this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
            loadInvoiceStatusFromKSeFSummary.increaseAcceptInvoiceProcess();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            loadInvoiceStatusFromKSeFSummary.increaseErrors();
        }
    }

    private static String toJSON(Object invoiceStatusResponse) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper.writeValueAsString(invoiceStatusResponse);
    }

    private Map<String, List<Activity>> groupActivitiesBySessionReference(List<Activity> activities, String elementReferenceNumberVariableId, org.apache.log4j.Logger logger) {
        HashMap<String, List<Activity>> activitiesBySession = new HashMap<String, List<Activity>>();
        for (Activity activity : activities) {
            try {
                Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                String exportReferenceNumber = activityContext.get(elementReferenceNumberVariableId).toString();
                ExportedDocumentTableEntity exportedRow = this.exportedDocumentTableService.getRowByExportReferenceNumber(exportReferenceNumber);
                String sessionReferenceNumber = exportedRow.getSessionReferenceNumber();
                activitiesBySession.computeIfAbsent(sessionReferenceNumber, k -> new ArrayList()).add(activity);
            }
            catch (Exception e) {
                logger.error((Object)("Error grouping activity by session reference: " + e.getMessage()));
            }
        }
        return activitiesBySession;
    }

    private Map<String, List<SessionInvoiceStatusResponse>> fetchSessionDocumentsMap(KsefImportConfig ksefImportConfig, Set<String> sessionReferenceNumbers, org.apache.log4j.Logger logger) {
        DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(ksefImportConfig.getKsefUrl());
        HashMap<String, List<SessionInvoiceStatusResponse>> sessionDocumentsMap = new HashMap<String, List<SessionInvoiceStatusResponse>>();
        for (String sessionReferenceNumber : sessionReferenceNumbers) {
            try {
                List<ExportedDocumentTableEntity> exportedRows = this.exportedDocumentTableService.getRowBySessionReferenceNumber(sessionReferenceNumber);
                if (!exportedRows.isEmpty()) {
                    List<SessionInvoiceStatusResponse> sessionDocuments = this.kSeFServiceApiV2.getOnlineSessionDocuments(ksefClient, sessionReferenceNumber, exportedRows.get(0).getSessionToken());
                    sessionDocumentsMap.put(sessionReferenceNumber, sessionDocuments);
                    logger.debug((Object)("Fetched " + sessionDocuments.size() + " documents for session: " + sessionReferenceNumber));
                    continue;
                }
                logger.warn((Object)("No exported documents found for session: " + sessionReferenceNumber));
                sessionDocumentsMap.put(sessionReferenceNumber, new ArrayList());
            }
            catch (Exception e) {
                logger.error((Object)("Error fetching session documents for session " + sessionReferenceNumber + ": " + e.getMessage()));
                sessionDocumentsMap.put(sessionReferenceNumber, new ArrayList());
            }
        }
        return sessionDocumentsMap;
    }

    private SessionInvoiceStatusResponse findInvoiceStatusByReferenceNumber(List<SessionInvoiceStatusResponse> sessionDocuments, String exportReferenceNumber) {
        if (sessionDocuments == null || sessionDocuments.isEmpty()) {
            return null;
        }
        for (SessionInvoiceStatusResponse response : sessionDocuments) {
            if (response.getReferenceNumber() == null || !response.getReferenceNumber().equals(exportReferenceNumber)) continue;
            return response;
        }
        return null;
    }
}

