/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.scheduledtask.ImportUPOFromKSeFSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;

@ScheduledTask
public class ImportUPOFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ImportUPOFromKSeF.class);
    private static final String ID = "plusksef.scheduledTask.ImportUPOFromKSeF";
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private KsefActivityService activityService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).cancelable().parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("processDefId").name(ID.concat(".param.processDefId.name")).description(ID.concat(".param.processDefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(ID.concat(".param.activityDefId.name")).description(ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("ksefReferenceNumberVariableId").name(ID.concat(".param.ksefReferenceNumberVariableId.name")).description(ID.concat(".param.ksefReferenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("actionId").name(ID.concat(".param.actionId.name")).description(ID.concat(".param.actionId.desc")).type((Type)Types.STRING).create()).parameter().id("documentClassName").name(ID.concat(".param.documentClassName.name")).description(ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("forceSessionClose").name(ID.concat(".param.forceSessionClose.name")).description(ID.concat(".param.forceSessionClose.desc")).type((Type)Types.BOOLEAN).create();
    }

    public String execute(@Param String configId, @Param String processDefId, @Param String activityDefId, @Param String ksefReferenceNumberVariableId, @Param String actionId, @Param String documentClassName, @Param Boolean forceSessionClose, org.apache.log4j.Logger logger) throws Exception {
        try {
            List<Activity> activities = this.activityService.findOpenActivities(processDefId, activityDefId);
            logger.debug((Object)("Found " + activities.size() + " tasks."));
            if (activities.isEmpty()) {
                logger.warn((Object)"No open tasks found");
                return "No open tasks found";
            }
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            ImportUPOFromKSeFSummary importUPOFromKSeFSummary = new ImportUPOFromKSeFSummary();
            importUPOFromKSeFSummary.setNumberOfDocumentsFound(activities.size());
            LinkedHashMap<String, byte[]> importedUPO = new LinkedHashMap<String, byte[]>();
            String accessToken = null;
            DefaultKsefClient ksefClient = null;
            for (Activity activity : activities) {
                try {
                    if (ksefImportConfig.getApiVersion() == KsefApiVersion.V2) {
                        if (accessToken == null) {
                            ksefClient = this.kSeFServiceApiV2.initKsefClient(ksefImportConfig.getKsefUrl());
                            accessToken = this.kSeFServiceApiV2.getAuthTokens(ksefClient, ksefImportConfig).accessToken();
                        }
                        this.loadUPOAndUpdateActivityV2(ksefClient, accessToken, ksefReferenceNumberVariableId, actionId, documentClassName, forceSessionClose, logger, importUPOFromKSeFSummary, importedUPO, activity);
                        continue;
                    }
                    this.loadUPOAndUpdateActivityV1(ksefReferenceNumberVariableId, actionId, documentClassName, forceSessionClose, logger, ksefImportConfig, importUPOFromKSeFSummary, importedUPO, activity);
                }
                catch (Exception e) {
                    importUPOFromKSeFSummary.increaseOmitted();
                    logger.error((Object)e.getMessage());
                }
            }
            return importUPOFromKSeFSummary.buildSummary();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private void loadUPOAndUpdateActivityV1(String ksefReferenceNumberVariableId, String actionId, String documentClassName, Boolean forceSessionClose, org.apache.log4j.Logger logger, KsefImportConfig ksefImportConfig, ImportUPOFromKSeFSummary importUPOFromKSeFSummary, Map<String, byte[]> importedUPO, Activity activity) throws Exception {
        logger.debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
        importUPOFromKSeFSummary.increaseProcessedDocuments();
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        String ksefReferenceNumber = activityContext.get(ksefReferenceNumberVariableId).toString();
        ExportedDocumentTableEntity rowByReferenceNumber = this.exportedDocumentTableService.getRowByKsefReferenceNumber(ksefReferenceNumber);
        String referenceNumber = rowByReferenceNumber.getExportReferenceNumber();
        logger.debug((Object)String.format("Load UPO for referenceNumber: %s", referenceNumber));
        if (forceSessionClose.booleanValue() && !importedUPO.containsKey(referenceNumber)) {
            this.closeSessionV1(logger, ksefImportConfig.getKsefUrl(), rowByReferenceNumber.getSessionToken(), referenceNumber);
            logger.debug((Object)String.format("Close session: %s", referenceNumber));
        }
        if (!importedUPO.containsKey(referenceNumber)) {
            Optional<byte[]> upo = this.kSeFServiceApiV1.getUPO(ksefImportConfig.getKsefUrl(), referenceNumber);
            if (upo.isEmpty()) {
                logger.warn((Object)String.format("No UPO for: %s", referenceNumber));
                importUPOFromKSeFSummary.increaseOmitted();
                return;
            }
            importedUPO.put(referenceNumber, upo.get());
        }
        this.addUPOAndAcceptActivity(logger, actionId, activity, activityContext, documentClassName, importedUPO.get(referenceNumber), rowByReferenceNumber.getExportReferenceNumber());
        importUPOFromKSeFSummary.increaseAcceptInvoiceProcess();
    }

    private void loadUPOAndUpdateActivityV2(KSeFClient ksefClient, String accessToken, String ksefReferenceNumberVariableId, String actionId, String documentClassName, Boolean forceSessionClose, org.apache.log4j.Logger logger, ImportUPOFromKSeFSummary importUPOFromKSeFSummary, Map<String, byte[]> importedUPO, Activity activity) throws Exception {
        logger.debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
        importUPOFromKSeFSummary.increaseProcessedDocuments();
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        String ksefReferenceNumber = activityContext.get(ksefReferenceNumberVariableId).toString();
        ExportedDocumentTableEntity rowByElementReferenceNumber = this.exportedDocumentTableService.getRowByKsefReferenceNumber(ksefReferenceNumber);
        String sessionReferenceNumber = rowByElementReferenceNumber.getSessionReferenceNumber();
        logger.debug((Object)String.format("Load UPO for session referenceNumber: %s", sessionReferenceNumber));
        if (forceSessionClose.booleanValue() && !importedUPO.containsKey(sessionReferenceNumber)) {
            this.closeSessionAndWaitingForUPOV2(logger, ksefClient, sessionReferenceNumber, accessToken);
            logger.debug((Object)String.format("Close session: %s", sessionReferenceNumber));
        }
        if (!importedUPO.containsKey(sessionReferenceNumber)) {
            byte[] upo = this.kSeFServiceApiV2.getUPO(ksefClient, sessionReferenceNumber, ksefReferenceNumber, accessToken);
            importedUPO.put(sessionReferenceNumber, upo);
        }
        this.addUPOAndAcceptActivity(logger, actionId, activity, activityContext, documentClassName, importedUPO.get(sessionReferenceNumber), rowByElementReferenceNumber.getExportReferenceNumber());
        importUPOFromKSeFSummary.increaseAcceptInvoiceProcess();
    }

    private void addUPOAndAcceptActivity(org.apache.log4j.Logger logger, String actionId, Activity activity, Map<String, Object> activityContext, String documentClassName, byte[] upo, String referenceNumber) throws Exception {
        logger.debug((Object)String.format("UPO found. Accept activity: %s", activity.getActivityId()));
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(documentClassName, referenceNumber + ".xml", upo, null, true, true, activity.getActivityId(), activity.getProcessId(), null);
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, actionId);
    }

    private void closeSessionV1(org.apache.log4j.Logger logger, String ksefUrl, String sessionToken, String referenceNumber) {
        try {
            this.kSeFServiceApiV1.terminateSession(ksefUrl, sessionToken);
            this.kSeFServiceApiV1.waitingForUPOGenerated(ksefUrl, referenceNumber, 30);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void closeSessionAndWaitingForUPOV2(org.apache.log4j.Logger logger, KSeFClient ksefClient, String sessionReferenceNumber, String accessToken) {
        try {
            this.kSeFServiceApiV2.terminateSession(ksefClient, sessionReferenceNumber, accessToken);
            Awaitility.await().atMost(30L, TimeUnit.SECONDS).pollInterval(5L, TimeUnit.SECONDS).until(() -> this.kSeFServiceApiV2.isUpoGenerated(ksefClient, sessionReferenceNumber, accessToken));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }
}

