/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.invoice.enums;

import com.suncode.plugin.plusksef.invoice.enums.KsefKeys;
import com.suncode.plugin.plusksef.invoice.model.ksefV1.FakturaV1;
import com.suncode.plugin.plusksef.invoice.model.ksefV1.TKluczWartosc;
import com.suncode.plugin.plusksef.invoice.model.ksefV1.TRachunekBankowy;
import com.suncode.plugin.plusksef.invoice.util.converter.TypeConverter;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KsefKeysV1 implements KsefKeys
{
    NAGLOWEK_KODFORMULARZA("Naglowek.KodFormularza", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getNaglowek().getKodFormularza().getValue().value();
        }
    }
    ,
    NAGLOWEK_WARIANTFORMULARZA("Naglowek.WariantFormularza", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getNaglowek().getWariantFormularza());
        }
    }
    ,
    NAGLOWEK_DATAWYTWORZENIAFA("Naglowek.DataWytworzeniaFa", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getNaglowek().getDataWytworzeniaFa());
        }
    }
    ,
    NAGLOWEK_SYSTEMINFO("Naglowek.SystemInfo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getNaglowek().getSystemInfo();
        }
    }
    ,
    PODMIOT1_PREFIKSPODATNIKA("Podmiot1.PrefiksPodatnika", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getPrefiksPodatnika().value();
        }
    }
    ,
    PODMIOT1_NREORI("Podmiot1.NrEORI", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getNrEORI();
        }
    }
    ,
    PODMIOT1_EMAIL("Podmiot1.Email", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getEmail();
        }
    }
    ,
    PODMIOT1_TELEFON("Podmiot1.Telefon", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return String.join((CharSequence)",", faktura.getPodmiot1().getTelefon());
        }
    }
    ,
    PODMIOT1_STATUSINFOPODATNIKA("Podmiot1.StatusInfoPodatnika", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getPodmiot1().getStatusInfoPodatnika());
        }
    }
    ,
    PODMIOT1_DANEIDENTYFIKACYJNE_NIP("Podmiot1.DaneIdentyfikacyjne.NIP", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getDaneIdentyfikacyjne().getNIP();
        }
    }
    ,
    PODMIOT1_DANEIDENTYFIKACYJNE_IMIEPIERWSZE("Podmiot1.DaneIdentyfikacyjne.ImiePierwsze", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getDaneIdentyfikacyjne().getImiePierwsze();
        }
    }
    ,
    PODMIOT1_DANEIDENTYFIKACYJNE_NAZWISKO("Podmiot1.DaneIdentyfikacyjne.Nazwisko", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getDaneIdentyfikacyjne().getNazwisko();
        }
    }
    ,
    PODMIOT1_DANEIDENTYFIKACYJNE_PELNANAZWA("Podmiot1.DaneIdentyfikacyjne.PelnaNazwa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getDaneIdentyfikacyjne().getPelnaNazwa();
        }
    }
    ,
    PODMIOT1_DANEIDENTYFIKACYJNE_NAZWAHANDLOWA("Podmiot1.DaneIdentyfikacyjne.NazwaHandlowa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getDaneIdentyfikacyjne().getNazwaHandlowa();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_KODKRAJU("Podmiot1.Adres.AdresPol.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getKodKraju().value();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_WOJEWODZTWO("Podmiot1.Adres.AdresPol.Wojewodztwo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getWojewodztwo();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_POWIAT("Podmiot1.Adres.AdresPol.Powiat", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getPowiat();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_GMINA("Podmiot1.Adres.AdresPol.Gmina", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getGmina();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_ULICA("Podmiot1.Adres.AdresPol.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getUlica();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_NRDOMU("Podmiot1.Adres.AdresPol.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getNrDomu();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_NRLOKALU("Podmiot1.Adres.AdresPol.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getNrLokalu();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_MIEJSCOWOSC("Podmiot1.Adres.AdresPol.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getMiejscowosc();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_KODPOCZTOWY("Podmiot1.Adres.AdresPol.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getKodPocztowy();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_POCZTA("Podmiot1.Adres.AdresPol.Poczta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getPoczta();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESPOL_GLN("Podmiot1.Adres.AdresPol.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresPol().getGLN();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_KODKRAJU("Podmiot1.Adres.AdresZagr.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getKodKraju().value();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_KODPOCZTOWY("Podmiot1.Adres.AdresZagr.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getKodPocztowy();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_MIEJSCOWOSC("Podmiot1.Adres.AdresZagr.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getMiejscowosc();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_ULICA("Podmiot1.Adres.AdresZagr.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getUlica();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_NRDOMU("Podmiot1.Adres.AdresZagr.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getNrDomu();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_NRLOKALU("Podmiot1.Adres.AdresZagr.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getNrLokalu();
        }
    }
    ,
    PODMIOT1_ADRES_ADRESZAGR_GLN("Podmiot1.Adres.AdresZagr.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdres().getAdresZagr().getGLN();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_KODKRAJU("Podmiot1.AdresKoresp.AdresPol.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getKodKraju().value();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_WOJEWODZTWO("Podmiot1.AdresKoresp.AdresPol.Wojewodztwo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getWojewodztwo();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_POWIAT("Podmiot1.AdresKoresp.AdresPol.Powiat", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getPowiat();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_GMINA("Podmiot1.AdresKoresp.AdresPol.Gmina", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getGmina();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_ULICA("Podmiot1.AdresKoresp.AdresPol.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getUlica();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_NRDOMU("Podmiot1.AdresKoresp.AdresPol.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getNrDomu();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_NRLOKALU("Podmiot1.AdresKoresp.AdresPol.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getNrLokalu();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_MIEJSCOWOSC("Podmiot1.AdresKoresp.AdresPol.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getMiejscowosc();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_KODPOCZTOWY("Podmiot1.AdresKoresp.AdresPol.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getKodPocztowy();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_POCZTA("Podmiot1.AdresKoresp.AdresPol.Poczta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getPoczta();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESPOL_GLN("Podmiot1.AdresKoresp.AdresPol.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresPol().getGLN();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_KODKRAJU("Podmiot1.AdresKoresp.AdresZagr.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getKodKraju().value();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_KODPOCZTOWY("Podmiot1.AdresKoresp.AdresZagr.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getKodPocztowy();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_MIEJSCOWOSC("Podmiot1.AdresKoresp.AdresZagr.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getMiejscowosc();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_ULICA("Podmiot1.AdresKoresp.AdresZagr.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getUlica();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_NRDOMU("Podmiot1.AdresKoresp.AdresZagr.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getNrDomu();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_NRLOKALU("Podmiot1.AdresKoresp.AdresZagr.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getNrLokalu();
        }
    }
    ,
    PODMIOT1_ADRESKORESP_ADRESZAGR_GLN("Podmiot1.AdresKoresp.AdresZagr.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot1().getAdresKoresp().getAdresZagr().getGLN();
        }
    }
    ,
    PODMIOT2_PREFIKSNABYWCY("Podmiot2.PrefiksNabywcy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getPrefiksNabywcy().value();
        }
    }
    ,
    PODMIOT2_NREORI("Podmiot2.NrEORI", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getNrEORI();
        }
    }
    ,
    PODMIOT2_EMAIL("Podmiot2.Email", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getEmail();
        }
    }
    ,
    PODMIOT2_TELEFON("Podmiot2.Telefon", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return String.join((CharSequence)",", faktura.getPodmiot2().getTelefon());
        }
    }
    ,
    PODMIOT2_NRKLIENTA("Podmiot2.NrKlienta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getNrKlienta();
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_NIP("Podmiot2.DaneIdentyfikacyjne.NIP", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getDaneIdentyfikacyjne().getNIP();
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_NRID("Podmiot2.DaneIdentyfikacyjne.NrID", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getDaneIdentyfikacyjne().getNrID();
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_BRAKID("Podmiot2.DaneIdentyfikacyjne.BrakID", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getPodmiot2().getDaneIdentyfikacyjne().getBrakID());
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_IMIEPIERWSZE("Podmiot2.DaneIdentyfikacyjne.ImiePierwsze", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getDaneIdentyfikacyjne().getImiePierwsze();
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_NAZWISKO("Podmiot2.DaneIdentyfikacyjne.Nazwisko", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getDaneIdentyfikacyjne().getNazwisko();
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_PELNANAZWA("Podmiot2.DaneIdentyfikacyjne.PelnaNazwa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getDaneIdentyfikacyjne().getPelnaNazwa();
        }
    }
    ,
    PODMIOT2_DANEIDENTYFIKACYJNE_NAZWAHANDLOWA("Podmiot2.DaneIdentyfikacyjne.NazwaHandlowa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getDaneIdentyfikacyjne().getNazwaHandlowa();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_KODKRAJU("Podmiot2.Adres.AdresPol.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getKodKraju().value();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_WOJEWODZTWO("Podmiot2.Adres.AdresPol.Wojewodztwo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getWojewodztwo();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_POWIAT("Podmiot2.Adres.AdresPol.Powiat", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getPowiat();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_GMINA("Podmiot2.Adres.AdresPol.Gmina", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getGmina();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_ULICA("Podmiot2.Adres.AdresPol.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getUlica();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_NRDOMU("Podmiot2.Adres.AdresPol.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getNrDomu();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_NRLOKALU("Podmiot2.Adres.AdresPol.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getNrLokalu();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_MIEJSCOWOSC("Podmiot2.Adres.AdresPol.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getMiejscowosc();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_KODPOCZTOWY("Podmiot2.Adres.AdresPol.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getKodPocztowy();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_POCZTA("Podmiot2.Adres.AdresPol.Poczta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getPoczta();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESPOL_GLN("Podmiot2.Adres.AdresPol.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresPol().getGLN();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_KODKRAJU("Podmiot2.Adres.AdresZagr.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getKodKraju().value();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_KODPOCZTOWY("Podmiot2.Adres.AdresZagr.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getKodPocztowy();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_MIEJSCOWOSC("Podmiot2.Adres.AdresZagr.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getMiejscowosc();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_ULICA("Podmiot2.Adres.AdresZagr.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getUlica();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_NRDOMU("Podmiot2.Adres.AdresZagr.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getNrDomu();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_NRLOKALU("Podmiot2.Adres.AdresZagr.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getNrLokalu();
        }
    }
    ,
    PODMIOT2_ADRES_ADRESZAGR_GLN("Podmiot2.Adres.AdresZagr.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdres().getAdresZagr().getGLN();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_KODKRAJU("Podmiot2.AdresKoresp.AdresPol.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getKodKraju().value();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_WOJEWODZTWO("Podmiot2.AdresKoresp.AdresPol.Wojewodztwo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getWojewodztwo();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_POWIAT("Podmiot2.AdresKoresp.AdresPol.Powiat", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getPowiat();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_GMINA("Podmiot2.AdresKoresp.AdresPol.Gmina", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getGmina();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_ULICA("Podmiot2.AdresKoresp.AdresPol.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getUlica();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_NRDOMU("Podmiot2.AdresKoresp.AdresPol.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getNrDomu();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_NRLOKALU("Podmiot2.AdresKoresp.AdresPol.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getNrLokalu();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_MIEJSCOWOSC("Podmiot2.AdresKoresp.AdresPol.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getMiejscowosc();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_KODPOCZTOWY("Podmiot2.AdresKoresp.AdresPol.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getKodPocztowy();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_POCZTA("Podmiot2.AdresKoresp.AdresPol.Poczta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getPoczta();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESPOL_GLN("Podmiot2.AdresKoresp.AdresPol.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresPol().getGLN();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_KODKRAJU("Podmiot2.AdresKoresp.AdresZagr.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getKodKraju().value();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_KODPOCZTOWY("Podmiot2.AdresKoresp.AdresZagr.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getKodPocztowy();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_MIEJSCOWOSC("Podmiot2.AdresKoresp.AdresZagr.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getMiejscowosc();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_ULICA("Podmiot2.AdresKoresp.AdresZagr.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getUlica();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_NRDOMU("Podmiot2.AdresKoresp.AdresZagr.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getNrDomu();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_NRLOKALU("Podmiot2.AdresKoresp.AdresZagr.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getNrLokalu();
        }
    }
    ,
    PODMIOT2_ADRESKORESP_ADRESZAGR_GLN("Podmiot2.AdresKoresp.AdresZagr.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiot2().getAdresKoresp().getAdresZagr().getGLN();
        }
    }
    ,
    PODMIOT3_NREORI("Podmiot3.NrEORI", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(FakturaV1.Podmiot3::getNrEORI).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_EMAIL("Podmiot3.Email", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(FakturaV1.Podmiot3::getEmail).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_TELEFON("Podmiot3.Telefon", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> String.join((CharSequence)",", ele.getTelefon())).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_NRKLIENTA("Podmiot3.NrKlienta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(FakturaV1.Podmiot3::getNrKlienta).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_NIP("Podmiot3.DaneIdentyfikacyjne.NIP", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getDaneIdentyfikacyjne().getNIP()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_NRID("Podmiot3.DaneIdentyfikacyjne.NrID", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getDaneIdentyfikacyjne().getNrID()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_BRAKID("Podmiot3.DaneIdentyfikacyjne.BrakID", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> TypeConverter.toString(ele.getDaneIdentyfikacyjne().getBrakID())).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_IMIEPIERWSZE("Podmiot3.DaneIdentyfikacyjne.ImiePierwsze", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getDaneIdentyfikacyjne().getImiePierwsze()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_NAZWISKO("Podmiot3.DaneIdentyfikacyjne.Nazwisko", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getDaneIdentyfikacyjne().getNazwisko()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_PELNANAZWA("Podmiot3.DaneIdentyfikacyjne.PelnaNazwa", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getDaneIdentyfikacyjne().getPelnaNazwa()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_DANEIDENTYFIKACYJNE_NAZWAHANDLOWA("Podmiot3.DaneIdentyfikacyjne.NazwaHandlowa", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getDaneIdentyfikacyjne().getNazwaHandlowa()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_KODKRAJU("Podmiot3.Adres.AdresPol.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_WOJEWODZTWO("Podmiot3.Adres.AdresPol.Wojewodztwo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getWojewodztwo()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_POWIAT("Podmiot3.Adres.AdresPol.Powiat", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getPowiat()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_GMINA("Podmiot3.Adres.AdresPol.Gmina", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getGmina()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_ULICA("Podmiot3.Adres.AdresPol.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getUlica()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_NRDOMU("Podmiot3.Adres.AdresPol.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_NRLOKALU("Podmiot3.Adres.AdresPol.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_MIEJSCOWOSC("Podmiot3.Adres.AdresPol.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_KODPOCZTOWY("Podmiot3.Adres.AdresPol.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_POCZTA("Podmiot3.Adres.AdresPol.Poczta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getPoczta()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESPOL_GLN("Podmiot3.Adres.AdresPol.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresPol().getGLN()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_KODKRAJU("Podmiot3.Adres.AdresZagr.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_KODPOCZTOWY("Podmiot3.Adres.AdresZagr.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_MIEJSCOWOSC("Podmiot3.Adres.AdresZagr.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_ULICA("Podmiot3.Adres.AdresZagr.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getUlica()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_NRDOMU("Podmiot3.Adres.AdresZagr.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_NRLOKALU("Podmiot3.Adres.AdresZagr.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRES_ADRESZAGR_GLN("Podmiot3.Adres.AdresZagr.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdres().getAdresZagr().getGLN()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_KODKRAJU("Podmiot3.AdresKoresp.AdresPol.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_WOJEWODZTWO("Podmiot3.AdresKoresp.AdresPol.Wojewodztwo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getWojewodztwo()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_POWIAT("Podmiot3.AdresKoresp.AdresPol.Powiat", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getPowiat()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_GMINA("Podmiot3.AdresKoresp.AdresPol.Gmina", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getGmina()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_ULICA("Podmiot3.AdresKoresp.AdresPol.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getUlica()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_NRDOMU("Podmiot3.AdresKoresp.AdresPol.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_NRLOKALU("Podmiot3.AdresKoresp.AdresPol.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_MIEJSCOWOSC("Podmiot3.AdresKoresp.AdresPol.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_KODPOCZTOWY("Podmiot3.AdresKoresp.AdresPol.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_POCZTA("Podmiot3.AdresKoresp.AdresPol.Poczta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getPoczta()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESPOL_GLN("Podmiot3.AdresKoresp.AdresPol.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresPol().getGLN()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_KODKRAJU("Podmiot3.AdresKoresp.AdresZagr.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_KODPOCZTOWY("Podmiot3.AdresKoresp.AdresZagr.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_MIEJSCOWOSC("Podmiot3.AdresKoresp.AdresZagr.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_ULICA("Podmiot3.AdresKoresp.AdresZagr.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getUlica()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_NRDOMU("Podmiot3.AdresKoresp.AdresZagr.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_NRLOKALU("Podmiot3.AdresKoresp.AdresZagr.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    PODMIOT3_ADRESKORESP_ADRESZAGR_GLN("Podmiot3.AdresKoresp.AdresZagr.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getPodmiot3().stream().map(ele -> ele.getAdresKoresp().getAdresZagr().getGLN()).toArray(String[]::new);
        }
    }
    ,
    PODMIOTUPOWAZNIONY_NREORI("PodmiotUpowazniony.NrEORI", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getNrEORI();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_EMAILPU("PodmiotUpowazniony.EmailPU", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getEmailPU();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_TELEFONPU("PodmiotUpowazniony.TelefonPU", (Type)Types.STRING){

        public String[] getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getTelefonPU().toArray(new String[0]);
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ROLAPU("PodmiotUpowazniony.RolaPU", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getPodmiotUpowazniony().getRolaPU());
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_NIP("PodmiotUpowazniony.DaneIdentyfikacyjne.NIP", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getNIP();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_NRID("PodmiotUpowazniony.DaneIdentyfikacyjne.NrID", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getNrID();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_BRAKID("PodmiotUpowazniony.DaneIdentyfikacyjne.BrakID", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getBrakID());
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_IMIEPIERWSZE("PodmiotUpowazniony.DaneIdentyfikacyjne.ImiePierwsze", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getImiePierwsze();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_NAZWISKO("PodmiotUpowazniony.DaneIdentyfikacyjne.Nazwisko", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getNazwisko();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_PELNANAZWA("PodmiotUpowazniony.DaneIdentyfikacyjne.PelnaNazwa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getPelnaNazwa();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_DANEIDENTYFIKACYJNE_NAZWAHANDLOWA("PodmiotUpowazniony.DaneIdentyfikacyjne.NazwaHandlowa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getDaneIdentyfikacyjne().getNazwaHandlowa();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_KODKRAJU("PodmiotUpowazniony.Adres.AdresPol.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getKodKraju().value();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_WOJEWODZTWO("PodmiotUpowazniony.Adres.AdresPol.Wojewodztwo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getWojewodztwo();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_POWIAT("PodmiotUpowazniony.Adres.AdresPol.Powiat", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getPowiat();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_GMINA("PodmiotUpowazniony.Adres.AdresPol.Gmina", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getGmina();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_ULICA("PodmiotUpowazniony.Adres.AdresPol.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getUlica();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_NRDOMU("PodmiotUpowazniony.Adres.AdresPol.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getNrDomu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_NRLOKALU("PodmiotUpowazniony.Adres.AdresPol.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getNrLokalu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_MIEJSCOWOSC("PodmiotUpowazniony.Adres.AdresPol.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getMiejscowosc();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_KODPOCZTOWY("PodmiotUpowazniony.Adres.AdresPol.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getKodPocztowy();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_POCZTA("PodmiotUpowazniony.Adres.AdresPol.Poczta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getPoczta();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESPOL_GLN("PodmiotUpowazniony.Adres.AdresPol.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresPol().getGLN();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_KODKRAJU("PodmiotUpowazniony.Adres.AdresZagr.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getKodKraju().value();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_KODPOCZTOWY("PodmiotUpowazniony.Adres.AdresZagr.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getKodPocztowy();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_MIEJSCOWOSC("PodmiotUpowazniony.Adres.AdresZagr.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getMiejscowosc();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_ULICA("PodmiotUpowazniony.Adres.AdresZagr.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getUlica();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_NRDOMU("PodmiotUpowazniony.Adres.AdresZagr.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getNrDomu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_NRLOKALU("PodmiotUpowazniony.Adres.AdresZagr.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getNrLokalu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRES_ADRESZAGR_GLN("PodmiotUpowazniony.Adres.AdresZagr.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdres().getAdresZagr().getGLN();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_KODKRAJU("PodmiotUpowazniony.AdresKoresp.AdresPol.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getKodKraju().value();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_WOJEWODZTWO("PodmiotUpowazniony.AdresKoresp.AdresPol.Wojewodztwo", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getWojewodztwo();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_POWIAT("PodmiotUpowazniony.AdresKoresp.AdresPol.Powiat", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getPowiat();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_GMINA("PodmiotUpowazniony.AdresKoresp.AdresPol.Gmina", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getGmina();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_ULICA("PodmiotUpowazniony.AdresKoresp.AdresPol.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getUlica();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_NRDOMU("PodmiotUpowazniony.AdresKoresp.AdresPol.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getNrDomu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_NRLOKALU("PodmiotUpowazniony.AdresKoresp.AdresPol.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getNrLokalu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_MIEJSCOWOSC("PodmiotUpowazniony.AdresKoresp.AdresPol.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getMiejscowosc();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_KODPOCZTOWY("PodmiotUpowazniony.AdresKoresp.AdresPol.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getKodPocztowy();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_POCZTA("PodmiotUpowazniony.AdresKoresp.AdresPol.Poczta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getPoczta();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESPOL_GLN("PodmiotUpowazniony.AdresKoresp.AdresPol.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresPol().getGLN();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_KODKRAJU("PodmiotUpowazniony.AdresKoresp.AdresZagr.KodKraju", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getKodKraju().value();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_KODPOCZTOWY("PodmiotUpowazniony.AdresKoresp.AdresZagr.KodPocztowy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getKodPocztowy();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_MIEJSCOWOSC("PodmiotUpowazniony.AdresKoresp.AdresZagr.Miejscowosc", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getMiejscowosc();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_ULICA("PodmiotUpowazniony.AdresKoresp.AdresZagr.Ulica", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getUlica();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_NRDOMU("PodmiotUpowazniony.AdresKoresp.AdresZagr.NrDomu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getNrDomu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_NRLOKALU("PodmiotUpowazniony.AdresKoresp.AdresZagr.NrLokalu", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getNrLokalu();
        }
    }
    ,
    PODMIOTUPOWAZNIONY_ADRESKORESP_ADRESZAGR_GLN("PodmiotUpowazniony.AdresKoresp.AdresZagr.GLN", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getPodmiotUpowazniony().getAdresKoresp().getAdresZagr().getGLN();
        }
    }
    ,
    FA_KODWALUTY("Fa.KodWaluty", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getKodWaluty().value();
        }
    }
    ,
    FA_P_1("Fa.P_1", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getFa().getP1());
        }
    }
    ,
    FA_P_1M("Fa.P_1M", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getP1M();
        }
    }
    ,
    FA_P_2("Fa.P_2", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getP2();
        }
    }
    ,
    FA_WZ("Fa.WZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return faktura.getFa().getWZ().toArray(new String[0]);
        }
    }
    ,
    FA_P_13_1("Fa.P_13_1", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP131());
        }
    }
    ,
    FA_P_13_2("Fa.P_13_2", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP132());
        }
    }
    ,
    FA_P_13_3("Fa.P_13_3", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP133());
        }
    }
    ,
    FA_P_13_4("Fa.P_13_4", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP134());
        }
    }
    ,
    FA_P_13_5("Fa.P_13_5", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP135());
        }
    }
    ,
    FA_P_13_6("Fa.P_13_6", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP136());
        }
    }
    ,
    FA_P_13_7("Fa.P_13_7", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP137());
        }
    }
    ,
    FA_P_14_1("Fa.P_14_1", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP141());
        }
    }
    ,
    FA_P_14_1W("Fa.P_14_1W", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP141W());
        }
    }
    ,
    FA_P_14_2("Fa.P_14_2", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP142());
        }
    }
    ,
    FA_P_14_2W("Fa.P_14_2W", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP142W());
        }
    }
    ,
    FA_P_14_3("Fa.P_14_3", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP143());
        }
    }
    ,
    FA_P_14_3W("Fa.P_14_3W", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP143W());
        }
    }
    ,
    FA_P_14_4("Fa.P_14_4", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP144());
        }
    }
    ,
    FA_P_14_4W("Fa.P_14_4W", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP144W());
        }
    }
    ,
    FA_P_14_5("Fa.P_14_5", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP145());
        }
    }
    ,
    FA_P_15("Fa.P_15", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getP15());
        }
    }
    ,
    FA_P_6("Fa.P_6", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getFa().getP6());
        }
    }
    ,
    FA_ZWROTAKCYZY("Fa.ZwrotAkcyzy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getZwrotAkcyzy());
        }
    }
    ,
    FA_FP("Fa.FP", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getFP());
        }
    }
    ,
    FA_TP("Fa.TP", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getTP());
        }
    }
    ,
    FA_TYPKOREKTY("Fa.TypKorekty", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getFa().getTypKorekty());
        }
    }
    ,
    FA_NRFAKORYGOWANY("Fa.NrFaKorygowany", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getNrFaKorygowany();
        }
    }
    ,
    FA_NRFAZALICZKOWEJ("Fa.NrFaZaliczkowej", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return faktura.getFa().getNrFaZaliczkowej().toArray(new String[0]);
        }
    }
    ,
    FA_OKRESFAKORYGOWANEJ("Fa.OkresFaKorygowanej", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getOkresFaKorygowanej();
        }
    }
    ,
    FA_OKRESFA_P_6_DO("Fa.OkresFa.P_6_Do", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getFa().getOkresFa().getP6Do());
        }
    }
    ,
    FA_OKRESFA_P_6_OD("Fa.OkresFa.P_6_Od", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getFa().getOkresFa().getP6Od());
        }
    }
    ,
    FA_PRZYCZYNAKOREKTY("Fa.PrzyczynaKorekty", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getPrzyczynaKorekty();
        }
    }
    ,
    FA_RODZAJFAKTURY("Fa.RodzajFaktury", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getRodzajFaktury().value();
        }
    }
    ,
    FA_ADNOTACJE_P_16("Fa.Adnotacje.P_16", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP16());
        }
    }
    ,
    FA_ADNOTACJE_P_17("Fa.Adnotacje.P_17", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP17());
        }
    }
    ,
    FA_ADNOTACJE_P_18("Fa.Adnotacje.P_18", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP18());
        }
    }
    ,
    FA_ADNOTACJE_P_18A("Fa.Adnotacje.P_18A", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP18A());
        }
    }
    ,
    FA_ADNOTACJE_P_19("Fa.Adnotacje.P_19", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP19());
        }
    }
    ,
    FA_ADNOTACJE_P_19A("Fa.Adnotacje.P_19A", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP19A();
        }
    }
    ,
    FA_ADNOTACJE_P_19B("Fa.Adnotacje.P_19B", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP19B();
        }
    }
    ,
    FA_ADNOTACJE_P_19C("Fa.Adnotacje.P_19C", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP19C();
        }
    }
    ,
    FA_ADNOTACJE_P_22("Fa.Adnotacje.P_22", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP22());
        }
    }
    ,
    FA_ADNOTACJE_P_22A("Fa.Adnotacje.P_22A", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getFa().getAdnotacje().getP22A());
        }
    }
    ,
    FA_ADNOTACJE_P_22B("Fa.Adnotacje.P_22B", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22B();
        }
    }
    ,
    FA_ADNOTACJE_P_22B1("Fa.Adnotacje.P_22B1", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22B1();
        }
    }
    ,
    FA_ADNOTACJE_P_22B2("Fa.Adnotacje.P_22B2", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22B2();
        }
    }
    ,
    FA_ADNOTACJE_P_22B3("Fa.Adnotacje.P_22B3", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22B3();
        }
    }
    ,
    FA_ADNOTACJE_P_22B4("Fa.Adnotacje.P_22B4", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22B4();
        }
    }
    ,
    FA_ADNOTACJE_P_22BK("Fa.Adnotacje.P_22BK", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22BK();
        }
    }
    ,
    FA_ADNOTACJE_P_22BMD("Fa.Adnotacje.P_22BMD", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22BMD();
        }
    }
    ,
    FA_ADNOTACJE_P_22BMK("Fa.Adnotacje.P_22BMK", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22BMK();
        }
    }
    ,
    FA_ADNOTACJE_P_22BNR("Fa.Adnotacje.P_22BNR", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22BNR();
        }
    }
    ,
    FA_ADNOTACJE_P_22BRP("Fa.Adnotacje.P_22BRP", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22BRP();
        }
    }
    ,
    FA_ADNOTACJE_P_22BT("Fa.Adnotacje.P_22BT", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22BT();
        }
    }
    ,
    FA_ADNOTACJE_P_22C("Fa.Adnotacje.P_22C", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22C();
        }
    }
    ,
    FA_ADNOTACJE_P_22C1("Fa.Adnotacje.P_22C1", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22C1();
        }
    }
    ,
    FA_ADNOTACJE_P_22D("Fa.Adnotacje.P_22D", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22D();
        }
    }
    ,
    FA_ADNOTACJE_P_22D1("Fa.Adnotacje.P_22D1", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getAdnotacje().getP22D1();
        }
    }
    ,
    FA_ADNOTACJE_P_23("Fa.Adnotacje.P_23", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getP23());
        }
    }
    ,
    FA_ADNOTACJE_P_PMARZY("Fa.Adnotacje.P_PMarzy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getPPMarzy());
        }
    }
    ,
    FA_ADNOTACJE_P_PMARZY_2("Fa.Adnotacje.P_PMarzy_2", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getPPMarzy2());
        }
    }
    ,
    FA_ADNOTACJE_P_PMARZY_3_1("Fa.Adnotacje.P_PMarzy_3_1", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getPPMarzy31());
        }
    }
    ,
    FA_ADNOTACJE_P_PMARZY_3_2("Fa.Adnotacje.P_PMarzy_3_2", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getPPMarzy32());
        }
    }
    ,
    FA_ADNOTACJE_P_PMARZY_3_3("Fa.Adnotacje.P_PMarzy_3_3", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getAdnotacje().getPPMarzy33());
        }
    }
    ,
    FA_DANEFAKORYGOWANEJ_DATAWYSTFAKORYGOWANEJ("Fa.DaneFaKorygowanej.DataWystFaKorygowanej", (Type)Types.DATE_ARRAY){

        public LocalDate[] getValue(FakturaV1 faktura) {
            return (LocalDate[])faktura.getFa().getDaneFaKorygowanej().stream().map(o -> TypeConverter.toDate(o.getDataWystFaKorygowanej())).toArray(LocalDate[]::new);
        }
    }
    ,
    FA_DANEFAKORYGOWANEJ_NRFAKORYGOWANEJ("Fa.DaneFaKorygowanej.NrFaKorygowanej", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getDaneFaKorygowanej().stream().map(FakturaV1.Fa.DaneFaKorygowanej::getNrFaKorygowanej).toArray(String[]::new);
        }
    }
    ,
    FA_DANEFAKORYGOWANEJ_NRKSEFFAKORYGOWANEJ("Fa.DaneFaKorygowanej.NrKSeFFaKorygowanej", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getDaneFaKorygowanej().stream().map(FakturaV1.Fa.DaneFaKorygowanej::getNrKSeFFaKorygowanej).toArray(String[]::new);
        }
    }
    ,
    FA_DODATKOWYOPIS_KLUCZ("Fa.DodatkowyOpis.Klucz", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getDodatkowyOpis().stream().map(TKluczWartosc::getKlucz).toArray(String[]::new);
        }
    }
    ,
    FA_DODATKOWYOPIS_WARTOSC("Fa.DodatkowyOpis.Wartosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getDodatkowyOpis().stream().map(TKluczWartosc::getWartosc).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_LICZBAWIERSZYFAKTURY("Fa.FaWiersze.LiczbaWierszyFaktury", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getFa().getFaWiersze().getLiczbaWierszyFaktury());
        }
    }
    ,
    FA_FAWIERSZE_WARTOSCWIERSZYFAKTURY1("Fa.FaWiersze.WartoscWierszyFaktury1", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getFaWiersze().getWartoscWierszyFaktury1());
        }
    }
    ,
    FA_FAWIERSZE_WARTOSCWIERSZYFAKTURY2("Fa.FaWiersze.WartoscWierszyFaktury2", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getFaWiersze().getWartoscWierszyFaktury2());
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_CN("Fa.FaWiersze.FaWiersz.CN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getCN).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_DODATKOWEINFO("Fa.FaWiersze.FaWiersz.DodatkoweInfo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getDodatkoweInfo).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_GTIN("Fa.FaWiersze.FaWiersz.GTIN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getGTIN).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_GTU("Fa.FaWiersze.FaWiersz.GTU", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(ele -> ele.getGTU().value()).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_KURSWALUTY("Fa.FaWiersze.FaWiersz.KursWaluty", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getKursWaluty())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_KWOTAAKCYZY("Fa.FaWiersze.FaWiersz.KwotaAkcyzy", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getKwotaAkcyzy())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_NRWIERSZAFA("Fa.FaWiersze.FaWiersz.NrWierszaFa", (Type)Types.INTEGER_ARRAY){

        public Integer[] getValue(FakturaV1 faktura) {
            return (Integer[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toInteger(o.getNrWierszaFa())).toArray(Integer[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_PKOB("Fa.FaWiersze.FaWiersz.PKOB", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getPKOB).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_PKWIU("Fa.FaWiersze.FaWiersz.PKWiU", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getPKWiU).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_10("Fa.FaWiersze.FaWiersz.P_10", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP10())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_11("Fa.FaWiersze.FaWiersz.P_11", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP11())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_11A("Fa.FaWiersze.FaWiersz.P_11A", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP11A())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_12("Fa.FaWiersze.FaWiersz.P_12", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP12())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_12_PROCEDURA("Fa.FaWiersze.FaWiersz.P_12_Procedura", (Type)Types.INTEGER_ARRAY){

        public Integer[] getValue(FakturaV1 faktura) {
            return (Integer[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toInteger(o.getP12Procedura())).toArray(Integer[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_12_XII("Fa.FaWiersze.FaWiersz.P_12_XII", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP12XII())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_6A("Fa.FaWiersze.FaWiersz.P_6A", (Type)Types.DATE_ARRAY){

        public LocalDate[] getValue(FakturaV1 faktura) {
            return (LocalDate[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toDate(o.getP6A())).toArray(LocalDate[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_7("Fa.FaWiersze.FaWiersz.P_7", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getP7).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_8A("Fa.FaWiersze.FaWiersz.P_8A", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getP7).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_8B("Fa.FaWiersze.FaWiersz.P_8B", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP8B())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_9A("Fa.FaWiersze.FaWiersz.P_9A", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP9A())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_P_9B("Fa.FaWiersze.FaWiersz.P_9B", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> TypeConverter.toFloat(o.getP9B())).toArray(Double[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_PROCEDURA("Fa.FaWiersze.FaWiersz.Procedura", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(o -> o.getProcedura().value()).toArray(String[]::new);
        }
    }
    ,
    FA_FAWIERSZE_FAWIERSZ_UU_ID("Fa.FaWiersze.FaWiersz.UU_ID", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getFaWiersze().getFaWiersz().stream().map(FakturaV1.Fa.FaWiersze.FaWiersz::getUUID).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_DATAZAPLATY("Fa.Platnosc.DataZaplaty", (Type)Types.DATE){

        public LocalDate getValue(FakturaV1 faktura) {
            return TypeConverter.toDate(faktura.getFa().getPlatnosc().getDataZaplaty());
        }
    }
    ,
    FA_PLATNOSC_FORMAPLATNOSCI("Fa.Platnosc.FormaPlatnosci", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getFa().getPlatnosc().getFormaPlatnosci());
        }
    }
    ,
    FA_PLATNOSC_OPISPLATNOSCI("Fa.Platnosc.OpisPlatnosci", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getPlatnosc().getOpisPlatnosci();
        }
    }
    ,
    FA_PLATNOSC_PLATNOSCINNA("Fa.Platnosc.PlatnoscInna", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getPlatnosc().getPlatnoscInna());
        }
    }
    ,
    FA_PLATNOSC_PLATNOSCICZESCIOWE_DATAZAPLATYCZESCIOWEJ("Fa.Platnosc.PlatnosciCzesciowe.DataZaplatyCzesciowej", (Type)Types.DATE_ARRAY){

        public LocalDate[] getValue(FakturaV1 faktura) {
            return (LocalDate[])faktura.getFa().getPlatnosc().getPlatnosciCzesciowe().stream().map(o -> TypeConverter.toDate(o.getDataZaplatyCzesciowej())).toArray(LocalDate[]::new);
        }
    }
    ,
    FA_PLATNOSC_PLATNOSCICZESCIOWE_KWOTAZAPLATYCZESCIOWEJ("Fa.Platnosc.PlatnosciCzesciowe.KwotaZaplatyCzesciowej", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getPlatnosc().getPlatnosciCzesciowe().stream().map(o -> TypeConverter.toFloat(o.getKwotaZaplatyCzesciowej())).toArray(Double[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWY_NAZWABANKU("Fa.Platnosc.RachunekBankowy.NazwaBanku", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowy().stream().map(TRachunekBankowy::getNazwaBanku).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWY_NRRBPL("Fa.Platnosc.RachunekBankowy.NrRBPL", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowy().stream().map(TRachunekBankowy::getNrRBPL).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWY_NRRBZAGR("Fa.Platnosc.RachunekBankowy.NrRBZagr", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowy().stream().map(TRachunekBankowy::getNrRBZagr).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWY_RACHUNEKWLASNYBANKU("Fa.Platnosc.RachunekBankowy.RachunekWlasnyBanku", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowy().stream().map(o -> TypeConverter.toString(o.getRachunekWlasnyBanku())).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWY_SWIFT("Fa.Platnosc.RachunekBankowy.SWIFT", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowy().stream().map(TRachunekBankowy::getSWIFT).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWYFAKTORA_NAZWABANKU("Fa.Platnosc.RachunekBankowyFaktora.NazwaBanku", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowyFaktora().stream().map(TRachunekBankowy::getNazwaBanku).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWYFAKTORA_NRRBPL("Fa.Platnosc.RachunekBankowyFaktora.NrRBPL", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowyFaktora().stream().map(TRachunekBankowy::getNrRBPL).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWYFAKTORA_NRRBZAGR("Fa.Platnosc.RachunekBankowyFaktora.NrRBZagr", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowyFaktora().stream().map(TRachunekBankowy::getNrRBZagr).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWYFAKTORA_RACHUNEKWLASNYBANKU("Fa.Platnosc.RachunekBankowyFaktora.RachunekWlasnyBanku", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowyFaktora().stream().map(o -> TypeConverter.toString(o.getRachunekWlasnyBanku())).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_RACHUNEKBANKOWYFAKTORA_SWIFT("Fa.Platnosc.RachunekBankowyFaktora.SWIFT", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getRachunekBankowyFaktora().stream().map(TRachunekBankowy::getSWIFT).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_SKONTO_WARUNKISKONTA("Fa.Platnosc.Skonto.WarunkiSkonta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getPlatnosc().getSkonto().getWarunkiSkonta();
        }
    }
    ,
    FA_PLATNOSC_SKONTO_WYSOKOSCSKONTA("Fa.Platnosc.Skonto.WysokoscSkonta", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getPlatnosc().getSkonto().getWysokoscSkonta();
        }
    }
    ,
    FA_PLATNOSC_TERMINYPLATNOSCI_TERMINPLATNOSCI("Fa.Platnosc.TerminyPlatnosci.TerminPlatnosci", (Type)Types.DATE_ARRAY){

        public LocalDate[] getValue(FakturaV1 faktura) {
            return (LocalDate[])faktura.getFa().getPlatnosc().getTerminyPlatnosci().stream().map(o -> TypeConverter.toDate(o.getTerminPlatnosci())).toArray(LocalDate[]::new);
        }
    }
    ,
    FA_PLATNOSC_TERMINYPLATNOSCI_TERMINPLATNOSCIOPIS("Fa.Platnosc.TerminyPlatnosci.TerminPlatnosciOpis", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getPlatnosc().getTerminyPlatnosci().stream().map(FakturaV1.Fa.Platnosc.TerminyPlatnosci::getTerminPlatnosciOpis).toArray(String[]::new);
        }
    }
    ,
    FA_PLATNOSC_ZAPLACONO("Fa.Platnosc.Zaplacono", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getPlatnosc().getZaplacono());
        }
    }
    ,
    FA_PLATNOSC_ZAPLATACZESCIOWA("Fa.Platnosc.ZaplataCzesciowa", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getPlatnosc().getZaplataCzesciowa());
        }
    }
    ,
    FA_ROZLICZENIE_DOROZLICZENIA("Fa.Rozliczenie.DoRozliczenia", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getRozliczenie().getDoRozliczenia());
        }
    }
    ,
    FA_ROZLICZENIE_DOZAPLATY("Fa.Rozliczenie.DoZaplaty", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getRozliczenie().getDoZaplaty());
        }
    }
    ,
    FA_ROZLICZENIE_SUMAOBCIAZEN("Fa.Rozliczenie.SumaObciazen", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getRozliczenie().getSumaObciazen());
        }
    }
    ,
    FA_ROZLICZENIE_SUMAODLICZEN("Fa.Rozliczenie.SumaOdliczen", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getRozliczenie().getSumaOdliczen());
        }
    }
    ,
    FA_ROZLICZENIE_OBCIAZENIA_KWOTA("Fa.Rozliczenie.Obciazenia.Kwota", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getRozliczenie().getObciazenia().stream().map(o -> TypeConverter.toFloat(o.getKwota())).toArray(Double[]::new);
        }
    }
    ,
    FA_ROZLICZENIE_OBCIAZENIA_POWOD("Fa.Rozliczenie.Obciazenia.Powod", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getRozliczenie().getOdliczenia().stream().map(FakturaV1.Fa.Rozliczenie.Odliczenia::getPowod).toArray(String[]::new);
        }
    }
    ,
    FA_ROZLICZENIE_ODLICZENIA_KWOTA("Fa.Rozliczenie.Odliczenia.Kwota", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getRozliczenie().getOdliczenia().stream().map(o -> TypeConverter.toFloat(o.getKwota())).toArray(Double[]::new);
        }
    }
    ,
    FA_ROZLICZENIE_ODLICZENIA_POWOD("Fa.Rozliczenie.Odliczenia.Powod", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getRozliczenie().getOdliczenia().stream().map(FakturaV1.Fa.Rozliczenie.Odliczenia::getPowod).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_KURSUMOWNY("Fa.WarunkiTransakcji.KursUmowny", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getWarunkiTransakcji().getKursUmowny());
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_NRPARTIITOWARU("Fa.WarunkiTransakcji.NrPartiiTowaru", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return faktura.getFa().getWarunkiTransakcji().getNrPartiiTowaru().toArray(new String[0]);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_PODMIOTPOSREDNICZACY("Fa.WarunkiTransakcji.PodmiotPosredniczacy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return TypeConverter.toString(faktura.getFa().getWarunkiTransakcji().getPodmiotPosredniczacy());
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_DATAGODZROZPTRANSPORTU("Fa.WarunkiTransakcji.Transport.DataGodzRozpTransportu", (Type)Types.DATETIME_ARRAY){

        public LocalDateTime[] getValue(FakturaV1 faktura) {
            return (LocalDateTime[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> TypeConverter.toLocalDateTime(o.getDataGodzRozpTransportu())).toArray(LocalDateTime[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_DATAGODZZAKTRANSPORTU("Fa.WarunkiTransakcji.Transport.DataGodzZakTransportu", (Type)Types.DATETIME_ARRAY){

        public LocalDateTime[] getValue(FakturaV1 faktura) {
            return (LocalDateTime[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> TypeConverter.toLocalDateTime(o.getDataGodzZakTransportu())).toArray(LocalDateTime[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_JEDNOSTKAOPAKOWANIA("Fa.WarunkiTransakcji.Transport.JednostkaOpakowania", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(FakturaV1.Fa.WarunkiTransakcji.Transport::getJednostkaOpakowania).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_LADUNEKINNY("Fa.WarunkiTransakcji.Transport.LadunekInny", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> TypeConverter.toString(o.getLadunekInny())).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_NRZLECENIATRANSPORTU("Fa.WarunkiTransakcji.Transport.NrZleceniaTransportu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(FakturaV1.Fa.WarunkiTransakcji.Transport::getNrZleceniaTransportu).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_OPISINNEGOLADUNKU("Fa.WarunkiTransakcji.Transport.OpisInnegoLadunku", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(FakturaV1.Fa.WarunkiTransakcji.Transport::getOpisInnegoLadunku).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_OPISINNEGOTRANSPORTU("Fa.WarunkiTransakcji.Transport.OpisInnegoTransportu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(FakturaV1.Fa.WarunkiTransakcji.Transport::getOpisInnegoTransportu).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_OPISLADUNKU("Fa.WarunkiTransakcji.Transport.OpisLadunku", (Type)Types.INTEGER_ARRAY){

        public Integer[] getValue(FakturaV1 faktura) {
            return (Integer[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> TypeConverter.toInteger(o.getOpisLadunku())).toArray(Integer[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_GLN("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_GMINA("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.Gmina", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_KODKRAJU("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_NRDOMU("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_NRLOKALU("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_POCZTA("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.Poczta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getPoczta()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_POWIAT("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.Powiat", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getPowiat()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_ULICA("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getUlica()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESPOL_WOJEWODZTWO("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresPol.Wojewodztwo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresPol().getWojewodztwo()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_GLN("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_KODKRAJU("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_NRDOMU("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_NRLOKALU("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_ADRESPRZEWOZNIKA_ADRESZAGR_ULICA("Fa.WarunkiTransakcji.Transport.Przewoznik.AdresPrzewoznika.AdresZagr.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(o -> o.getPrzewoznik().getAdresPrzewoznika().getAdresZagr().getUlica()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_BRAKID("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.BrakID", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> TypeConverter.toString(ele.getPrzewoznik().getDaneIdentyfikacyjne().getBrakID())).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_IMIEPIERWSZE("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.ImiePierwsze", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getPrzewoznik().getDaneIdentyfikacyjne().getImiePierwsze()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_NIP("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.NIP", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getPrzewoznik().getDaneIdentyfikacyjne().getNIP()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_NAZWAHANDLOWA("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.NazwaHandlowa", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getPrzewoznik().getDaneIdentyfikacyjne().getNazwaHandlowa()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_NAZWISKO("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.Nazwisko", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getPrzewoznik().getDaneIdentyfikacyjne().getNazwisko()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_NRID("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.NrID", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getPrzewoznik().getDaneIdentyfikacyjne().getNrID()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_PRZEWOZNIK_DANEIDENTYFIKACYJNE_PELNANAZWA("Fa.WarunkiTransakcji.Transport.Przewoznik.DaneIdentyfikacyjne.PelnaNazwa", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getPrzewoznik().getDaneIdentyfikacyjne().getPelnaNazwa()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_RODZAJTRANSPORTU("Fa.WarunkiTransakcji.Transport.RodzajTransportu", (Type)Types.INTEGER_ARRAY){

        public Integer[] getValue(FakturaV1 faktura) {
            return (Integer[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> TypeConverter.toInteger(ele.getRodzajTransportu())).toArray(Integer[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_TRANSPORTINNY("Fa.WarunkiTransakcji.Transport.TransportInny", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> TypeConverter.toString(ele.getTransportInny())).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_GLN("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_GMINA("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.Gmina", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getGmina()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_KODKRAJU("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_NRDOMU("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_NRLOKALU("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_POCZTA("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.Poczta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getPoczta()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_POWIAT("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.Powiat", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getPowiat()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_ULICA("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getUlica()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESPOL_WOJEWODZTWO("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresPol.Wojewodztwo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresPol().getWojewodztwo()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_GLN("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_KODKRAJU("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_NRDOMU("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_NRLOKALU("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKADO_ADRESZAGR_ULICA("Fa.WarunkiTransakcji.Transport.WysylkaDo.AdresZagr.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaDo().getAdresZagr().getUlica()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_GLN("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getGLN()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_GMINA("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.Gmina", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getGmina()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_KODKRAJU("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getKodKraju().value()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getKodPocztowy()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getMiejscowosc()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_NRDOMU("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getNrDomu()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_NRLOKALU("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getNrLokalu()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_POCZTA("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.Poczta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getPoczta()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_POWIAT("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.Powiat", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getPowiat()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_ULICA("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getUlica()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESPOL_WOJEWODZTWO("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresPol.Wojewodztwo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresPol().getWojewodztwo()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_GLN("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getGLN()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_KODKRAJU("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getKodKraju().value()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getKodPocztowy()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getMiejscowosc()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_NRDOMU("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getNrDomu()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_NRLOKALU("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getNrLokalu()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAPRZEZ_ADRESZAGR_ULICA("Fa.WarunkiTransakcji.Transport.WysylkaPrzez.AdresZagr.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaPrzez().stream().map(ele2 -> ele2.getAdresZagr().getUlica()).collect(Collectors.joining(","))).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_GLN("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_GMINA("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.Gmina", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getGmina()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_KODKRAJU("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_NRDOMU("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_NRLOKALU("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_POCZTA("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.Poczta", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getPoczta()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_POWIAT("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.Powiat", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getPowiat()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_ULICA("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getUlica()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESPOL_WOJEWODZTWO("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresPol.Wojewodztwo", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresPol().getWojewodztwo()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_GLN("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.GLN", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getGLN()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_KODKRAJU("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.KodKraju", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getKodKraju().value()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_KODPOCZTOWY("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.KodPocztowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getKodPocztowy()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_MIEJSCOWOSC("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.Miejscowosc", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getMiejscowosc()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_NRDOMU("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.NrDomu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getNrDomu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_NRLOKALU("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.NrLokalu", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getNrLokalu()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_TRANSPORT_WYSYLKAZ_ADRESZAGR_ULICA("Fa.WarunkiTransakcji.Transport.WysylkaZ.AdresZagr.Ulica", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getTransport().stream().map(ele -> ele.getWysylkaZ().getAdresZagr().getUlica()).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_UMOWY_DATAUMOWY("Fa.WarunkiTransakcji.Umowy.DataUmowy", (Type)Types.DATE_ARRAY){

        public LocalDate[] getValue(FakturaV1 faktura) {
            return (LocalDate[])faktura.getFa().getWarunkiTransakcji().getUmowy().stream().map(o -> TypeConverter.toDate(o.getDataUmowy())).toArray(LocalDate[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_UMOWY_NRUMOWY("Fa.WarunkiTransakcji.Umowy.NrUmowy", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getUmowy().stream().map(FakturaV1.Fa.WarunkiTransakcji.Umowy::getNrUmowy).toArray(String[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_WALUTAUMOWNA("Fa.WarunkiTransakcji.WalutaUmowna", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getWarunkiTransakcji().getWalutaUmowna().value();
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_WARUNKIDOSTAWY("Fa.WarunkiTransakcji.WarunkiDostawy", (Type)Types.STRING){

        @Override
        public String getValue(FakturaV1 faktura) {
            return faktura.getFa().getWarunkiTransakcji().getWarunkiDostawy();
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_ZAMOWIENIA_DATAZAMOWIENIA("Fa.WarunkiTransakcji.Zamowienia.DataZamowienia", (Type)Types.DATE_ARRAY){

        public LocalDate[] getValue(FakturaV1 faktura) {
            return (LocalDate[])faktura.getFa().getWarunkiTransakcji().getZamowienia().stream().map(o -> TypeConverter.toDate(o.getDataZamowienia())).toArray(LocalDate[]::new);
        }
    }
    ,
    FA_WARUNKITRANSAKCJI_ZAMOWIENIA_NRZAMOWIENIA("Fa.WarunkiTransakcji.Zamowienia.NrZamowienia", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getWarunkiTransakcji().getZamowienia().stream().map(FakturaV1.Fa.WarunkiTransakcji.Zamowienia::getNrZamowienia).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_LICZBAWIERSZYZAMOWIENIA("Fa.Zamowienie.LiczbaWierszyZamowienia", (Type)Types.INTEGER){

        @Override
        public Integer getValue(FakturaV1 faktura) {
            return TypeConverter.toInteger(faktura.getFa().getZamowienie().getLiczbaWierszyZamowienia());
        }
    }
    ,
    FA_ZAMOWIENIE_WARTOSCZAMOWIENIA("Fa.Zamowienie.WartoscZamowienia", (Type)Types.FLOAT){

        @Override
        public Double getValue(FakturaV1 faktura) {
            return TypeConverter.toFloat(faktura.getFa().getZamowienie().getWartoscZamowienia());
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_CNZ("Fa.Zamowienie.ZamowienieWiersz.CNZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getCNZ).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_DODATKOWEINFOZ("Fa.Zamowienie.ZamowienieWiersz.DodatkoweInfoZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getDodatkoweInfoZ).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_GTINZ("Fa.Zamowienie.ZamowienieWiersz.GTINZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getGTINZ).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_GTUZ("Fa.Zamowienie.ZamowienieWiersz.GTUZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> o.getGTUZ().value()).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_KURSWALUTYZ("Fa.Zamowienie.ZamowienieWiersz.KursWalutyZ", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getKursWalutyZ())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_KWOTAAKCYZYZ("Fa.Zamowienie.ZamowienieWiersz.KwotaAkcyzyZ", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getKwotaAkcyzyZ())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_NRWIERSZAZAM("Fa.Zamowienie.ZamowienieWiersz.NrWierszaZam", (Type)Types.INTEGER_ARRAY){

        public Integer[] getValue(FakturaV1 faktura) {
            return (Integer[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toInteger(o.getNrWierszaZam())).toArray(Integer[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_PKOBZ("Fa.Zamowienie.ZamowienieWiersz.PKOBZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getPKOBZ).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_PKWIUZ("Fa.Zamowienie.ZamowienieWiersz.PKWiUZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getPKWiUZ).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_11NETTOZ("Fa.Zamowienie.ZamowienieWiersz.P_11NettoZ", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getP11NettoZ())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_11VATZ("Fa.Zamowienie.ZamowienieWiersz.P_11VatZ", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getP11VatZ())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_12Z("Fa.Zamowienie.ZamowienieWiersz.P_12Z", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> o.getP12Z()).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_12Z_PROCEDURA("Fa.Zamowienie.ZamowienieWiersz.P_12Z_Procedura", (Type)Types.INTEGER_ARRAY){

        public Integer[] getValue(FakturaV1 faktura) {
            return (Integer[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toInteger(o.getP12ZProcedura())).toArray(Integer[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_12Z_XII("Fa.Zamowienie.ZamowienieWiersz.P_12Z_XII", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getP12ZXII())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_7Z("Fa.Zamowienie.ZamowienieWiersz.P_7Z", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getP7Z).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_8AZ("Fa.Zamowienie.ZamowienieWiersz.P_8AZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getP8AZ).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_8BZ("Fa.Zamowienie.ZamowienieWiersz.P_8BZ", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getP8BZ())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_P_9AZ("Fa.Zamowienie.ZamowienieWiersz.P_9AZ", (Type)Types.FLOAT_ARRAY){

        public Double[] getValue(FakturaV1 faktura) {
            return (Double[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> TypeConverter.toFloat(o.getP9AZ())).toArray(Double[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_PROCEDURAZ("Fa.Zamowienie.ZamowienieWiersz.ProceduraZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(o -> o.getProceduraZ().value()).toArray(String[]::new);
        }
    }
    ,
    FA_ZAMOWIENIE_ZAMOWIENIEWIERSZ_UU_IDZ("Fa.Zamowienie.ZamowienieWiersz.UU_IDZ", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getFa().getZamowienie().getZamowienieWiersz().stream().map(FakturaV1.Fa.Zamowienie.ZamowienieWiersz::getUUIDZ).toArray(String[]::new);
        }
    }
    ,
    STOPKA_INFORMACJE_STOPKAFAKTURY("Stopka.Informacje.StopkaFaktury", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getStopka().getInformacje().stream().map(FakturaV1.Stopka.Informacje::getStopkaFaktury).toArray(String[]::new);
        }
    }
    ,
    STOPKA_REJESTRY_BDO("Stopka.Rejestry.BDO", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getStopka().getRejestry().stream().map(FakturaV1.Stopka.Rejestry::getBDO).toArray(String[]::new);
        }
    }
    ,
    STOPKA_REJESTRY_KRS("Stopka.Rejestry.KRS", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getStopka().getRejestry().stream().map(FakturaV1.Stopka.Rejestry::getKRS).toArray(String[]::new);
        }
    }
    ,
    STOPKA_REJESTRY_PELNANAZWA("Stopka.Rejestry.PelnaNazwa", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getStopka().getRejestry().stream().map(FakturaV1.Stopka.Rejestry::getPelnaNazwa).toArray(String[]::new);
        }
    }
    ,
    STOPKA_REJESTRY_REGON("Stopka.Rejestry.REGON", (Type)Types.STRING_ARRAY){

        public String[] getValue(FakturaV1 faktura) {
            return (String[])faktura.getStopka().getRejestry().stream().map(FakturaV1.Stopka.Rejestry::getREGON).toArray(String[]::new);
        }
    };

    private final String key;
    private final Type<?> type;
    private final Translator t = Translators.get((String)"com.suncode.plugin-plus-ksef");

    private KsefKeysV1(String key, Type<?> type) {
        this.key = key;
        this.type = type;
    }

    public static Stream<KsefKeysV1> stream() {
        return Stream.of(KsefKeysV1.values());
    }

    public abstract Object getValue(FakturaV1 var1);

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Type<?> getType() {
        return this.type;
    }

    public String toString() {
        return this.key;
    }

    @Override
    public String getDesc() {
        return this.t.getMessage("plusksef.v1.autotask.LoadInvoiceInfoFromXml.context.desc." + this.key);
    }

    @Override
    public boolean isPossibleToSet() {
        return true;
    }
}

