/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.service;

import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ArchiveDocumentServiceImpl
implements ArchiveDocumentService {
    private static final String USER_LOGIN = "admin";
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentFinder documentFinder;

    @Override
    public WfDocument addNewDocumentToArchive(long documentClassId, String fileName, byte[] document, Map<Long, Object> indexes, boolean saveAsNewVersion) throws Exception {
        return this.addNewDocumentToArchive(documentClassId, fileName, document, indexes, saveAsNewVersion, false, null, null, null);
    }

    @Override
    public WfDocument addNewDocumentToArchive(String documentClassName, String fileName, byte[] document, Map<Long, Object> indexes, boolean saveAsNewVersion, boolean addDocumentToProcess, String activityId, String processId, WfFile parentFile) throws Exception {
        return this.addNewDocumentToArchive(this.getDocumentClassId(documentClassName), fileName, document, indexes, saveAsNewVersion, addDocumentToProcess, activityId, processId, parentFile);
    }

    @Override
    public WfDocument addNewDocumentToArchive(long documentClassId, String fileName, byte[] document, Map<Long, Object> indexes, boolean saveAsNewVersion, boolean addDocumentToProcess, String activityId, String processId, WfFile parentFile) throws Exception {
        DocumentDefinition documentDefinition = new DocumentDefinition();
        documentDefinition.setDocumentClassId(Long.valueOf(documentClassId));
        documentDefinition.setFileName(fileName);
        documentDefinition.setUserName(USER_LOGIN);
        documentDefinition.setInputStream((InputStream)new ByteArrayInputStream(document));
        documentDefinition.setSaveAsNewVersion(saveAsNewVersion);
        if (addDocumentToProcess) {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)processId), (String)"The document cannot be added to the process - ProcessId is empty.");
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)activityId), (String)"The document cannot be added to the process - ActivityId is empty.");
            documentDefinition.setProcessId(processId);
            documentDefinition.setActivityId(activityId);
        }
        if (indexes != null) {
            documentDefinition.setIndexes(indexes);
        }
        if (saveAsNewVersion && parentFile != null) {
            documentDefinition.setFileName(parentFile.getFileName());
            documentDefinition.setDescription(parentFile.getDescription());
            documentDefinition.setUserName(parentFile.getUploader());
            Long originalDocumentFileId = parentFile.getId();
            String currentDocState = this.fileService.getVersionForFile(originalDocumentFileId).getState();
            if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
                this.fileService.cancelCheckOut(originalDocumentFileId);
            }
            this.fileService.checkOut(originalDocumentFileId, UserContext.current().getUser().getUserName());
            Long newFileId = this.fileService.checkIn(documentDefinition, originalDocumentFileId, "");
            return this.documentFinder.findByFileId(newFileId, Long.valueOf(documentClassId));
        }
        return this.documentService.addDocument(documentDefinition);
    }

    private Long getDocumentClassId(String documentClassName) {
        return Objects.requireNonNull(this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId(), "Document class does not exist: " + documentClassName);
    }
}

