/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.controller;

import com.suncode.plugin.plusksef.document.dto.DocClassInfo;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.CountedResult;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Transactional
@Controller
@RequestMapping(value={"/documents"})
public class DocumentController {
    @Autowired
    private DocumentClassService documentClassService;
    @Autowired
    KsefDocumentService converterService;
    @Autowired
    DocumentService documentService;
    private static final String APPLICATION_PDF_VALUE = "application/pdf";

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocClassInfo> getDocumentClassList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List documentClassList = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((String)documentClass.getName(), (String)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        result.setTotal((long)documentClassList.size());
        if (documentClassList.size() >= start) {
            List docClassInfoList = documentClassList.stream().map(DocClassInfo::new).collect(Collectors.toList());
            result.setData(docClassInfoList.subList(start, Integer.min(start + limit, documentClassList.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"get/html/{ksefFileId}"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void generateKsefHtml(@PathVariable Long ksefFileId, HttpServletResponse response) {
        WfFile file = this.documentService.getDocument(ksefFileId).getFile();
        String htmlDocument = this.converterService.generateHtmlDocumentFromKsefXml(file, false, true);
        String fileName = URLEncoder.encode(this.changeExtensionInFilename(file.getFileName(), "html"), StandardCharsets.UTF_8.toString());
        response.addHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType("text/html");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(htmlDocument.getBytes(StandardCharsets.UTF_8));
        }
        response.flushBuffer();
    }

    @ResponseBody
    @RequestMapping(value={"get/pdf/{ksefFileId}"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void generateKsefPdf(@PathVariable Long ksefFileId, HttpServletResponse response) {
        WfFile file = this.documentService.getDocument(ksefFileId).getFile();
        String inputHTML = this.converterService.generateHtmlDocumentFromKsefXml(file, false, true);
        byte[] bytes = this.converterService.generatePdfDocumentFromHtml(inputHTML).toByteArray();
        String fileName = URLEncoder.encode(this.changeExtensionInFilename(file.getFileName(), "pdf"), StandardCharsets.UTF_8.toString());
        response.addHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType(APPLICATION_PDF_VALUE);
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(bytes);
        }
        response.flushBuffer();
    }

    @ResponseBody
    @RequestMapping(value={"get/xml/{ksefFileId}"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    public void getRawKsefXml(@PathVariable Long ksefFileId, HttpServletResponse response) {
        WfFile file = this.documentService.getDocument(ksefFileId).getFile();
        byte[] bytes = Files.readAllBytes(Paths.get(file.getFullPath(), new String[0]));
        String fileName = URLEncoder.encode(file.getFileName(), StandardCharsets.UTF_8.toString());
        response.addHeader("Content-disposition", "attachment;filename=" + fileName);
        response.setContentType("application/xml");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(bytes);
        }
        response.flushBuffer();
    }

    private String changeExtensionInFilename(String fileName, String newExtension) {
        return FilenameUtils.removeExtension((String)fileName) + "." + newExtension;
    }
}

