/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.db.servicie;

import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.db.dao.ExportedDocumentTableDao;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.servicie.ExportedDocumentTableService;
import com.suncode.pwfl.support.hibernate.criterion.HibernateCriteria;
import com.suncode.pwfl.support.hibernate.criterion.Restrictions;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ExportedDocumentTableServiceImpl
extends EditableServiceImpl<ExportedDocumentTableEntity, Long, ExportedDocumentTableDao>
implements ExportedDocumentTableService {
    private static final Logger log = LoggerFactory.getLogger(ExportedDocumentTableServiceImpl.class);

    @Autowired
    public void setDao(ExportedDocumentTableDao dao) {
        this.dao = dao;
    }

    @Override
    public void addInfo(KsefImportConfig ksefImportConfig, long fileId, String exportReferenceNumber, String sessionReferenceNumber, String activityId, String sessionToken) {
        ((ExportedDocumentTableDao)this.dao).save(this.createEntity(fileId, ksefImportConfig.getNip(), ksefImportConfig.getConfigId(), ksefImportConfig.getKsefSystemType(), exportReferenceNumber, sessionReferenceNumber, activityId, sessionToken));
    }

    private ExportedDocumentTableEntity createEntity(long fileId, String nip, String configId, String ksefSystemType, String exportReferenceNumber, String sessionReferenceNumber, String activityId, String sessionToken) {
        return ExportedDocumentTableEntity.builder().exportTime(Timestamp.from(Instant.now())).fileId(fileId).nip(nip).configId(configId).systemType(ksefSystemType).exportReferenceNumber(exportReferenceNumber).sessionReferenceNumber(sessionReferenceNumber).status("Exported. Waiting for KSeF status.").activityId(activityId).sessionToken(sessionToken).build();
    }

    @Override
    public ExportedDocumentTableEntity getRowByExportReferenceNumber(String exportReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"exportReferenceNumber", (Object)exportReferenceNumber));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect exportReferenceNumber. Record not found in DB: " + exportReferenceNumber);
    }

    @Override
    public List<ExportedDocumentTableEntity> getRowBySessionReferenceNumber(String sessionReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"sessionReferenceNumber", (Object)sessionReferenceNumber));
        return ((ExportedDocumentTableDao)this.dao).findByCriteria(exportedDocument);
    }

    @Override
    public ExportedDocumentTableEntity getRowByKsefReferenceNumber(String ksefReferenceNumber) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"ksefReferenceNumber", (Object)ksefReferenceNumber));
        return this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)exportedDocument, "Incorrect ksefReferenceNumber. Record not found in DB: " + ksefReferenceNumber);
    }

    @Override
    public void updateRecord(String exportReferenceNumber, String status) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"exportReferenceNumber", (Object)exportReferenceNumber));
        ExportedDocumentTableEntity firstRowByCriteria = this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)criteria, "Incorrect exportReferenceNumber. Not found in DB: " + exportReferenceNumber);
        firstRowByCriteria.setStatus(status);
    }

    @Override
    public void updateRecord(String exportReferenceNumber, String status, String ksefReferenceNumber) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"exportReferenceNumber", (Object)exportReferenceNumber));
        ExportedDocumentTableEntity firstRowByCriteria = this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)criteria, "Incorrect exportReferenceNumber. Not found in DB: " + exportReferenceNumber);
        firstRowByCriteria.setStatus(status);
        firstRowByCriteria.setKsefReferenceNumber(ksefReferenceNumber);
    }

    @Override
    public void updateRecord(String exportReferenceNumber, String status, String ksefReferenceNumber, String invoicingHash, OffsetDateTime invoicingDate, String upoDownloadUrl, String invoicingMode) {
        HibernateCriteria criteria = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"exportReferenceNumber", (Object)exportReferenceNumber));
        ExportedDocumentTableEntity firstRowByCriteria = this.getFirstRowByCriteria((HibernateCriteria<ExportedDocumentTableEntity>)criteria, "Incorrect exportReferenceNumber. Not found in DB: " + exportReferenceNumber);
        firstRowByCriteria.setStatus(status);
        firstRowByCriteria.setKsefReferenceNumber(ksefReferenceNumber);
        firstRowByCriteria.setInvoicingHash(invoicingHash);
        firstRowByCriteria.setInvoicingDate(invoicingDate);
        firstRowByCriteria.setUpoDownloadUrl(upoDownloadUrl);
        firstRowByCriteria.setInvoicingMode(invoicingMode);
    }

    @Override
    public Optional<ExportedDocumentTableEntity> getEntity(Long fileId) {
        HibernateCriteria exportedDocument = HibernateCriteria.forClass(ExportedDocumentTableEntity.class).add(Restrictions.eq((String)"fileId", (Object)fileId));
        return ((ExportedDocumentTableDao)this.dao).findByCriteria(exportedDocument).stream().findFirst();
    }

    private ExportedDocumentTableEntity getFirstRowByCriteria(HibernateCriteria<ExportedDocumentTableEntity> detachedCriteria, String exceptionMessage) {
        List byCriteria = ((ExportedDocumentTableDao)this.dao).findByCriteria(detachedCriteria);
        return (ExportedDocumentTableEntity)byCriteria.stream().findFirst().orElseThrow(() -> new IllegalArgumentException(exceptionMessage));
    }
}

