/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.configuration.service;

import com.google.gson.Gson;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.enums.KsefV1SystemType;
import com.suncode.plugin.plusksef.api.v2.enums.KsefV2SystemType;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    private final Gson gson = new Gson();
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    @Override
    public KsefImportConfig readConfigurationFromPCM(String configId) throws IOException {
        KsefImportConfig ksefImportConfig;
        block8: {
            Assert.isTrue((boolean)this.configExist(configId), (String)String.format("Config \"%s\" does not exist", configId));
            InputStream stream = this.configurationFileService.readFile(this.plugin.getKey(), configId);
            try {
                String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                KsefImportConfig ksefImportConfig2 = (KsefImportConfig)this.gson.fromJson(content, KsefImportConfig.class);
                ksefImportConfig2.setConfigId(configId);
                String ksefUrl = ksefImportConfig2.getApiVersion() == KsefApiVersion.V1 ? KsefV1SystemType.valueOf(ksefImportConfig2.getKsefSystemType()).getUrl() : KsefV2SystemType.valueOf(ksefImportConfig2.getKsefSystemType()).getUrl();
                ksefImportConfig2.setKsefUrl(ksefUrl);
                ksefImportConfig = ksefImportConfig2;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            stream.close();
        }
        return ksefImportConfig;
    }

    private boolean configExist(String configId) {
        return this.configurationFileService.doesFileExist(this.plugin.getKey(), configId);
    }
}

