/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.configuration.controller;

import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.pluginconfigurationmanager.configuration.definition.file.service.ConfigurationFileService;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.enums.KsefV1SystemType;
import com.suncode.plugin.plusksef.api.v2.enums.KsefV2AuthenticationMethod;
import com.suncode.plugin.plusksef.configuration.enums.MappingsForIndexesEnum;
import com.suncode.pwfl.search.CountedResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="KsefConfigurationController")
@RequestMapping(value={"/config"})
public class ConfigurationController {
    @Autowired
    private ConfigurationFileService configurationFileService;
    @Autowired
    private Plugin plugin;

    @RequestMapping(value={"mappingParams"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getConfigurationFileList() {
        return MappingsForIndexesEnum.stream().collect(Collectors.toMap(MappingsForIndexesEnum::toString, MappingsForIndexesEnum::getTranslation, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @RequestMapping(value={"systemTypes"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getKsefSystemTypes() {
        return KsefV1SystemType.stream().collect(Collectors.toMap(Enum::toString, KsefV1SystemType::getTranslation, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @RequestMapping(value={"apiVersions"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getApiVersions() {
        return Arrays.stream(KsefApiVersion.values()).collect(Collectors.toMap(KsefApiVersion::getVersion, KsefApiVersion::getDescription, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @RequestMapping(value={"apiV2authenticationMethods"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getApiV2AuthenticationMethods() {
        return KsefV2AuthenticationMethod.stream().collect(Collectors.toMap(Enum::name, KsefV2AuthenticationMethod::getTranslation, (e1, e2) -> e1, LinkedHashMap::new));
    }

    @RequestMapping(value={"configurationIds"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getConfigurationIds() {
        List configList = Arrays.stream(this.configurationFileService.getAllReadableFilesIds(this.plugin.getKey())).map(configId -> Collections.singletonMap("configId", configId)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        result.setData(configList);
        result.setTotal((long)configList.size());
        return result;
    }
}

