/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.autotask.SchemaResourceResolver;
import com.suncode.plugin.plusksef.invoice.service.InvoiceService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@Application
public class ValidateXmlWithXsd {
    private static final Logger log = LoggerFactory.getLogger(ValidateXmlWithXsd.class);
    private static final String ID = "plusksef.autotask.ValidateXmlWithXsd";
    private static final int MAX_ERROR_MESSAGE_LENGTH = 4000;
    private static final String SCHEMA_PATH_V2 = "/xsd/v2/schemat_v2.xsd";
    private static final String SCHEMA_PATH_V3 = "/xsd/v3/schemat_v3_simplified.xsd";
    @Autowired
    private FileService fileService;
    @Autowired
    private InvoiceService invoiceService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.XML)).parameter().id("xmlFileId").name(ID.concat(".param.xmlFileId.name")).description(ID.concat(".param.xmlFileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("validationResult").name(ID.concat(".param.validationResult.name")).description(ID.concat(".param.validationResult.desc")).type((Type)Types.VARIABLE).create()).parameter().id("errorDetails").name(ID.concat(".param.errorDetails.name")).description(ID.concat(".param.errorDetails.desc")).type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param Long xmlFileId, @Param Variable validationResult, @Param Variable errorDetails) throws AcceptanceException {
        try {
            log.debug("Starting XML validation with automatic schema detection");
            String xmlContent = this.loadXmlFileContent(xmlFileId);
            String xsdSchemaName = this.detectSchemaVersion(xmlContent);
            Schema schema = this.loadSchema(xsdSchemaName);
            ValidationResult result = this.validateXmlAgainstXsd(xmlContent, schema);
            if (validationResult != null) {
                Object statusValue = validationResult.getType().convert(String.valueOf(result.isValid()));
                validationResult.setValue(statusValue);
            }
            if (errorDetails != null) {
                List<String> errorMessages = result.getErrorMessages();
                if (errorDetails.isArray()) {
                    errorDetails.setValue((Object)(errorMessages != null ? errorMessages.toArray(new String[0]) : new String[]{}));
                } else {
                    Object joinedErrors;
                    Object object = joinedErrors = errorMessages != null ? String.join((CharSequence)"\n\n", errorMessages) : "";
                    if (((String)joinedErrors).length() > 4000) {
                        joinedErrors = ((String)joinedErrors).substring(0, 3997) + "...";
                    }
                    errorDetails.setValue(joinedErrors);
                }
            }
            log.info("XML validation completed result: {}, status: {}", (Object)result.isValid(), result.getErrorMessages());
        }
        catch (Exception e) {
            throw new AcceptanceException("XML validation error: " + e.getMessage(), (Throwable)e);
        }
    }

    private String detectSchemaVersion(String xmlContent) {
        if (this.invoiceService.isKsefSchematV3(xmlContent)) {
            return SCHEMA_PATH_V3;
        }
        if (this.invoiceService.isKsefSchematV2(xmlContent)) {
            return SCHEMA_PATH_V2;
        }
        if (this.invoiceService.isKsefSchematV1(xmlContent)) {
            throw new IllegalArgumentException("Schema version 1 is not supported");
        }
        throw new IllegalArgumentException("Unable to detect KSeF schema version from XML content");
    }

    private void configureXmlProperties() {
        System.setProperty("jdk.xml.maxElementDepth", "200000");
        System.setProperty("jdk.xml.maxGeneralEntitySizeLimit", "0");
        System.setProperty("jdk.xml.maxParameterEntitySizeLimit", "0");
        System.setProperty("jdk.xml.maxTotalEntitySizeLimit", "0");
        System.setProperty("jdk.xml.maxXMLNameLimit", "200000");
        System.setProperty("jdk.xml.maxOccurLimit", "200000");
        System.setProperty("jdk.xml.maxElementCount", "2000000");
        System.setProperty("jdk.xml.maxAttributeCount", "50000");
        System.setProperty("jdk.xml.maxAttributeSize", "1000000");
        System.setProperty("jdk.xml.maxTextLength", "10000000");
        System.setProperty("jdk.xml.maxCharacterSizeLimit", "10000000");
        System.setProperty("javax.xml.accessExternalSchema", "file,jar,classpath");
        System.setProperty("javax.xml.accessExternalDTD", "file,jar,classpath");
    }

    private SchemaFactory createSchemaFactory() throws SAXException {
        SchemaFactory factory;
        try {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", ValidateXmlWithXsd.class.getClassLoader());
        }
        catch (Exception e) {
            factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        }
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        try {
            factory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema/element-default", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema/identity-constraint-checking", false);
            factory.setFeature("http://apache.org/xml/features/validation/schema/use-grammar-pool-only", true);
            factory.setFeature("http://apache.org/xml/features/validation/schema/ignore-annotations", true);
        }
        catch (SAXException e) {
            log.warn("Some validation features not supported: {}", (Object)e.getMessage());
        }
        return factory;
    }

    private Schema loadSchema(String schemaPath) throws SAXException, IOException {
        this.configureXmlProperties();
        SchemaFactory factory = this.createSchemaFactory();
        factory.setResourceResolver(new SchemaResourceResolver(schemaPath));
        try (InputStream schemaStream = this.getClass().getResourceAsStream(schemaPath);){
            if (schemaStream == null) {
                throw new IOException("Schema file not found: " + schemaPath);
            }
            StreamSource schemaSource = new StreamSource(schemaStream);
            String schemaName = Paths.get(schemaPath, new String[0]).getFileName().toString();
            schemaSource.setSystemId(schemaName);
            Schema schema = factory.newSchema(schemaSource);
            log.debug("Successfully loaded schema: {}", (Object)schemaPath);
            Schema schema2 = schema;
            return schema2;
        }
    }

    private String loadXmlFileContent(Long fileId) throws IOException {
        WfFile wfFile = this.fileService.getFile(fileId, new String[0]);
        if (wfFile == null) {
            throw new IOException("File not found with ID: " + fileId);
        }
        return new String(Files.readAllBytes(Paths.get(wfFile.getFullPath(), new String[0])), StandardCharsets.UTF_8);
    }

    private ValidationResult validateXmlAgainstXsd(String xmlContent, Schema schema) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(xmlContent.getBytes(StandardCharsets.UTF_8)));
            Validator validator = schema.newValidator();
            ValidationErrorHandler errorHandler = new ValidationErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(new DOMSource(document));
            if (errorHandler.hasErrors()) {
                return new ValidationResult(false, errorHandler.getErrors());
            }
            return new ValidationResult(true, (String)null);
        }
        catch (SAXException e) {
            String message = e.getMessage() != null ? e.getMessage() : "Unknown SAX error";
            log.error("SAX validation error", (Throwable)e);
            return new ValidationResult(false, "Validation error: " + message);
        }
        catch (Exception e) {
            String message = e.getMessage() != null ? e.getMessage() : "Unknown validation error";
            log.error("Validation error", (Throwable)e);
            return new ValidationResult(false, "Validation error: " + message);
        }
    }

    private static class ValidationResult {
        private final boolean valid;
        private final List<String> errorMessages;

        public ValidationResult(boolean valid, List<String> errors) {
            this.valid = valid;
            this.errorMessages = errors != null && !errors.isEmpty() ? new ArrayList<String>(errors) : null;
        }

        public ValidationResult(boolean valid, String errorMessage) {
            this.valid = valid;
            this.errorMessages = errorMessage != null ? Collections.singletonList(errorMessage) : null;
        }

        public boolean isValid() {
            return this.valid;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }

    private static class ValidationErrorHandler
    implements ErrorHandler {
        private final List<String> errors = new ArrayList<String>();

        private ValidationErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.errors.add(this.formatError("Warning", exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.errors.add(this.formatError("Error", exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.errors.add(this.formatError("Fatal error", exception));
        }

        private String formatError(String type, SAXParseException exception) {
            return String.format("%s at line %d, column %d: %s", type, exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage());
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public List<String> getErrors() {
            return new ArrayList<String>(this.errors);
        }
    }
}

