/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.v1.model.payment.GetPaymentIdentifierReferenceNumbersResponse;
import com.suncode.plugin.plusksef.api.v1.model.payment.KsefReferenceNumberListResponseObject;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.PaymentService;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/GetInvoicesForPaymentIdentifier/pwe_dynamic_form.js")
public class GetInvoicesForPaymentIdentifier {
    private static final Logger log = LoggerFactory.getLogger(GetInvoicesForPaymentIdentifier.class);
    private static final String ID = "plusksef.autotask.GetInvoicesForPaymentIdentifier";
    @Autowired
    private PaymentService paymentService;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KSeFServiceApiV1 ksEFService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.DOCUMENT)).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("paymentIdentifier").name(ID.concat(".param.paymentIdentifier.name")).description(ID.concat(".param.paymentIdentifier.desc")).type((Type)Types.STRING).create()).parameter().id("pageSize").name(ID.concat(".param.pageSize.name")).description(ID.concat(".param.pageSize.desc")).type((Type)Types.INTEGER).optional().defaultValue((Object)100).create()).parameter().id("pageOffset").name(ID.concat(".param.pageOffset.name")).description(ID.concat(".param.pageOffset.desc")).type((Type)Types.INTEGER).optional().defaultValue((Object)0).create()).parameter().id("invoicesList").name(ID.concat(".param.invoicesList.name")).description(ID.concat(".param.invoicesList.desc")).type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param String configId, @Param String paymentIdentifier, @Param Integer pageSize, @Param Integer pageOffset, @Param Variable invoicesList) throws AcceptanceException {
        try {
            log.info("Getting invoices for payment identifier: {} from config: {}", (Object)paymentIdentifier, (Object)configId);
            Assert.isTrue((configId != null && !configId.trim().isEmpty() ? 1 : 0) != 0, (String)"Configuration ID is required");
            Assert.isTrue((paymentIdentifier != null && !paymentIdentifier.trim().isEmpty() ? 1 : 0) != 0, (String)"Payment identifier is required");
            Assert.isTrue((invoicesList != null ? 1 : 0) != 0, (String)"Invoices list variable is required");
            int pageSizeValue = pageSize != null ? pageSize : 100;
            int pageOffsetValue = pageOffset != null ? pageOffset : 0;
            Assert.isTrue((pageSizeValue >= 10 && pageSizeValue <= 100 ? 1 : 0) != 0, (String)"Page size must be between 10 and 100");
            log.info("Retrieving invoices for payment identifier: {} with page size: {}, offset: {}", new Object[]{paymentIdentifier, pageSizeValue, pageOffsetValue});
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
            SessionInfo sessionInfo = this.ksEFService.getSession(ksefImportConfig);
            GetPaymentIdentifierReferenceNumbersResponse response = this.paymentService.getInvoicesForPaymentIdentifier(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), paymentIdentifier, pageSizeValue, pageOffsetValue);
            List<KsefReferenceNumberListResponseObject> invoices = response.getKsefReferenceNumberList();
            long totalElements = response.getNumberOfElements();
            log.info("Retrieved {} invoices for payment identifier: {} (total: {})", new Object[]{invoices.size(), paymentIdentifier, totalElements});
            String[] ksefReferenceNumbers = (String[])invoices.stream().map(KsefReferenceNumberListResponseObject::getKsefReferenceNumber).toArray(String[]::new);
            invoicesList.setValue((Object)ksefReferenceNumbers);
        }
        catch (Exception e) {
            log.error("Error getting invoices for payment identifier: {} from config: {}", new Object[]{paymentIdentifier, configId, e});
            throw new AcceptanceException("Error retrieving invoices: " + e.getMessage());
        }
    }
}

