﻿window.vfgFileSchema = {
    fields: [
        {
            type: "select",
            inputType: "text",
            label: "plusksef.pcm.schema.params.apiVersion.name",
            help: "plusksef.pcm.schema.params.apiVersion.desc",
            model: "apiVersion",
            required: true,
            values: function () {
                let data;
                jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-plus-ksef/config/apiVersions', success: function (result) {
                            data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                        },
                        async: false
                    }
                );
                return data
            }
        },
        {
            type: "select",
            inputType: "text",
            label: "plusksef.pcm.schema.params.url.name",
            help: "plusksef.pcm.schema.params.url.desc",
            model: "ksefSystemType",
            required: true,
            values: function () {
                let data;
                jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-plus-ksef/config/systemTypes', success: function (result) {
                            data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                        },
                        async: false
                    }
                );
                return data
            }
        },
        {
            type: "select",
            inputType: "text",
            label: "plusksef.pcm.schema.params.apiV2authenticationMethods.name",
            help: "plusksef.pcm.schema.params.apiV2authenticationMethods.desc",
            model: "apiV2authenticationMethods",
            required: false,
            visible: function (model) {
                return model && model.apiVersion !== "v1";
            },
            values: function () {
                let data;
                jQuery.ajax({
                        url: 'plugin/com.suncode.plugin-plus-ksef/config/apiV2authenticationMethods', success: function (result) {
                            data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                        },
                        async: false
                    }
                );
                return data
            }
        },
        {
            type: "input",
            inputType: "password",
            label: "plusksef.pcm.schema.params.apiV2Token.name",
            help: "plusksef.pcm.schema.params.apiV2Token.desc",
            model: "apiV2Token",
            required: false,
            visible: function (model) {
                return model && model.apiVersion !== "v1" && model.apiV2authenticationMethods === "KSEF_TOKEN";
            },
            validator: "string"
        },
        {
            type: "textArea",
            label: "plusksef.pcm.schema.params.apiV2CertificatePEM.name",
            hint: "plusksef.pcm.schema.params.apiV2CertificatePEM.desc",
            model: "apiV2CertificatePEM",
            required: false,
            visible: function (model) {
                return model && model.apiVersion !== "v1" && model.apiV2authenticationMethods === "QUALIFIED_SIGNATURE";
            },
            rows: 4,
            max: 5000,
            validator: "string"
        },
        {
            type: "textArea",
            label: "plusksef.pcm.schema.params.apiV2PrivateKeyPEM.name",
            hint: "plusksef.pcm.schema.params.apiV2PrivateKeyPEM.desc",
            model: "apiV2PrivateKeyPEM",
            required: false,
            visible: function (model) {
                return model && model.apiVersion !== "v1" && model.apiV2authenticationMethods === "QUALIFIED_SIGNATURE";
            },
            rows: 4,
            max: 5000,
            validator: "string"
        },
        {
            type: "input",
            inputType: "text",
            label: "plusksef.pcm.schema.params.apiV2OfflineCertificateSerialNumber.name",
            help: "plusksef.pcm.schema.params.apiV2OfflineCertificateSerialNumber.desc",
            model: "apiV2OfflineCertificateSerialNumber",
            required: false,
            visible: function (model) {
                return model && model.apiVersion !== "v1";
            },
            min: 10,
            validator: "string"
        },
        {
            type: "textArea",
            label: "plusksef.pcm.schema.params.apiV2OfflinePrivateKeyPEM.name",
            hint: "plusksef.pcm.schema.params.apiV2OfflinePrivateKeyPEM.desc",
            model: "apiV2OfflinePrivateKeyPEM",
            required: false,
            visible: function (model) {
                return model && model.apiVersion !== "v1";
            },
            rows: 4,
            max: 5000,
            validator: "string"
        },
        {
            type: "input",
            inputType: "text",
            label: "plusksef.pcm.schema.params.nip.name",
            help: "plusksef.pcm.schema.params.nip.desc",
            model: "nip",
            required: true,
            min: 10,
            validator: "string"
        },
        {
            type: "input",
            inputType: "password",
            label: "plusksef.pcm.schema.params.token.name",
            help: "plusksef.pcm.schema.params.token.desc",
            model: "tokenAuth",
            required: true,
            visible: function (model) {
                return model && model.apiVersion !== "v2";
            },
            validator: "string"
        },
        {
            type: "select",
            inputType: "text",
            label: "plusksef.pcm.schema.params.documentClassName.name",
            model: "documentClassId",
            required: "true",
            values: function (model) {
                let data;
                window.vfgFileSchemaHeaderModel = model;
                jQuery.ajax({
                    url: 'api/documents/classes', success: function (result) {
                        data = result.map(row => ({id: row.id, name: row.name}))
                            .sort((a, b) => a.name.localeCompare(b.name));
                    },
                    async: false
                });
                return data
            },
            validator: "integer",
            placeholder: "plusksef.pcm.schema.params.documentClassName.placeholder"
        },
        {
            type: "field-array",
            model: "mappings",
            schema: {
                fields: [
                    {
                        type: "select",
                        inputType: "text",
                        label: "plusksef.pcm.schema.params.ksefParam.name",
                        model: "ksefParam",
                        values: function () {
                            let data;
                            let apiVersion = window.vfgFileSchemaHeaderModel && window.vfgFileSchemaHeaderModel.apiVersion ? window.vfgFileSchemaHeaderModel.apiVersion : '';
                            let url = 'plugin/com.suncode.plugin-plus-ksef/config/mappingParams?apiVersion=' + encodeURIComponent(apiVersion);

                            jQuery.ajax({
                                    url: url, success: function (result) {
                                        data = Object.entries(result).map(row => ({id: row[0], name: row[1]}))
                                            .sort((a, b) => a.name.localeCompare(b.name));
                                    },
                                    async: false
                                }
                            );
                            return data
                        },
                    },
                    {
                        type: "select",
                        inputType: "text",
                        label: "plusksef.pcm.schema.params.docClassIndex.name",
                        model: "docClassIndex",
                        required: "true",
                        values: function () {
                            let data;
                            jQuery.ajax({
                                    url: 'api/documents/indexes/' + window.vfgFileSchemaHeaderModel.documentClassId,
                                    success: function (result) {
                                        data = result.map(row => ({id: row.id, name: row.name}))
                                            .sort((a, b) => a.name.localeCompare(b.name));
                                    },
                                    async: false
                                }
                            );
                            return data
                        },
                        validator: "integer"
                    }
                ]
            }
        }
    ]
}