/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask.utils;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.enums.MappingsForIndexesApiV2Enum;
import com.suncode.plugin.plusksef.db.service.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceMetadata;

public final class ImportDocumentsFromKSeFUtils {
    public static final String XML_EXTENSION = ".xml";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public static boolean loadDocumentToArchive(KsefImportConfig config, InvoiceMetadata invoiceData, byte[] invoiceXml, ImportedDocumentTableService importedDocumentTableService, ArchiveDocumentService archiveDocumentService, DocumentClassActionService documentClassActionService) throws Exception {
        if (importedDocumentTableService.isDocumentImported(invoiceData.getKsefNumber())) {
            return false;
        }
        Map<Long, Object> indexes = ImportDocumentsFromKSeFUtils.createIndexesMap(invoiceData, config);
        WfDocument wfDocument = archiveDocumentService.addNewDocumentToArchive(config.getDocumentClassId(), invoiceData.getKsefNumber() + XML_EXTENSION, invoiceXml, indexes, true);
        documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        Timestamp invoicingDate = invoiceData.getInvoicingDate() != null ? Timestamp.from(invoiceData.getInvoicingDate().toInstant()) : null;
        String nip = invoiceData.getSeller() != null ? invoiceData.getSeller().getNip() : config.getNip();
        String invoicingMode = invoiceData.getInvoicingMode() != null ? invoiceData.getInvoicingMode().name() : null;
        importedDocumentTableService.addInfo(nip, config.getConfigId(), config.getKsefSystemType(), invoiceData.getKsefNumber(), wfDocument.getFile().getId(), invoiceData.getInvoiceHash(), invoicingDate, invoicingMode);
        return true;
    }

    private static Map<Long, Object> createIndexesMap(InvoiceMetadata invoiceHeader, KsefImportConfig config) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        config.getMappings().forEach(mapping -> indexes.put(mapping.getDocClassIndex(), ImportDocumentsFromKSeFUtils.getIndexValue(mapping.getKsefParam(), invoiceHeader, config)));
        indexes.values().removeIf(Objects::isNull);
        return indexes;
    }

    private static Object getIndexValue(String key, InvoiceMetadata invoiceHeader, KsefImportConfig config) {
        MappingsForIndexesApiV2Enum mapping = MappingsForIndexesApiV2Enum.enumByKey(key);
        switch (mapping) {
            case INVOICE_REFERENCE_NUMBER: {
                return invoiceHeader.getInvoiceNumber();
            }
            case KSEF_REFERENCE_NUMBER: {
                return invoiceHeader.getKsefNumber();
            }
            case INVOICING_DATE: {
                return invoiceHeader.getInvoicingDate() != null ? invoiceHeader.getInvoicingDate().format(DATE_FORMATTER) : null;
            }
            case ACQUISITION_TIMESTAMP: {
                return invoiceHeader.getAcquisitionDate() != null ? invoiceHeader.getAcquisitionDate().format(DATE_FORMATTER) : null;
            }
            case SUBJECT_BY_NAME: {
                return invoiceHeader.getSeller() != null ? invoiceHeader.getSeller().getName() : null;
            }
            case SUBJECT_BY_NIP: {
                return invoiceHeader.getSeller() != null ? invoiceHeader.getSeller().getNip() : null;
            }
            case SUBJECT_TO_NAME: {
                return invoiceHeader.getBuyer() != null ? invoiceHeader.getBuyer().getName() : null;
            }
            case SUBJECT_TO_NIP: {
                return invoiceHeader.getBuyer() != null && invoiceHeader.getBuyer().getIdentifier() != null ? invoiceHeader.getBuyer().getIdentifier().getValue() : null;
            }
            case NET: {
                return invoiceHeader.getNetAmount();
            }
            case VAT: {
                return invoiceHeader.getVatAmount();
            }
            case GROSS: {
                return invoiceHeader.getGrossAmount();
            }
            case CONFIG_ID: {
                return config.getConfigId();
            }
            case CONFIG_NIP: {
                return config.getNip();
            }
            case CONFIG_SYSTEM_TYPE: {
                return config.getKsefSystemType();
            }
            case INVOICING_MODE: {
                return invoiceHeader.getInvoicingMode() != null ? invoiceHeader.getInvoicingMode().getValue() : null;
            }
            case CURRENCY: {
                return invoiceHeader.getCurrency();
            }
            case HAS_ATTACHMENT: {
                return invoiceHeader.getHasAttachment();
            }
            case INVOICE_TYPE: {
                return invoiceHeader.getInvoiceType() != null ? invoiceHeader.getInvoiceType().getValue() : null;
            }
        }
        return null;
    }

    private ImportDocumentsFromKSeFUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

