/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.plugin.plusksef.api.enums.InvoiceSendMethod;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.model.invoice.InvoiceStatusResponse;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.entity.ExportedDocumentTableEntity;
import com.suncode.plugin.plusksef.db.service.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.scheduledtask.parameters.LoadInvoiceStatusFromKSeFTaskParams;
import com.suncode.plugin.plusksef.scheduledtask.summary.LoadInvoiceStatusFromKSeFSummary;
import com.suncode.plugin.plusksef.scheduledtask.utils.ScheduledTaskUtils;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.session.SessionInvoiceStatusResponse;

@ScheduledTask
public class LoadInvoiceStatusFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(LoadInvoiceStatusFromKSeF.class);
    private static final String ID = "plusksef.scheduledTask.LoadInvoiceStatusFromKSeF";
    private static final ObjectMapper OBJECT_MAPPER = LoadInvoiceStatusFromKSeF.createObjectMapper();
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KsefActivityService activityService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).cancelable().parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("processDefId").name(ID.concat(".param.processDefId.name")).description(ID.concat(".param.processDefId.desc")).type((Type)Types.STRING).create()).parameter().id("activityDefId").name(ID.concat(".param.activityDefId.name")).description(ID.concat(".param.activityDefId.desc")).type((Type)Types.STRING).create()).parameter().id("referenceNumberVariableId").name(ID.concat(".param.referenceNumberVariableId.name")).description(ID.concat(".param.referenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("actionId").name(ID.concat(".param.actionId.name")).description(ID.concat(".param.actionId.desc")).type((Type)Types.STRING).create()).parameter().id("invoiceStatusVariableId").name(ID.concat(".param.invoiceStatusVariable.name")).description(ID.concat(".param.invoiceStatusVariable.desc")).type((Type)Types.STRING).create()).parameter().id("ksefReferenceNumberVariableId").name(ID.concat(".param.ksefReferenceNumberVariableId.name")).description(ID.concat(".param.ksefReferenceNumberVariableId.desc")).type((Type)Types.STRING).create()).parameter().id("ksefResponseJsonVariableId").name(ID.concat(".param.ksefResponseJsonVariableId.name")).description(ID.concat(".param.ksefResponseJsonVariableId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("invoicingModeVariableId").name(ID.concat(".param.invoicingModeVariableId.name")).description(ID.concat(".param.invoicingModeVariableId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("attemptCount").name(ID.concat(".param.attemptCount.name")).description(ID.concat(".param.attemptCount.desc")).type((Type)Types.INTEGER).defaultValue((Object)1).create();
    }

    public String execute(@Param String configId, @Param String processDefId, @Param String activityDefId, @Param(value="referenceNumberVariableId") String elementReferenceNumberVariableId, @Param String actionId, @Param String invoiceStatusVariableId, @Param String ksefReferenceNumberVariableId, @Param String ksefResponseJsonVariableId, @Param String invoicingModeVariableId, @Param Integer attemptCount, org.apache.log4j.Logger logger) throws Exception {
        try {
            List<Activity> activities = this.activityService.findOpenActivities(processDefId, activityDefId);
            logger.debug((Object)("Found " + activities.size() + " tasks."));
            if (activities.isEmpty()) {
                logger.warn((Object)"No open tasks found");
                return "No open tasks found";
            }
            LoadInvoiceStatusFromKSeFSummary loadInvoiceStatusFromKSeFSummary = new LoadInvoiceStatusFromKSeFSummary();
            loadInvoiceStatusFromKSeFSummary.setNumberOfDocumentsFound(activities.size());
            HashSet<String> processedActivityIds = new HashSet<String>();
            ArrayList<String> configIds = new ArrayList<String>();
            Arrays.stream(configId.split(",")).map(String::trim).filter(configIdPart -> !configIdPart.isEmpty()).distinct().forEach(singleConfigId -> {
                configIds.add((String)singleConfigId);
                LoadInvoiceStatusFromKSeFTaskParams params = LoadInvoiceStatusFromKSeFTaskParams.builder().configId((String)singleConfigId).processDefId(processDefId).activityDefId(activityDefId).elementReferenceNumberVariableId(elementReferenceNumberVariableId).actionId(actionId).invoiceStatusVariableId(invoiceStatusVariableId).ksefReferenceNumberVariableId(ksefReferenceNumberVariableId).ksefResponseJsonVariableId(ksefResponseJsonVariableId).invoicingModeVariableId(invoicingModeVariableId).attemptCount(attemptCount != null ? attemptCount : 1).logger(logger).activities(activities).summary(loadInvoiceStatusFromKSeFSummary).processedActivityIds(processedActivityIds).build();
                this.processTask(params);
            });
            ScheduledTaskUtils.logUnlinkedActivities(activities, processedActivityIds, configIds, logger);
            return loadInvoiceStatusFromKSeFSummary.buildSummary();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw e;
        }
    }

    private void processTask(LoadInvoiceStatusFromKSeFTaskParams params) {
        params.getLogger().debug((Object)("Processing configuration: " + params.getConfigId()));
        this.processInteractiveSessionInvoices(params);
        this.processBatchSessionInvoices(params);
    }

    private void processInteractiveSessionInvoices(LoadInvoiceStatusFromKSeFTaskParams params) {
        try {
            List<Activity> interactiveSessionActivities = this.filterActivitiesByConfigAndSendMethod(params, InvoiceSendMethod.INTERACTIVE_SESSION);
            params.getLogger().debug((Object)("Found " + interactiveSessionActivities.size() + " interactive session activities for configuration " + params.getConfigId()));
            if (interactiveSessionActivities.isEmpty()) {
                params.getLogger().debug((Object)("No interactive session activities found for configuration: " + params.getConfigId()));
                return;
            }
            interactiveSessionActivities.forEach(activity -> params.getProcessedActivityIds().add(activity.getActivityId()));
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(params.getConfigId());
            if (ksefImportConfig.getApiVersion() == KsefApiVersion.V2) {
                this.executeKSeFv2(ksefImportConfig, interactiveSessionActivities, params);
            } else {
                this.executeKSeFv1(ksefImportConfig, interactiveSessionActivities, params);
            }
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error processing interactive session invoices: " + e.getMessage()), (Throwable)e);
        }
    }

    private void processBatchSessionInvoices(LoadInvoiceStatusFromKSeFTaskParams params) {
        try {
            KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(params.getConfigId());
            if (ksefImportConfig.getApiVersion() != KsefApiVersion.V2) {
                params.getLogger().warn((Object)("Batch session is only supported for KSeF API v2. Configuration: " + params.getConfigId()));
                return;
            }
            List<Activity> batchSessionActivities = this.filterActivitiesByConfigAndSendMethod(params, InvoiceSendMethod.BATCH_SESSION);
            if (batchSessionActivities.isEmpty()) {
                params.getLogger().debug((Object)("No batch session activities found for configuration: " + params.getConfigId()));
                return;
            }
            params.getLogger().debug((Object)("Found " + batchSessionActivities.size() + " batch session activities for configuration " + params.getConfigId()));
            Map<String, List<Activity>> activitiesBySession = this.groupActivitiesBySessionReference(batchSessionActivities, params.getElementReferenceNumberVariableId(), params.getLogger(), InvoiceSendMethod.BATCH_SESSION);
            params.getLogger().debug((Object)("Grouped " + batchSessionActivities.size() + " activities into " + activitiesBySession.size() + " batches by session reference number"));
            this.processActivitiesWithSessionDocuments(params, ksefImportConfig, activitiesBySession, InvoiceSendMethod.BATCH_SESSION);
        }
        catch (Exception e) {
            params.getLogger().error((Object)("Error processing batch session invoices: " + e.getMessage()), (Throwable)e);
        }
    }

    private void processActivitiesWithSessionDocuments(LoadInvoiceStatusFromKSeFTaskParams params, KsefImportConfig ksefImportConfig, Map<String, List<Activity>> activitiesBySession, InvoiceSendMethod sendMethod) throws Exception {
        Map<String, List<SessionInvoiceStatusResponse>> sessionDocumentsMap = this.fetchSessionDocumentsMap(ksefImportConfig, activitiesBySession.keySet(), params.getLogger());
        for (Map.Entry<String, List<Activity>> sessionEntry : activitiesBySession.entrySet()) {
            String sessionReferenceNumber = sessionEntry.getKey();
            List<Activity> sessionActivities = sessionEntry.getValue();
            List<SessionInvoiceStatusResponse> sessionDocuments = sessionDocumentsMap.get(sessionReferenceNumber);
            for (Activity activity : sessionActivities) {
                this.updateActivityV2(params, activity, sessionDocuments, sendMethod);
            }
        }
    }

    private void executeKSeFv1(KsefImportConfig ksefImportConfig, List<Activity> activities, LoadInvoiceStatusFromKSeFTaskParams params) throws Exception {
        SessionInfo sessionInfo = this.kSeFServiceApiV1.getSession(ksefImportConfig);
        for (Activity activity : activities) {
            this.updateActivityV1(ksefImportConfig, sessionInfo.getSessionToken(), params, activity);
        }
    }

    private void executeKSeFv2(KsefImportConfig ksefImportConfig, List<Activity> activities, LoadInvoiceStatusFromKSeFTaskParams params) throws Exception {
        Map<String, List<Activity>> activitiesBySession = this.groupActivitiesBySessionReference(activities, params.getElementReferenceNumberVariableId(), params.getLogger(), InvoiceSendMethod.INTERACTIVE_SESSION);
        this.processActivitiesWithSessionDocuments(params, ksefImportConfig, activitiesBySession, InvoiceSendMethod.INTERACTIVE_SESSION);
    }

    private void updateActivityV1(KsefImportConfig ksefImportConfig, String sessionToken, LoadInvoiceStatusFromKSeFTaskParams params, Activity activity) {
        try {
            params.getLogger().debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
            params.getSummary().increaseProcessedDocuments();
            Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
            String elementReferenceNumber = activityContext.get(params.getElementReferenceNumberVariableId()).toString();
            String sessionReferenceNumber = this.exportedDocumentTableService.getRowByExportReferenceNumber(elementReferenceNumber).getSessionReferenceNumber();
            params.getLogger().debug((Object)String.format("Session reference number: %s. Element reference number: %s.", sessionReferenceNumber, elementReferenceNumber));
            InvoiceStatusResponse invoiceStatusResponse = this.kSeFServiceApiV1.loadInvoiceStatus(ksefImportConfig.getKsefUrl(), sessionToken, elementReferenceNumber);
            params.getLogger().debug((Object)String.format("Processing code: %s. Processing description: %s", invoiceStatusResponse.getProcessingCode(), invoiceStatusResponse.getProcessingDescription()));
            if (invoiceStatusResponse.getProcessingCode() == 200) {
                this.exportedDocumentTableService.updateRecord(elementReferenceNumber, invoiceStatusResponse.getProcessingDescription(), invoiceStatusResponse.getInvoiceStatus().getKsefReferenceNumber());
                activityContext.put(params.getInvoiceStatusVariableId(), "OK");
                activityContext.put(params.getKsefReferenceNumberVariableId(), invoiceStatusResponse.getInvoiceStatus().getKsefReferenceNumber());
            } else {
                this.exportedDocumentTableService.updateRecord(elementReferenceNumber, invoiceStatusResponse.getProcessingDescription());
                activityContext.put(params.getInvoiceStatusVariableId(), invoiceStatusResponse.getProcessingDescription());
            }
            if (StringUtils.isNotBlank((CharSequence)params.getKsefResponseJsonVariableId())) {
                String responseJson = LoadInvoiceStatusFromKSeF.toJSON(invoiceStatusResponse);
                activityContext.put(params.getKsefResponseJsonVariableId(), responseJson);
            }
            this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, params.getActionId());
            params.getSummary().increaseAcceptInvoiceProcess();
        }
        catch (Exception e) {
            params.getLogger().error((Object)e.getMessage());
            params.getSummary().increaseErrors();
        }
    }

    private void updateActivityV2(LoadInvoiceStatusFromKSeFTaskParams params, Activity activity, List<SessionInvoiceStatusResponse> sessionDocuments, InvoiceSendMethod sendMethod) {
        params.getLogger().debug((Object)String.format("Check activityId: %s", activity.getActivityId()));
        params.getSummary().increaseProcessedDocuments();
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        String referenceNumber = activityContext.get(params.getElementReferenceNumberVariableId()).toString();
        ExportedDocumentTableEntity exportedDocument = this.getExportedDocument(referenceNumber, sendMethod, activity.getProcessId());
        try {
            params.getLogger().debug((Object)String.format("Processed exported document: %s", LoadInvoiceStatusFromKSeF.toJSON(exportedDocument)));
            SessionInvoiceStatusResponse invoiceStatusResponse = this.findInvoiceStatus(sessionDocuments, exportedDocument, sendMethod, referenceNumber);
            if (invoiceStatusResponse == null) {
                params.getLogger().warn((Object)("No invoice status found for processId: " + activity.getProcessId()));
                String status = "Document not found in KSeF session";
                this.handleTechnicalError(exportedDocument, status, activity, params, null, null);
                return;
            }
            params.getLogger().debug((Object)String.format("Processing code: %s. Processing description: %s. ProcessId: %s", invoiceStatusResponse.getStatus().getCode(), invoiceStatusResponse.getStatus().getDescription(), activity.getProcessId()));
            int statusCode = invoiceStatusResponse.getStatus().getCode();
            if (statusCode == 100 || statusCode == 150) {
                this.handleWaitingStatus(exportedDocument, invoiceStatusResponse, activity, params);
                return;
            }
            if (statusCode == 200) {
                this.handleSuccessStatus(exportedDocument, invoiceStatusResponse, activity, params, activityContext);
                return;
            }
            if (this.isTechnicalError(statusCode)) {
                this.handleTechnicalErrorStatus(exportedDocument, invoiceStatusResponse, activity, params);
                return;
            }
            this.handleNonSuccessStatus(exportedDocument, invoiceStatusResponse, activity, params, activityContext);
        }
        catch (Exception e) {
            try {
                String errorMessage = "Technical error: " + e.getMessage();
                this.handleTechnicalError(exportedDocument, errorMessage, activity, params, null, null);
            }
            catch (Exception innerException) {
                params.getLogger().error((Object)("Error processing technical error: " + innerException.getMessage()), (Throwable)innerException);
                params.getSummary().increaseErrors();
            }
        }
    }

    private void acceptActivityWithKsefResponse(LoadInvoiceStatusFromKSeFTaskParams params, Activity activity, Map<String, Object> activityContext, SessionInvoiceStatusResponse invoiceStatusResponse) throws JsonProcessingException, ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        if (StringUtils.isNotBlank((CharSequence)params.getKsefResponseJsonVariableId())) {
            String responseJson = LoadInvoiceStatusFromKSeF.toJSON(invoiceStatusResponse);
            activityContext.put(params.getKsefResponseJsonVariableId(), responseJson);
        }
        if (StringUtils.isNotBlank((CharSequence)params.getInvoicingModeVariableId()) && invoiceStatusResponse.getInvoicingMode() != null) {
            activityContext.put(params.getInvoicingModeVariableId(), invoiceStatusResponse.getInvoicingMode().getValue());
        }
        this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, params.getActionId());
    }

    private static String toJSON(Object invoiceStatusResponse) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(invoiceStatusResponse);
    }

    private Map<String, List<Activity>> groupActivitiesBySessionReference(List<Activity> activities, String sessionOrReferenceNumberVariableId, org.apache.log4j.Logger logger, InvoiceSendMethod sendMethod) {
        HashMap<String, List<Activity>> activitiesBySession = new HashMap<String, List<Activity>>();
        for (Activity activity : activities) {
            try {
                Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
                String referenceNumber = activityContext.get(sessionOrReferenceNumberVariableId).toString();
                ExportedDocumentTableEntity exportedRow = this.getExportedDocument(referenceNumber, sendMethod, activity.getProcessId());
                String sessionReferenceNumber = exportedRow.getSessionReferenceNumber();
                activitiesBySession.computeIfAbsent(sessionReferenceNumber, k -> new ArrayList()).add(activity);
            }
            catch (Exception e) {
                logger.error((Object)("Error grouping activity by session reference: " + e.getMessage()));
            }
        }
        return activitiesBySession;
    }

    private Map<String, List<SessionInvoiceStatusResponse>> fetchSessionDocumentsMap(KsefImportConfig ksefImportConfig, Set<String> sessionReferenceNumbers, org.apache.log4j.Logger logger) throws Exception {
        DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(ksefImportConfig.getKsefUrl(), ksefImportConfig.getKsefSuffixUri(), ksefImportConfig.getKsefQrUri());
        String accessToken = this.kSeFServiceApiV2.getAuthTokens((KSeFClient)ksefClient, ksefImportConfig).accessToken();
        HashMap<String, List<SessionInvoiceStatusResponse>> sessionDocumentsMap = new HashMap<String, List<SessionInvoiceStatusResponse>>();
        for (String sessionReferenceNumber : sessionReferenceNumbers) {
            try {
                List<SessionInvoiceStatusResponse> sessionDocuments = this.kSeFServiceApiV2.getOnlineSessionDocuments((KSeFClient)ksefClient, sessionReferenceNumber, accessToken);
                sessionDocumentsMap.put(sessionReferenceNumber, sessionDocuments);
                logger.debug((Object)("Fetched " + sessionDocuments.size() + " documents for session: " + sessionReferenceNumber));
                Thread.sleep(3000L);
            }
            catch (Exception e) {
                logger.error((Object)("Error fetching session documents for session " + sessionReferenceNumber + ": " + e.getMessage()));
                sessionDocumentsMap.put(sessionReferenceNumber, new ArrayList());
            }
        }
        return sessionDocumentsMap;
    }

    private SessionInvoiceStatusResponse findInvoiceStatus(List<SessionInvoiceStatusResponse> sessionDocuments, ExportedDocumentTableEntity exportedDocument, InvoiceSendMethod sendMethod, String referenceNumber) {
        if (sessionDocuments == null || sessionDocuments.isEmpty()) {
            return null;
        }
        if (sendMethod == InvoiceSendMethod.INTERACTIVE_SESSION) {
            return this.findInvoiceStatusByReferenceNumber(sessionDocuments, referenceNumber);
        }
        return this.findInvoiceStatusByExportedFileName(sessionDocuments, exportedDocument.getExportedFileName());
    }

    private SessionInvoiceStatusResponse findInvoiceStatusByReferenceNumber(List<SessionInvoiceStatusResponse> sessionDocuments, String exportReferenceNumber) {
        for (SessionInvoiceStatusResponse sessionDocument : sessionDocuments) {
            if (sessionDocument.getReferenceNumber() == null || !sessionDocument.getReferenceNumber().equals(exportReferenceNumber)) continue;
            return sessionDocument;
        }
        return null;
    }

    private SessionInvoiceStatusResponse findInvoiceStatusByExportedFileName(List<SessionInvoiceStatusResponse> sessionDocuments, String exportedFileName) {
        for (SessionInvoiceStatusResponse sessionDocument : sessionDocuments) {
            if (sessionDocument.getInvoiceFileName() == null || !sessionDocument.getInvoiceFileName().equals(exportedFileName)) continue;
            return sessionDocument;
        }
        return null;
    }

    private List<Activity> filterActivitiesByConfigAndSendMethod(LoadInvoiceStatusFromKSeFTaskParams params, InvoiceSendMethod sendMethod) {
        return params.getActivities().stream().filter(activity -> this.matchesActivityFilter((Activity)activity, params.getConfigId(), params.getElementReferenceNumberVariableId(), params.getLogger(), sendMethod)).collect(Collectors.toList());
    }

    private boolean matchesActivityFilter(Activity activity, String configId, String elementReferenceNumberVariableId, org.apache.log4j.Logger logger, InvoiceSendMethod sendMethod) {
        try {
            String referenceNumber = this.extractExportReferenceNumber(activity, elementReferenceNumberVariableId, logger);
            if (referenceNumber == null) {
                return false;
            }
            ExportedDocumentTableEntity exportedDocument = this.getExportedDocument(referenceNumber, sendMethod, activity.getProcessId());
            if (exportedDocument == null) {
                logger.debug((Object)String.format("Activity %s: exported document not found for ReferenceNumber: %s", activity.getActivityId(), referenceNumber));
                return false;
            }
            if (!configId.equals(exportedDocument.getConfigId())) {
                return false;
            }
            if (sendMethod != exportedDocument.getSendMethod()) {
                logger.debug((Object)String.format("Activity %s does not have invoice with %s send method, skipping", activity.getActivityId(), sendMethod.getValue()));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.warn((Object)String.format("Error checking if activity %s was exported by config %s: %s", activity.getActivityId(), configId, e.getMessage()));
            return false;
        }
    }

    private String extractExportReferenceNumber(Activity activity, String elementReferenceNumberVariableId, org.apache.log4j.Logger logger) {
        String exportReferenceNumber;
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        Object elementReferenceNumberValue = activityContext.get(elementReferenceNumberVariableId);
        if (!(elementReferenceNumberValue instanceof String) || StringUtils.isBlank((CharSequence)(exportReferenceNumber = (String)elementReferenceNumberValue))) {
            logger.debug((Object)String.format("Activity %s does not have elementReferenceNumber variable %s", activity.getActivityId(), elementReferenceNumberVariableId));
            return null;
        }
        return exportReferenceNumber;
    }

    private void handleTechnicalError(ExportedDocumentTableEntity exportedDocument, String errorMessage, Activity activity, LoadInvoiceStatusFromKSeFTaskParams params, String responseJson, String invoicingMode) {
        int newAttemptCount = this.exportedDocumentTableService.incrementStatusAttemptCountForEntity(exportedDocument, errorMessage);
        params.getLogger().debug((Object)String.format("Technical error occurred. Attempt count incremented to: %d. Max retries: %d. ProcessId: %s", newAttemptCount, params.getAttemptCount(), activity.getProcessId()));
        if (this.shouldAcceptActivityWithError(newAttemptCount, params.getAttemptCount())) {
            this.acceptActivityWithError(errorMessage, activity, params, responseJson, invoicingMode);
        } else {
            params.getLogger().debug((Object)String.format("Attempt limit not exceeded. Task will be retried in next execution. ProcessId: %s", activity.getProcessId()));
        }
    }

    private boolean shouldAcceptActivityWithError(int attemptCount, int maxAttempts) {
        return attemptCount >= maxAttempts;
    }

    private void acceptActivityWithError(String errorMessage, Activity activity, LoadInvoiceStatusFromKSeFTaskParams params, String responseJson, String invoicingMode) {
        params.getLogger().warn((Object)String.format("Attempt limit exceeded for processId: %s. Accepting task with error.", activity.getProcessId()));
        Map<String, Object> activityContext = this.prepareErrorActivityContext(activity, params, errorMessage, responseJson, invoicingMode);
        try {
            this.activityService.acceptActivity(activity.getProcessId(), activity.getActivityId(), activityContext, params.getActionId());
            params.getSummary().increaseErrors();
        }
        catch (Exception acceptException) {
            params.getLogger().error((Object)String.format("Error accepting activity for processId: %s. Error: %s", activity.getProcessId(), acceptException.getMessage()), (Throwable)acceptException);
            params.getSummary().increaseErrors();
        }
    }

    private Map<String, Object> prepareErrorActivityContext(Activity activity, LoadInvoiceStatusFromKSeFTaskParams params, String errorMessage, String responseJson, String invoicingMode) {
        Map<String, Object> activityContext = this.activityService.getActivityContext(activity.getProcessId(), activity.getActivityId());
        activityContext.put(params.getInvoiceStatusVariableId(), errorMessage);
        if (StringUtils.isNotBlank((CharSequence)params.getKsefResponseJsonVariableId()) && responseJson != null) {
            activityContext.put(params.getKsefResponseJsonVariableId(), responseJson);
        }
        if (StringUtils.isNotBlank((CharSequence)params.getInvoicingModeVariableId()) && invoicingMode != null) {
            activityContext.put(params.getInvoicingModeVariableId(), invoicingMode);
        }
        return activityContext;
    }

    private boolean isTechnicalError(int statusCode) {
        if (statusCode >= 500 && statusCode <= 599) {
            return true;
        }
        return statusCode == 404 || statusCode == 405 || statusCode == 410 || statusCode == 415 || statusCode == 429;
    }

    private ExportedDocumentTableEntity getExportedDocument(String referenceNumber, InvoiceSendMethod sendMethod, String processId) {
        return sendMethod == InvoiceSendMethod.INTERACTIVE_SESSION ? this.exportedDocumentTableService.getRowByExportReferenceNumber(referenceNumber) : this.exportedDocumentTableService.getRowBySessionReferenceNumberAndProcessId(referenceNumber, processId);
    }

    private void handleWaitingStatus(ExportedDocumentTableEntity exportedDocument, SessionInvoiceStatusResponse invoiceStatusResponse, Activity activity, LoadInvoiceStatusFromKSeFTaskParams params) {
        this.exportedDocumentTableService.updateRecordForEntity(exportedDocument, invoiceStatusResponse.getStatus().getDescription());
        params.getLogger().debug((Object)String.format("Status code %d (%s). Invoice is still being processed. Task will be retried in next execution without consuming attempt count. ProcessId: %s", invoiceStatusResponse.getStatus().getCode(), invoiceStatusResponse.getStatus().getDescription(), activity.getProcessId()));
    }

    private void handleSuccessStatus(ExportedDocumentTableEntity exportedDocument, SessionInvoiceStatusResponse invoiceStatusResponse, Activity activity, LoadInvoiceStatusFromKSeFTaskParams params, Map<String, Object> activityContext) {
        try {
            Timestamp invoicingDate = invoiceStatusResponse.getInvoicingDate() != null ? Timestamp.from(invoiceStatusResponse.getInvoicingDate().toInstant()) : null;
            int currentAttemptCount = exportedDocument.getStatusAttemptCount();
            this.exportedDocumentTableService.updateRecordForEntity(exportedDocument, invoiceStatusResponse.getStatus().getDescription(), invoiceStatusResponse.getReferenceNumber(), invoiceStatusResponse.getKsefNumber(), invoiceStatusResponse.getInvoiceHash(), invoicingDate, invoiceStatusResponse.getUpoDownloadUrl(), invoiceStatusResponse.getInvoicingMode().name(), currentAttemptCount + 1);
            activityContext.put(params.getInvoiceStatusVariableId(), "OK");
            activityContext.put(params.getKsefReferenceNumberVariableId(), invoiceStatusResponse.getKsefNumber());
            this.acceptActivityWithKsefResponse(params, activity, activityContext, invoiceStatusResponse);
            params.getSummary().increaseAcceptInvoiceProcess();
            params.getLogger().debug((Object)String.format("Successfully processed invoice for processId: %s", activity.getProcessId()));
        }
        catch (JsonProcessingException | ActivityAlreadyCompletedException | ActivityIsSuspendedException | UserIsNotAssignedToActivityException e) {
            throw new RuntimeException("Error handling success status: " + e.getMessage(), e);
        }
    }

    private void handleTechnicalErrorStatus(ExportedDocumentTableEntity exportedDocument, SessionInvoiceStatusResponse invoiceStatusResponse, Activity activity, LoadInvoiceStatusFromKSeFTaskParams params) {
        String errorMessage = invoiceStatusResponse.getStatus().getDescription();
        String responseJson = null;
        try {
            responseJson = StringUtils.isNotBlank((CharSequence)params.getKsefResponseJsonVariableId()) ? LoadInvoiceStatusFromKSeF.toJSON(invoiceStatusResponse) : null;
        }
        catch (JsonProcessingException e) {
            params.getLogger().warn((Object)("Failed to serialize invoice status response to JSON: " + e.getMessage()));
        }
        String invoicingMode = StringUtils.isNotBlank((CharSequence)params.getInvoicingModeVariableId()) && invoiceStatusResponse.getInvoicingMode() != null ? invoiceStatusResponse.getInvoicingMode().getValue() : null;
        this.handleTechnicalError(exportedDocument, errorMessage, activity, params, responseJson, invoicingMode);
    }

    private void handleNonSuccessStatus(ExportedDocumentTableEntity exportedDocument, SessionInvoiceStatusResponse invoiceStatusResponse, Activity activity, LoadInvoiceStatusFromKSeFTaskParams params, Map<String, Object> activityContext) {
        try {
            this.exportedDocumentTableService.incrementStatusAttemptCountForEntity(exportedDocument, invoiceStatusResponse.getStatus().getDescription());
            activityContext.put(params.getInvoiceStatusVariableId(), invoiceStatusResponse.getStatus().getDescription());
            this.acceptActivityWithKsefResponse(params, activity, activityContext, invoiceStatusResponse);
            params.getSummary().increaseErrors();
            params.getLogger().debug((Object)String.format("Processed invoice with non-success status for processId: %s", activity.getProcessId()));
        }
        catch (JsonProcessingException | ActivityAlreadyCompletedException | ActivityIsSuspendedException | UserIsNotAssignedToActivityException e) {
            throw new RuntimeException("Error handling non-success status: " + e.getMessage(), e);
        }
    }

    private static class InvoiceStatusCodes {
        static final int WAITING = 100;
        static final int PROCESSING = 150;
        static final int SUCCESS = 200;
        static final int SESSION_ERROR = 405;
        static final int INVALID_SCOPE = 410;
        static final int NO_ATTACHMENT_SUPPORT = 415;
        static final int NOT_FOUND = 404;
        static final int TOO_MANY_REQUESTS = 429;
        static final int SERVER_ERROR_MIN = 500;
        static final int SERVER_ERROR_MAX = 599;

        private InvoiceStatusCodes() {
        }
    }
}

