/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.api.v2.services.dto.PackageProcessingResult;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.service.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.db.service.InvoiceBatchQueryService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.scheduledtask.summary.ImportDocumentsFromKSeFBatchSummary;
import com.suncode.plugin.plusksef.scheduledtask.utils.ImportDocumentsFromKSeFUtils;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.api.services.DefaultCryptographyService;
import pl.akmf.ksef.sdk.client.interfaces.CryptographyService;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceExportPackage;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceExportStatus;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceMetadata;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQuerySubjectType;
import pl.akmf.ksef.sdk.client.model.session.EncryptionData;

@ScheduledTask
public class ImportDocumentsFromKSeFBatch
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ImportDocumentsFromKSeFBatch.class);
    private static final String ID = "plusksef.scheduledTask.ImportDocumentsFromKSeFBatch";
    private static final int DEFAULT_FIRST_RUN_MONTHS_AGO = 1;
    private static final String LAST_CALL_DATE = "LAST_CALL_DATE";
    private final SimpleDateFormat dateFormatDDMMYYYY = new SimpleDateFormat("dd-MM-yyyy");
    private final SimpleDateFormat dateFormatYYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private ImportedDocumentTableService importedDocumentTableService;
    @Autowired
    private InvoiceBatchQueryService invoiceBatchQueryService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    public ImportDocumentsFromKSeFBatch() {
        this.dateFormatDDMMYYYY.setLenient(false);
        this.dateFormatYYYYMMDD.setLenient(false);
    }

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).parameter().id("configIds").name(ID.concat(".param.configIds.name")).description(ID.concat(".param.configIds.desc")).type((Type)Types.STRING).create()).parameter().id("readFromDate").name(ID.concat(".param.readFromDate.name")).description(ID.concat(".param.readFromDate.desc")).type((Type)Types.STRING).create()).parameter().id("includeSubject3").name(ID.concat(".param.includeSubject3.name")).description(ID.concat(".param.includeSubject3.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)"false").create();
    }

    public String execute(@Param String configIds, @Param String readFromDate, @Param Boolean includeSubject3) {
        ImportDocumentsFromKSeFBatchSummary summary = new ImportDocumentsFromKSeFBatchSummary();
        boolean includeSubject3Value = includeSubject3 != null ? includeSubject3 : false;
        Arrays.stream(configIds.split(",")).filter(config -> !config.isEmpty()).distinct().forEach(configId -> this.processConfig((String)configId, readFromDate, includeSubject3Value, summary));
        return summary.buildSummary();
    }

    private void processConfig(String configId, String readFromDate, boolean includeSubject3, ImportDocumentsFromKSeFBatchSummary summary) {
        taskLog.debug((Object)("Processing config: " + configId));
        KsefImportConfig config = this.configService.readConfigurationFromPCM(configId);
        Assert.isTrue((config.getApiVersion() == KsefApiVersion.V2 ? 1 : 0) != 0, (String)("Incremental import supports only KSeF API v2. Config " + configId + " uses " + String.valueOf((Object)config.getApiVersion())));
        DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(config.getKsefUrl(), config.getKsefSuffixUri(), config.getKsefQrUri());
        String accessToken = this.kSeFServiceApiV2.getAuthTokens((KSeFClient)ksefClient, config).accessToken();
        DefaultCryptographyService cryptographyService = new DefaultCryptographyService((KSeFClient)ksefClient);
        List subjectTypes = Arrays.stream(InvoiceQuerySubjectType.values()).filter(st -> st == InvoiceQuerySubjectType.SUBJECT2 || includeSubject3 && st == InvoiceQuerySubjectType.SUBJECT3).collect(Collectors.toList());
        for (InvoiceQuerySubjectType subjectType : subjectTypes) {
            this.processSubjectType((KSeFClient)ksefClient, accessToken, (CryptographyService)cryptographyService, config, subjectType, readFromDate, summary);
        }
    }

    private void processSubjectType(KSeFClient ksefClient, String accessToken, CryptographyService cryptographyService, KsefImportConfig config, InvoiceQuerySubjectType subjectType, String readFromDate, ImportDocumentsFromKSeFBatchSummary summary) throws Exception {
        String nip = config.getNip();
        String systemType = config.getKsefSystemType();
        String subjectTypeKey = subjectType.name();
        OffsetDateTime from = this.getEffectiveFrom(nip, systemType, subjectTypeKey, readFromDate);
        taskLog.debug((Object)("Incremental export for subjectType=" + String.valueOf(subjectType) + " from " + String.valueOf(from)));
        while (true) {
            EncryptionData encryptionData;
            String referenceNumber;
            InvoiceExportStatus status;
            InvoiceExportPackage packageParts;
            if ((packageParts = (status = this.kSeFServiceApiV2.checkExportStatus(ksefClient, referenceNumber = this.kSeFServiceApiV2.initiateInvoiceExport(ksefClient, accessToken, from, null, subjectType, (encryptionData = cryptographyService.getEncryptionData()).encryptionInfo()), accessToken)).getPackageParts()) == null || packageParts.getInvoiceCount() == 0) {
                this.updateContinuationPointIfNeeded(nip, systemType, subjectTypeKey, packageParts);
                break;
            }
            summary.increasePackagesProcessed();
            List parts = packageParts.getParts();
            if (parts == null || parts.isEmpty()) break;
            taskLog.debug((Object)("InvoiceExportPackage parts count: " + parts.size()));
            PackageProcessingResult packageResult = this.kSeFServiceApiV2.downloadAndProcessPackage(ksefClient, status, encryptionData, cryptographyService);
            Map<String, String> unzippedFiles = packageResult.getDownloadedFiles();
            List<InvoiceMetadata> metadataList = packageResult.getInvoiceMetadataList();
            if (metadataList == null || metadataList.isEmpty()) {
                taskLog.warn((Object)("Package has no _metadata.json or empty invoices list, skipping for subjectType=" + String.valueOf(subjectType)));
            } else {
                summary.increaseProcessedDocuments(metadataList.size());
                for (InvoiceMetadata metadata : metadataList) {
                    if (metadata.getKsefNumber() == null) continue;
                    String xmlContent = unzippedFiles.get(metadata.getKsefNumber() + ".xml");
                    if (xmlContent == null) {
                        xmlContent = unzippedFiles.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith(".xml") && ((String)e.getKey()).startsWith(metadata.getKsefNumber())).map(Map.Entry::getValue).findFirst().orElse(null);
                    }
                    if (xmlContent == null) continue;
                    this.loadDocumentFromPackage(config, metadata, xmlContent.getBytes(StandardCharsets.UTF_8), summary);
                }
            }
            this.updateContinuationPointIfNeeded(nip, systemType, subjectTypeKey, packageParts);
            from = this.getContinuationPointFromPackage(packageParts);
            if (from == null || !Boolean.TRUE.equals(packageParts.getIsTruncated())) break;
            taskLog.debug((Object)("Package truncated, continuing from " + String.valueOf(from)));
        }
    }

    private OffsetDateTime getEffectiveFrom(String nip, String systemType, String subjectTypeKey, String readFromDateParam) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)readFromDateParam) && !readFromDateParam.trim().startsWith(LAST_CALL_DATE)) {
            Date date = this.parseDate(readFromDateParam.trim());
            return date.toInstant().atOffset(ZoneOffset.UTC);
        }
        Date continuation = this.invoiceBatchQueryService.getContinuationPoint(nip, systemType, subjectTypeKey);
        if (continuation != null) {
            return continuation.toInstant().atOffset(ZoneOffset.UTC);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        return cal.getTime().toInstant().atOffset(ZoneOffset.UTC);
    }

    private Date parseDate(String dateString) throws ParseException {
        try {
            return this.dateFormatDDMMYYYY.parse(dateString);
        }
        catch (ParseException e) {
            return this.dateFormatYYYYMMDD.parse(dateString);
        }
    }

    private void updateContinuationPointIfNeeded(String nip, String systemType, String subjectTypeKey, InvoiceExportPackage packageParts) {
        OffsetDateTime continuationDate = this.extractContinuationDate(packageParts);
        if (continuationDate != null) {
            this.invoiceBatchQueryService.saveContinuationPoint(nip, systemType, subjectTypeKey, Timestamp.from(continuationDate.toInstant()));
        }
    }

    private OffsetDateTime getContinuationPointFromPackage(InvoiceExportPackage packageParts) {
        return this.extractContinuationDate(packageParts);
    }

    private OffsetDateTime extractContinuationDate(InvoiceExportPackage packageParts) {
        if (packageParts == null) {
            return null;
        }
        if (Boolean.TRUE.equals(packageParts.getIsTruncated()) && packageParts.getLastPermanentStorageDate() != null) {
            return packageParts.getLastPermanentStorageDate();
        }
        return packageParts.getPermanentStorageHwmDate();
    }

    private void loadDocumentFromPackage(KsefImportConfig config, InvoiceMetadata invoiceData, byte[] invoiceXml, ImportDocumentsFromKSeFBatchSummary summary) throws Exception {
        boolean loaded = ImportDocumentsFromKSeFUtils.loadDocumentToArchive(config, invoiceData, invoiceXml, this.importedDocumentTableService, this.archiveDocumentService, this.documentClassActionService);
        if (!loaded) {
            taskLog.debug((Object)("SKIP document: " + invoiceData.getKsefNumber() + " (already imported)"));
            summary.increaseSkippedDocuments();
            return;
        }
        taskLog.debug((Object)("Load document: " + invoiceData.getKsefNumber()));
        summary.increaseLoadDocuments();
    }
}

