/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.invoice.util.converter;

import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.validator.GenericValidator;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverter {
    private static final Logger log = LoggerFactory.getLogger(TypeConverter.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");

    private TypeConverter() {
    }

    public static Integer toInteger(Byte value) {
        return value.intValue();
    }

    public static Integer toInteger(BigInteger value) {
        return value.intValue();
    }

    public static Double toFloat(BigDecimal value) {
        return value.doubleValue();
    }

    public static Double toFloat(String value) {
        return Double.parseDouble(value);
    }

    public static LocalDateTime toLocalDateTime(XMLGregorianCalendar value) {
        return new LocalDateTime((Object)value.toGregorianCalendar().getTime());
    }

    public static LocalDate toDate(XMLGregorianCalendar value) {
        return new LocalDate((Object)value.toGregorianCalendar().getTime());
    }

    public static String toString(Byte value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String toString(BigInteger value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public static String toString(Type<?> type, Object value) {
        if (value == null) {
            return null;
        }
        if (type == Types.DATETIME) {
            return ((LocalDateTime)value).toString(DATE_TIME_FORMATTER);
        }
        return value.toString();
    }

    public static Byte toByte(Type<?> type, Object value) {
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        if (type == Types.INTEGER) {
            return ((Long)value).byteValue();
        }
        if (type == Types.BOOLEAN) {
            return (byte)((Boolean)value == true ? 1 : 0);
        }
        if (type == Types.FLOAT) {
            return ((Double)value).byteValue();
        }
        return Byte.parseByte(value.toString());
    }

    public static XMLGregorianCalendar toXmlGregorianCalendar(Type<?> type, Object value) {
        if (value == null) {
            return null;
        }
        if (type == Types.DATE) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(((LocalDate)value).toDate());
            XMLGregorianCalendar xmlGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
            xmlGregorianCalendar.setTimezone(Integer.MIN_VALUE);
            return xmlGregorianCalendar;
        }
        if (type == Types.DATETIME) {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(((LocalDateTime)value).toDate());
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(gc);
        }
        if (type == Types.STRING) {
            if (GenericValidator.isDate((String)value.toString(), (String)DATE_FORMAT, (boolean)true)) {
                return TypeConverter.toXmlGregorianCalendar(Types.DATE, DATE_FORMATTER.parseLocalDateTime(value.toString()).toLocalDate());
            }
            if (GenericValidator.isDate((String)value.toString(), (String)DATE_TIME_FORMAT, (boolean)true)) {
                return TypeConverter.toXmlGregorianCalendar(Types.DATETIME, DATE_TIME_FORMATTER.parseLocalDateTime(value.toString()));
            }
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(value.toString());
        }
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(value.toString());
    }

    public static BigInteger toBigInteger(Type<?> type, Object value) {
        if (value == null) {
            return BigInteger.ZERO;
        }
        if (type == Types.BOOLEAN) {
            return BigInteger.valueOf(Boolean.TRUE.equals(value) ? 1L : 0L);
        }
        if (type == Types.INTEGER) {
            return BigInteger.valueOf((Long)value);
        }
        if (type == Types.FLOAT) {
            return BigInteger.valueOf(((Double)value).longValue());
        }
        return BigInteger.valueOf(Long.parseLong(value.toString()));
    }

    public static BigDecimal toBigDecimal(Type<?> type, Object value) {
        if (value == null) {
            return BigDecimal.valueOf(0L);
        }
        if (type == Types.BOOLEAN) {
            return BigDecimal.valueOf(Boolean.TRUE.equals(value) ? 1L : 0L);
        }
        if (type == Types.INTEGER) {
            return BigDecimal.valueOf((Long)value);
        }
        return BigDecimal.valueOf(Double.parseDouble(value.toString()));
    }
}

