/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.activity.service;

import com.suncode.plugin.plusksef.activity.service.KsefActivityService;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.activity.exception.ActivityAlreadyCompletedException;
import com.suncode.pwfl.workflow.activity.exception.ActivityIsSuspendedException;
import com.suncode.pwfl.workflow.activity.exception.UserIsNotAssignedToActivityException;
import com.suncode.pwfl.workflow.activity.util.AcceptationDefinition;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessFinder;
import com.suncode.pwfl.workflow.process.ProcessState;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KsefActivityServiceImpl
implements KsefActivityService {
    @Autowired
    ActivityService activityService;
    @Autowired
    ActivityFinder activityFinder;
    @Autowired
    ProcessFinder processFinder;

    @Override
    public List<Activity> findOpenActivities(String processDefinitionId, String activityDefinitionId) {
        List openProcessesId = this.processFinder.findByProcessDefinitionId(processDefinitionId).stream().filter(process -> process.getState() == ProcessState.RUNNING || process.getState() == ProcessState.NOT_STARTED).map(Process::getProcessId).collect(Collectors.toList());
        return openProcessesId.stream().map(processId -> this.activityFinder.findOpenedActivities(processId).stream().filter(activity -> activity.isOpen() && activity.getActivityDefinitionId().equals(activityDefinitionId)).findFirst()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Override
    public void acceptActivity(String processId, String activityId, Map<String, Object> activityContextMap, String actionName) throws ActivityIsSuspendedException, UserIsNotAssignedToActivityException, ActivityAlreadyCompletedException {
        String executorLogin = SystemProperties.getString((String)"Bufor.username");
        this.activityService.openActivity(executorLogin, processId, activityId);
        AcceptationDefinition acceptationDef = new AcceptationDefinition(processId, activityId, executorLogin, actionName);
        acceptationDef.setIgnoreValidators(Boolean.valueOf(false));
        acceptationDef.setContextMap(activityContextMap);
        this.activityService.acceptActivity(acceptationDef);
    }

    @Override
    public Map<String, Object> getActivityContext(String processId, String activityId) {
        return this.activityService.getActivityContext(processId, activityId);
    }

    @Override
    public void setActivityContext(String processId, String activityId, Map<String, Object> context) {
        this.activityService.setActivityContext(processId, activityId, context);
    }
}

