/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api.services;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.SignaturePackaging;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.MimeType;
import eu.europa.esig.dss.model.SignatureValue;
import eu.europa.esig.dss.model.ToBeSigned;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.CommonCertificateVerifier;
import eu.europa.esig.dss.xades.XAdESSignatureParameters;
import eu.europa.esig.dss.xades.signature.XAdESService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import pl.akmf.ksef.sdk.client.interfaces.SignatureService;
import pl.akmf.ksef.sdk.sign.CertUtil;
import pl.akmf.ksef.sdk.sign.LocalSigningContext;

public class DefaultSignatureService
implements SignatureService {
    @Override
    public String sign(byte[] xml, X509Certificate signatureCertificate, PrivateKey privateKey) throws IOException {
        LocalSigningContext signContextProvider = new LocalSigningContext();
        InMemoryDocument toSignDocument = new InMemoryDocument(xml, null, MimeType.XML);
        CommonCertificateVerifier commonCertificateVerifier = new CommonCertificateVerifier();
        XAdESService service = new XAdESService((CertificateVerifier)commonCertificateVerifier);
        XAdESSignatureParameters parameters = this.prepareParameters(signatureCertificate, privateKey);
        ToBeSigned dataToSign = service.getDataToSign((DSSDocument)toSignDocument, parameters);
        SignatureValue signatureValue = signContextProvider.createSignatureValue(dataToSign, signatureCertificate, privateKey);
        DSSDocument signedDocument = service.signDocument((DSSDocument)toSignDocument, parameters, signatureValue);
        try (ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)signedDocument.openStream();){
            int read;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((read = byteArrayInputStream.read(buffer)) != -1) {
                output.write(buffer, 0, read);
            }
            String string = new String(output.toByteArray(), StandardCharsets.UTF_8);
            return string;
        }
    }

    private XAdESSignatureParameters prepareParameters(X509Certificate x509Certificate, PrivateKey privateKey) {
        EncryptionAlgorithm encryptionAlgorithm;
        XAdESSignatureParameters parameters = new XAdESSignatureParameters();
        parameters.setSignaturePackaging(SignaturePackaging.ENVELOPED);
        parameters.setSignatureLevel(SignatureLevel.XAdES_BASELINE_B);
        parameters.setEn319132(false);
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA256;
        if (CertUtil.isMatchingRsaPair(x509Certificate, privateKey)) {
            encryptionAlgorithm = EncryptionAlgorithm.RSA;
        } else if (CertUtil.isMatchingEcdsaPair(x509Certificate, privateKey)) {
            encryptionAlgorithm = EncryptionAlgorithm.ECDSA;
            ECPublicKey ecPublicKey = (ECPublicKey)x509Certificate.getPublicKey();
            int fieldSize = ecPublicKey.getParams().getCurve().getField().getFieldSize();
            digestAlgorithm = fieldSize <= 256 ? DigestAlgorithm.SHA256 : (fieldSize <= 384 ? DigestAlgorithm.SHA384 : DigestAlgorithm.SHA512);
        } else {
            throw new IllegalArgumentException("Encoding data are incorrect: \nCertificate signatureAlg: " + x509Certificate.getSigAlgName() + "\nPublicKey signatureAlg: " + x509Certificate.getPublicKey().getAlgorithm() + "\nPrivateKEy signatureAlg: " + privateKey.getAlgorithm());
        }
        parameters.setEncryptionAlgorithm(encryptionAlgorithm);
        parameters.setDigestAlgorithm(digestAlgorithm);
        parameters.setSigningCertificateDigestMethod(digestAlgorithm);
        parameters.setSigningCertificate(new CertificateToken(x509Certificate));
        return parameters;
    }
}

