/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pl.akmf.ksef.sdk.api.HttpStatus;
import pl.akmf.ksef.sdk.api.SimpleHttpClient;

public class HttpUtils {
    private HttpUtils() {
    }

    public static String buildUrlWithParams(String baseUrl, Map<String, String> params) {
        if (params == null || params.isEmpty()) {
            return baseUrl;
        }
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("?");
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getKey()) || !StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
            if (!first) {
                url.append("&");
            }
            url.append(entry.getKey().replace(" ", "%20").replace("&", "%26"));
            url.append("=");
            url.append(entry.getValue().replace(" ", "%20").replace("&", "%26"));
            first = false;
        }
        return url.toString();
    }

    public static String buildUrlWithParams(String baseUrl, List<KeyValue> keyValues) {
        if (keyValues == null || keyValues.isEmpty()) {
            return baseUrl;
        }
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("?");
        boolean first = true;
        for (KeyValue keyValue : keyValues) {
            if (!StringUtils.isNotBlank((CharSequence)keyValue.getKey()) || !StringUtils.isNotBlank((CharSequence)keyValue.getValue())) continue;
            if (!first) {
                url.append("&");
            }
            url.append(keyValue.getKey().replace("&", "%26"));
            url.append("=");
            url.append(keyValue.getValue().replace("&", "%26"));
            first = false;
        }
        return url.toString();
    }

    public static boolean isValidResponse(SimpleHttpClient.SimpleHttpResponse response, HttpStatus expectedStatus) {
        return expectedStatus.getCode() == response.statusCode();
    }

    public static String formatExceptionMessage(String operationId, int statusCode, byte[] body) {
        String exceptionMessage = body == null || body.length == 0 ? "[no body]" : new String(body, StandardCharsets.UTF_8);
        return operationId + " call failed with: " + statusCode + " - " + exceptionMessage;
    }

    public static class KeyValue {
        private final String key;
        private final String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

