/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.upgrader;

import com.suncode.upgrader.change.ChangeContext;
import com.suncode.upgrader.change.task.Task;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeInvoicingDateColumnType
implements Task {
    private static final Logger log = LoggerFactory.getLogger(ChangeInvoicingDateColumnType.class);
    private static final String POSTGRESQL = "postgresql";
    private static final String MICROSOFT = "microsoft";
    private static final String SQL_SERVER = "sql server";
    private static final String ORACLE = "oracle";
    private static final String IMPORTED_TABLE = "plus_ksef_imported_documents";
    private static final String EXPORTED_TABLE = "plus_ksef_exported_documents";
    private static final String COLUMN_NAME = "invoicing_date";

    public void run() {
        Connection connection = ChangeContext.connection();
        String databaseProductName = connection.getMetaData().getDatabaseProductName();
        log.info("Starting column type migration for database: {}", (Object)databaseProductName);
        this.changeColumnType(connection, IMPORTED_TABLE, databaseProductName);
        this.changeColumnType(connection, EXPORTED_TABLE, databaseProductName);
        log.info("Successfully changed invoicing_date column type to timestamp");
    }

    private void changeColumnType(Connection connection, String tableName, String databaseProductName) throws SQLException {
        if (!this.tableExists(connection, tableName, databaseProductName)) {
            log.info("Table {} does not exist, skipping", (Object)tableName);
            return;
        }
        if (!this.columnExists(connection, tableName, databaseProductName)) {
            log.info("Column {}.{} does not exist, skipping", (Object)tableName, (Object)COLUMN_NAME);
            return;
        }
        String currentType = this.getColumnType(connection, tableName, databaseProductName);
        log.info("Current type of {}.{} is: {}", new Object[]{tableName, COLUMN_NAME, currentType});
        if (this.isAlreadyTimestamp(currentType, databaseProductName)) {
            log.info("Column {}.{} is already timestamp type, no migration needed", (Object)tableName, (Object)COLUMN_NAME);
            return;
        }
        log.info("Migrating column {}.{} from {} to timestamp", new Object[]{tableName, COLUMN_NAME, currentType});
        String newColumnName = "invoicing_date_new";
        this.createTempColumn(connection, tableName, newColumnName, databaseProductName);
        this.convertBinaryDataToTimestamp(connection, tableName, newColumnName);
        this.dropColumn(connection, tableName, databaseProductName);
        this.renameColumn(connection, tableName, newColumnName, databaseProductName);
        log.info("Successfully migrated column {}.{} to timestamp", (Object)tableName, (Object)COLUMN_NAME);
    }

    private boolean isAlreadyTimestamp(String currentType, String databaseProductName) {
        if (currentType == null) {
            return false;
        }
        String typeLower = currentType.toLowerCase(Locale.ROOT);
        String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
        if (dbLower.contains(POSTGRESQL)) {
            return typeLower.contains("timestamp");
        }
        if (dbLower.contains(MICROSOFT) || dbLower.contains(SQL_SERVER)) {
            return typeLower.contains("datetime") || typeLower.contains("timestamp");
        }
        if (dbLower.contains(ORACLE)) {
            return typeLower.contains("timestamp") || typeLower.contains("date");
        }
        return false;
    }

    private void createTempColumn(Connection connection, String tableName, String tempColumnName, String databaseProductName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sql;
            String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
            if (dbLower.contains(POSTGRESQL)) {
                sql = String.format("ALTER TABLE %s ADD COLUMN %s timestamp without time zone", tableName, tempColumnName);
            } else if (dbLower.contains(MICROSOFT) || dbLower.contains(SQL_SERVER)) {
                sql = String.format("ALTER TABLE %s ADD %s datetime2", tableName, tempColumnName);
            } else if (dbLower.contains(ORACLE)) {
                sql = String.format("ALTER TABLE %s ADD %s TIMESTAMP", tableName, tempColumnName.toUpperCase(Locale.ROOT));
            } else {
                throw new SQLException("Unsupported database: " + databaseProductName);
            }
            stmt.execute(sql);
            log.info("Created temporary column {}.{}", (Object)tableName, (Object)tempColumnName);
        }
    }

    private void dropColumn(Connection connection, String tableName, String databaseProductName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sql;
            String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
            if (dbLower.contains(POSTGRESQL)) {
                sql = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, COLUMN_NAME);
            } else if (dbLower.contains(MICROSOFT) || dbLower.contains(SQL_SERVER)) {
                sql = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, COLUMN_NAME);
            } else if (dbLower.contains(ORACLE)) {
                sql = String.format("ALTER TABLE %s DROP COLUMN %s", tableName, COLUMN_NAME.toUpperCase(Locale.ROOT));
            } else {
                throw new SQLException("Unsupported database: " + databaseProductName);
            }
            stmt.execute(sql);
            log.info("Dropped column {}.{}", (Object)tableName, (Object)COLUMN_NAME);
        }
    }

    private void renameColumn(Connection connection, String tableName, String oldColumnName, String databaseProductName) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            String sql;
            String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
            if (dbLower.contains(POSTGRESQL)) {
                sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", tableName, oldColumnName, COLUMN_NAME);
            } else if (dbLower.contains(MICROSOFT) || dbLower.contains(SQL_SERVER)) {
                sql = String.format("EXEC sp_rename '%s.%s', '%s', 'COLUMN'", tableName, oldColumnName, COLUMN_NAME);
            } else if (dbLower.contains(ORACLE)) {
                sql = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", tableName, oldColumnName.toUpperCase(Locale.ROOT), COLUMN_NAME.toUpperCase(Locale.ROOT));
            } else {
                throw new SQLException("Unsupported database: " + databaseProductName);
            }
            stmt.execute(sql);
            log.info("Renamed column {}.{} to {}", new Object[]{tableName, oldColumnName, COLUMN_NAME});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertBinaryDataToTimestamp(Connection connection, String tableName, String targetColumnName) throws SQLException {
        String selectQuery = String.format("SELECT id, %s FROM %s WHERE %s IS NOT NULL", COLUMN_NAME, tableName, COLUMN_NAME);
        String updateQuery = String.format("UPDATE %s SET %s = ? WHERE id = ?", tableName, targetColumnName);
        int convertedCount = 0;
        int failedCount = 0;
        try (PreparedStatement selectStmt = connection.prepareStatement(selectQuery);
             ResultSet resultSet = selectStmt.executeQuery();){
            while (resultSet.next()) {
                long id = resultSet.getLong("id");
                Timestamp timestamp = this.readTimestampFromBinary(resultSet);
                if (timestamp != null) {
                    PreparedStatement updateStmt;
                    block35: {
                        updateStmt = connection.prepareStatement(updateQuery);
                        Throwable throwable = null;
                        try {
                            updateStmt.setTimestamp(1, timestamp);
                            updateStmt.setLong(2, id);
                            updateStmt.executeUpdate();
                            ++convertedCount;
                            if (updateStmt == null) continue;
                            if (throwable == null) break block35;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (updateStmt == null) throw throwable3;
                                if (throwable == null) {
                                    updateStmt.close();
                                    throw throwable3;
                                }
                                try {
                                    updateStmt.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        try {
                            updateStmt.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    updateStmt.close();
                    continue;
                }
                ++failedCount;
                log.warn("Could not convert binary data to timestamp for row id={} in {}. Leaving as NULL.", (Object)id, (Object)tableName);
            }
        }
        log.info("Converted {} rows, {} failed (left as NULL) in {}.{}", new Object[]{convertedCount, failedCount, tableName, targetColumnName});
    }

    private Timestamp readTimestampFromBinary(ResultSet resultSet) {
        try {
            Object obj = resultSet.getObject(COLUMN_NAME);
            if (obj instanceof OffsetDateTime) {
                OffsetDateTime odt = (OffsetDateTime)obj;
                return Timestamp.from(odt.toInstant());
            }
        }
        catch (AbstractMethodError | ClassCastException | SQLException ignored) {
            log.debug("Could not read value as OffsetDateTime");
        }
        try {
            Timestamp timestamp = resultSet.getTimestamp(COLUMN_NAME);
            if (timestamp != null) {
                return timestamp;
            }
        }
        catch (AbstractMethodError | ClassCastException | SQLException ignored) {
            log.debug("Could not read value as Timestamp");
        }
        byte[] data = null;
        try {
            data = resultSet.getBytes(COLUMN_NAME);
        }
        catch (SQLException e) {
            try {
                Blob blob = resultSet.getBlob(COLUMN_NAME);
                if (blob != null) {
                    data = blob.getBytes(1L, (int)blob.length());
                }
            }
            catch (SQLException ignored) {
                log.debug("Could not read as BLOB");
            }
        }
        if (data != null && data.length > 0) {
            OffsetDateTime odt;
            if (this.isSerializedObject(data)) {
                try {
                    Object obj = this.deserializeObject(data);
                    if (obj instanceof OffsetDateTime) {
                        odt = (OffsetDateTime)obj;
                        return Timestamp.from(odt.toInstant());
                    }
                    if (obj instanceof Timestamp) {
                        return (Timestamp)obj;
                    }
                }
                catch (Exception e) {
                    log.debug("Could not deserialize object: {}", (Object)e.getMessage());
                }
            } else {
                try {
                    String dateString = new String(data, StandardCharsets.UTF_8).trim();
                    odt = OffsetDateTime.parse(dateString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
                    return Timestamp.from(odt.toInstant());
                }
                catch (Exception e) {
                    log.debug("Could not parse as ISO string: {}", (Object)e.getMessage());
                }
            }
        }
        return null;
    }

    private boolean isSerializedObject(byte[] data) {
        return data.length > 1 && data[0] == -84 && data[1] == -19;
    }

    private Object deserializeObject(byte[] data) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));){
            Object object = ois.readObject();
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableExists(Connection connection, String tableName, String databaseProductName) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
            String searchTableName = tableName;
            if (dbLower.contains(ORACLE)) {
                searchTableName = tableName.toUpperCase(Locale.ROOT);
            }
            try (ResultSet rs = metaData.getTables(null, null, searchTableName, null);){
                boolean bl = rs.next();
                return bl;
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean columnExists(Connection connection, String tableName, String databaseProductName) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
            String searchTableName = tableName;
            String searchColumnName = COLUMN_NAME;
            if (dbLower.contains(ORACLE)) {
                searchTableName = tableName.toUpperCase(Locale.ROOT);
                searchColumnName = COLUMN_NAME.toUpperCase(Locale.ROOT);
            }
            try (ResultSet rs = metaData.getColumns(null, null, searchTableName, searchColumnName);){
                boolean bl = rs.next();
                return bl;
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getColumnType(Connection connection, String tableName, String databaseProductName) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String dbLower = databaseProductName.toLowerCase(Locale.ROOT);
            String searchTableName = tableName;
            String searchColumnName = COLUMN_NAME;
            if (dbLower.contains(ORACLE)) {
                searchTableName = tableName.toUpperCase(Locale.ROOT);
                searchColumnName = COLUMN_NAME.toUpperCase(Locale.ROOT);
            }
            try (ResultSet rs = metaData.getColumns(null, null, searchTableName, searchColumnName);){
                if (!rs.next()) return null;
                String string = rs.getString("TYPE_NAME");
                return string;
            }
        }
        catch (SQLException e) {
            log.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void rollback() {
        log.warn("Rollback is not supported for column type migration");
    }
}

