/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask.summary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ListPermissionsFromKSeFSummary {
    private String configId;
    private String nip;
    private int errors = 0;
    private final List<PermissionInfo> permissions = new ArrayList<PermissionInfo>();

    public void increaseErrors(int increase) {
        this.errors += increase;
    }

    public void increaseErrors() {
        this.increaseErrors(1);
    }

    public void addPermission(String permissionScope, String description, String permissionType, Boolean canDelegate) {
        if (permissionScope != null) {
            this.permissions.add(new PermissionInfo(permissionScope, description, permissionType, canDelegate));
        }
    }

    public String buildSummary() {
        int MAX_LENGTH = 1000;
        String lineSeparator = "<br>";
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("ID PCM: <b>%s</b>", this.configId != null ? this.configId : "N/A")).append(lineSeparator);
        sb.append(String.format("NIP: <b>%s</b>", this.nip != null ? this.nip : "N/A")).append(lineSeparator);
        if (this.errors > 0) {
            sb.append(String.format("Errors: <b>%d</b>", this.errors)).append(lineSeparator);
        }
        sb.append(lineSeparator).append("<b>PERMISSIONS:</b>").append(lineSeparator);
        if (this.permissions.isEmpty()) {
            sb.append("None").append(lineSeparator);
        } else {
            List filteredPermissions = this.permissions.stream().filter(p -> p.getPermissionScope() != null).collect(Collectors.toList());
            Map byPermissionType = filteredPermissions.stream().collect(Collectors.groupingBy(p -> p.getPermissionType() != null ? p.getPermissionType() : "Other", LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry entry : byPermissionType.entrySet()) {
                String permissionType = (String)entry.getKey();
                List groupPermissions = (List)entry.getValue();
                sb.append(lineSeparator).append(String.format("<b>%s</b> (%d):", permissionType, groupPermissions.size())).append(lineSeparator);
                for (PermissionInfo permission : groupPermissions) {
                    sb.append(String.format("  - %s", permission.getPermissionScope()));
                    if (Boolean.TRUE.equals(permission.getCanDelegate())) {
                        sb.append(" (can delegate)");
                    }
                    if (permission.getDescription() != null && !permission.getDescription().isEmpty()) {
                        sb.append(String.format(" - %s", permission.getDescription()));
                    }
                    sb.append(lineSeparator);
                }
            }
        }
        sb.append(lineSeparator).append(String.format("<b>Note</b>: If the certificate was generated directly in the context of the NIP %s, you have full access to operations in the context of the entity.", this.nip != null ? this.nip : "N/A"));
        String result = sb.toString();
        if (result.length() > 1000) {
            result = result.substring(0, 980);
            result = result + lineSeparator + "... (truncated)";
        }
        return result;
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getNip() {
        return this.nip;
    }

    public int getErrors() {
        return this.errors;
    }

    public List<PermissionInfo> getPermissions() {
        return this.permissions;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setNip(String nip) {
        this.nip = nip;
    }

    private static class PermissionInfo {
        private final String permissionScope;
        private final String description;
        private final String permissionType;
        private final Boolean canDelegate;

        public PermissionInfo(String permissionScope, String description, String permissionType, Boolean canDelegate) {
            this.permissionScope = permissionScope;
            this.description = description;
            this.permissionType = permissionType;
            this.canDelegate = canDelegate;
        }

        public String getPermissionScope() {
            return this.permissionScope;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPermissionType() {
            return this.permissionType;
        }

        public Boolean getCanDelegate() {
            return this.canDelegate;
        }
    }
}

