/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.scheduledtask.summary.ListPermissionsFromKSeFSummary;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.api.builders.permission.entity.EntityAuthorizationPermissionsQueryRequestBuilder;
import pl.akmf.ksef.sdk.api.builders.permission.euentity.EuEntityPermissionsQueryRequestBuilder;
import pl.akmf.ksef.sdk.api.builders.permission.person.PersonPermissionsQueryRequestBuilder;
import pl.akmf.ksef.sdk.api.builders.permission.subunit.SubunitPermissionsQueryRequestBuilder;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.ApiException;
import pl.akmf.ksef.sdk.client.model.permission.search.EntityAuthorizationGrant;
import pl.akmf.ksef.sdk.client.model.permission.search.EntityAuthorizationPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.EntityRole;
import pl.akmf.ksef.sdk.client.model.permission.search.EuEntityPermission;
import pl.akmf.ksef.sdk.client.model.permission.search.EuEntityPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.PersonPermission;
import pl.akmf.ksef.sdk.client.model.permission.search.PersonPermissionQueryType;
import pl.akmf.ksef.sdk.client.model.permission.search.PersonPermissionsAuthorizedIdentifier;
import pl.akmf.ksef.sdk.client.model.permission.search.PersonPermissionsQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEntityAuthorizationPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEntityRolesResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryEuEntityPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantItem;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryPersonalGrantResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QuerySubunitPermissionsResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.QueryType;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRole;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRolesQueryRequest;
import pl.akmf.ksef.sdk.client.model.permission.search.SubordinateEntityRolesQueryResponse;
import pl.akmf.ksef.sdk.client.model.permission.search.SubunitPermission;
import pl.akmf.ksef.sdk.client.model.permission.search.SubunitPermissionsQueryRequest;

@ScheduledTask
public class ListPermissionsFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ListPermissionsFromKSeF.class);
    private static final String ID = "plusksef.scheduledTask.ListPermissionsFromKSeF";
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final ObjectMapper OBJECT_MAPPER = ListPermissionsFromKSeF.createObjectMapper();
    public static final String SHA_256 = "SHA-256";
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create();
    }

    public String execute(@Param String configId) {
        taskLog.debug((Object)("Processing configuration: " + configId));
        Assert.isTrue((configId != null && !configId.trim().isEmpty() ? 1 : 0) != 0, (String)"Configuration ID is required");
        KsefImportConfig config = this.configService.readConfigurationFromPCM(configId);
        Assert.isTrue((config.getApiVersion() == KsefApiVersion.V2 ? 1 : 0) != 0, (String)"Permissions listing is only available for KSeF API v2");
        ListPermissionsFromKSeFSummary summary = new ListPermissionsFromKSeFSummary();
        summary.setConfigId(configId);
        summary.setNip(config.getNip());
        try {
            this.processTask(config, summary);
            return summary.buildSummary();
        }
        catch (Exception e) {
            taskLog.error((Object)("Failed to connect to KSeF: " + e.getMessage()));
            return "Failed to connect to KSeF: " + e.getMessage();
        }
    }

    private void processTask(KsefImportConfig config, ListPermissionsFromKSeFSummary summary) {
        try {
            taskLog.debug((Object)("Initializing KSeF client for configuration: " + config.getConfigId()));
            DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(config.getKsefUrl(), config.getKsefSuffixUri(), config.getKsefQrUri());
            String accessToken = this.kSeFServiceApiV2.getAuthTokens(ksefClient, config).getAccessToken();
            taskLog.info((Object)("Fetching permissions for configuration: " + config.getConfigId()));
            taskLog.info((Object)("NIP: " + config.getNip()));
            taskLog.info((Object)"=== 1. Searching entity invoice roles ===");
            this.searchEntityInvoiceRoles(ksefClient, accessToken, summary);
            taskLog.info((Object)"=== 2. Searching personal grant permissions ===");
            this.searchPersonalGrantPermissions(ksefClient, accessToken, summary);
            taskLog.info((Object)"=== 3. Searching granted person permissions ===");
            this.searchGrantedPersonPermissions(ksefClient, accessToken, summary, config.getNip());
            taskLog.info((Object)"=== 4. Searching subunit admin permissions ===");
            this.searchSubunitAdminPermissions(ksefClient, accessToken, summary);
            taskLog.info((Object)"=== 5. Searching subordinate entity invoice roles ===");
            this.searchSubordinateEntityInvoiceRoles(ksefClient, accessToken, summary);
            taskLog.info((Object)"=== 6. Searching entity authorization grants ===");
            this.searchEntityAuthorizationGrants(ksefClient, accessToken, summary);
            taskLog.info((Object)"=== 7. Searching granted EU entity permissions ===");
            this.searchGrantedEuEntityPermissions(ksefClient, accessToken, summary, config.getNip());
            taskLog.info((Object)("Completed fetching all permissions for configuration: " + config.getConfigId()));
        }
        catch (ApiException e) {
            taskLog.error((Object)("KSeF API error while fetching permissions: " + e.getMessage()), (Throwable)e);
            summary.increaseErrors();
            throw e;
        }
        catch (Exception e) {
            taskLog.error((Object)("Error while fetching permissions: " + e.getMessage()), (Throwable)e);
            summary.increaseErrors();
            throw e;
        }
    }

    private void searchEntityInvoiceRoles(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary) {
        try {
            QueryEntityRolesResponse response = ksefClient.searchEntityInvoiceRoles(0, 100, accessToken);
            if (response != null && response.getRoles() != null && !response.getRoles().isEmpty()) {
                taskLog.info((Object)("Found " + response.getRoles().size() + " entity invoice roles"));
                for (EntityRole role : response.getRoles()) {
                    try {
                        summary.addPermission(role.getRole().name(), role.getDescription(), "Entity Invoice Role", null);
                        this.logGenericPermission(role, "Entity Invoice Role");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging entity invoice role: " + e.getMessage()), (Throwable)e);
                    }
                }
            } else {
                taskLog.info((Object)"No entity invoice roles found");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching entity invoice roles: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private void searchPersonalGrantPermissions(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary) {
        try {
            QueryPersonalGrantRequest request = new QueryPersonalGrantRequest();
            int permissionFoundCount = 0;
            QueryPersonalGrantResponse response = ksefClient.searchPersonalGrantPermission(request, 0, 100, accessToken);
            if (response != null && response.getPermissions() != null && !response.getPermissions().isEmpty()) {
                permissionFoundCount = response.getPermissions().size();
                taskLog.info((Object)("Found " + permissionFoundCount + " personal grant permissions"));
                for (QueryPersonalGrantItem permission : response.getPermissions()) {
                    try {
                        summary.addPermission(permission.getPermissionScope().name(), permission.getDescription(), "Personal Grant", permission.getCanDelegate());
                        this.logGenericPermission(permission, "Personal Grant");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging permission details: " + e.getMessage()));
                    }
                }
            } else {
                taskLog.info((Object)"No personal grant permissions found in response");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching personal grant permissions: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private void searchGrantedPersonPermissions(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary, String nip) {
        try {
            PersonPermissionsQueryRequest request = new PersonPermissionsQueryRequestBuilder().withAuthorizedIdentifier(new PersonPermissionsAuthorizedIdentifier(PersonPermissionsAuthorizedIdentifier.IdentifierType.NIP, nip)).withQueryType(PersonPermissionQueryType.PERMISSION_GRANTED_IN_CURRENT_CONTEXT).build();
            QueryPersonPermissionsResponse response = ksefClient.searchGrantedPersonPermissions(request, 0, 100, accessToken);
            if (response != null && response.getPermissions() != null && !response.getPermissions().isEmpty()) {
                taskLog.info((Object)("Found " + response.getPermissions().size() + " granted person permissions"));
                for (PersonPermission permission : response.getPermissions()) {
                    try {
                        summary.addPermission(permission.getPermissionScope().name(), permission.getDescription(), "Granted Person Permission", permission.isCanDelegate());
                        this.logGenericPermission(permission, "Granted Person Permission");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging granted person permission: " + e.getMessage()));
                    }
                }
            } else {
                taskLog.info((Object)"No granted person permissions found");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching granted person permissions: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private void searchSubunitAdminPermissions(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary) {
        try {
            SubunitPermissionsQueryRequest request = new SubunitPermissionsQueryRequestBuilder().build();
            QuerySubunitPermissionsResponse response = ksefClient.searchSubunitAdminPermissions(request, 0, 100, accessToken);
            if (response != null && response.getPermissions() != null && !response.getPermissions().isEmpty()) {
                taskLog.info((Object)("Found " + response.getPermissions().size() + " subunit admin permissions"));
                for (SubunitPermission permission : response.getPermissions()) {
                    try {
                        summary.addPermission(permission.getPermissionScope().name(), permission.getDescription(), "Subunit Admin Permission", null);
                        this.logGenericPermission(permission, "Subunit Admin Permission");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging subunit admin permission: " + e.getMessage()));
                    }
                }
            } else {
                taskLog.info((Object)"No subunit admin permissions found");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching subunit admin permissions: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private void searchSubordinateEntityInvoiceRoles(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary) {
        try {
            SubordinateEntityRolesQueryRequest request = new SubordinateEntityRolesQueryRequest();
            SubordinateEntityRolesQueryResponse response = ksefClient.searchSubordinateEntityInvoiceRoles(request, 0, 100, accessToken);
            if (response != null && response.getRoles() != null && !response.getRoles().isEmpty()) {
                taskLog.info((Object)("Found " + response.getRoles().size() + " subordinate entity invoice roles"));
                for (SubordinateEntityRole role : response.getRoles()) {
                    try {
                        summary.addPermission(role.getRole().name(), role.getDescription(), "Subordinate Entity Invoice Role", null);
                        this.logGenericPermission(role, "Subordinate Entity Invoice Role");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging subordinate entity invoice role: " + e.getMessage()));
                    }
                }
            } else {
                taskLog.info((Object)"No subordinate entity invoice roles found");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching subordinate entity invoice roles: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private void searchEntityAuthorizationGrants(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary) {
        try {
            EntityAuthorizationPermissionsQueryRequest request = new EntityAuthorizationPermissionsQueryRequestBuilder().withQueryType(QueryType.GRANTED).build();
            QueryEntityAuthorizationPermissionsResponse response = ksefClient.searchEntityAuthorizationGrants(request, 0, 100, accessToken);
            if (response != null && response.getAuthorizationGrants() != null && !response.getAuthorizationGrants().isEmpty()) {
                taskLog.info((Object)("Found " + response.getAuthorizationGrants().size() + " entity authorization grants"));
                for (EntityAuthorizationGrant grant : response.getAuthorizationGrants()) {
                    try {
                        summary.addPermission(grant.getAuthorizationScope().name(), grant.getDescription(), "Entity Authorization Grant", null);
                        this.logGenericPermission(grant, "Entity Authorization Grant");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging entity authorization grant: " + e.getMessage()));
                    }
                }
            } else {
                taskLog.info((Object)"No entity authorization grants found");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching entity authorization grants: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private void searchGrantedEuEntityPermissions(KSeFClient ksefClient, String accessToken, ListPermissionsFromKSeFSummary summary, String nip) {
        try {
            EuEntityPermissionsQueryRequest request = new EuEntityPermissionsQueryRequestBuilder().withAuthorizedFingerprintIdentifier(ListPermissionsFromKSeF.toSha256(nip)).build();
            QueryEuEntityPermissionsResponse response = ksefClient.searchGrantedEuEntityPermissions(request, 0, 100, accessToken);
            if (response != null && response.getPermissions() != null && !response.getPermissions().isEmpty()) {
                taskLog.info((Object)("Found " + response.getPermissions().size() + " granted EU entity permissions"));
                for (EuEntityPermission permission : response.getPermissions()) {
                    try {
                        summary.addPermission(permission.getPermissionScope().name(), permission.getDescription(), "Granted EU Entity Permission", null);
                        this.logGenericPermission(permission, "Granted EU Entity Permission");
                    }
                    catch (Exception e) {
                        taskLog.warn((Object)("Error logging granted EU entity permission: " + e.getMessage()));
                    }
                }
            } else {
                taskLog.info((Object)"No granted EU entity permissions found");
            }
        }
        catch (Exception e) {
            taskLog.warn((Object)("Error searching granted EU entity permissions: " + e.getMessage()));
            summary.increaseErrors();
        }
    }

    private static String toSha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance(SHA_256);
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString().toUpperCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 algorithm not found", e);
        }
    }

    private void logGenericPermission(Object permission, String permissionType) {
        try {
            String permissionJson = OBJECT_MAPPER.writeValueAsString(permission);
            taskLog.info((Object)String.format("[%s] %s", permissionType, permissionJson));
        }
        catch (Exception e) {
            taskLog.info((Object)String.format("[%s] %s", permissionType, permission != null ? permission.toString() : "null"));
        }
    }
}

