/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.scheduledtask;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.model.query.InvoiceQueryResponse;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.enums.MappingsForIndexesApiV1Enum;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.service.ImportedDocumentTableService;
import com.suncode.plugin.plusksef.db.service.LastInvoiceQueryTimeService;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.scheduledtask.summary.ImportDocumentsFromKSeFSummary;
import com.suncode.plugin.plusksef.scheduledtask.utils.ImportDocumentsFromKSeFUtils;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.DefaultKsefClient;
import pl.akmf.ksef.sdk.client.interfaces.KSeFClient;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceMetadata;
import pl.akmf.ksef.sdk.client.model.invoice.InvoiceQuerySubjectType;
import pl.akmf.ksef.sdk.client.model.invoice.QueryInvoiceMetadataResponse;

@ScheduledTask
public class ImportDocumentsFromKSeF
extends AbstractAdvancedTask {
    private static final Logger log = LoggerFactory.getLogger(ImportDocumentsFromKSeF.class);
    private static final int QUERY_INVOICE_PAGE_SIZE = 250;
    private static final long SLEEP_BETWEEN_QUERY_PAGES_MS = 5000L;
    private static final long SLEEP_BETWEEN_DOWNLOAD_INVOICE_BY_KSEF_NO = 3000L;
    private static final String LAST_CALL_DATE = "LAST_CALL_DATE";
    private static final String ID = "plusksef.scheduledTask.ImportDocumentsFromKSeF";
    private static final String XML_EXTENSION = ".xml";
    private final SimpleDateFormat dateFormatDDMMYYYY = new SimpleDateFormat("dd-MM-yyyy");
    private final SimpleDateFormat dateFormatYYYYMMDD = new SimpleDateFormat("yyyy-MM-dd");
    private final SimpleDateFormat dateFormatForLog = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private ImportedDocumentTableService importedDocumentTableService;
    @Autowired
    private LastInvoiceQueryTimeService lastInvoiceQueryTimeService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    public ImportDocumentsFromKSeF() {
        this.dateFormatDDMMYYYY.setLenient(false);
        this.dateFormatYYYYMMDD.setLenient(false);
        this.dateFormatForLog.setLenient(false);
    }

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).parameter().id("configIds").name(ID.concat(".param.configIds.name")).description(ID.concat(".param.configIds.desc")).type((Type)Types.STRING).create()).parameter().id("readFromDate").name(ID.concat(".param.readFromDate.name")).description(ID.concat(".param.readFromDate.desc")).type((Type)Types.STRING).create()).parameter().id("includeSubject3").name(ID.concat(".param.includeSubject3.name")).description(ID.concat(".param.includeSubject3.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)"false").create();
    }

    public String execute(@Param String configIds, @Param String readFromDate, @Param Boolean includeSubject3) {
        ImportDocumentsFromKSeFSummary importDocumentsFromKSeFSummaryInfo = new ImportDocumentsFromKSeFSummary();
        boolean includeSubject3Value = includeSubject3 != null ? includeSubject3 : false;
        Arrays.stream(configIds.split(",")).filter(config -> !config.isEmpty()).distinct().forEach(configId -> this.processTask((String)configId, readFromDate, includeSubject3Value, importDocumentsFromKSeFSummaryInfo));
        return importDocumentsFromKSeFSummaryInfo.buildSummary();
    }

    public void processTask(String configId, String readInvoiceFromStringParam, boolean includeSubject3, ImportDocumentsFromKSeFSummary summary) {
        taskLog.debug((Object)("Processing config: " + configId));
        KsefImportConfig config = this.configService.readConfigurationFromPCM(configId);
        Date readInvoiceFrom = this.getReadingDateFrom(readInvoiceFromStringParam, config);
        Date readInvoiceTo = this.getReadingDateTo();
        taskLog.debug((Object)String.format("Read invoice from %s to %s", this.dateFormatForLog.format(readInvoiceFrom), this.dateFormatForLog.format(readInvoiceTo)));
        Assert.isTrue((!readInvoiceFrom.after(readInvoiceTo) ? 1 : 0) != 0, (String)"Incorrect date. Date from occurs after Date to");
        if (config.getApiVersion() == KsefApiVersion.V2) {
            this.executeKSeFv2(config, readInvoiceFrom, readInvoiceTo, includeSubject3, summary);
        } else {
            this.executeKSeFv1(config, readInvoiceFrom, readInvoiceTo, summary);
        }
    }

    private Date getReadingDateFrom(String readInvoiceFromStringParam, KsefImportConfig config) throws ParseException {
        Date readInvoiceFrom;
        if (readInvoiceFromStringParam.startsWith(LAST_CALL_DATE)) {
            Date lastCallDate = this.lastInvoiceQueryTimeService.getLastInvoiceDate(config.getNip(), config.getKsefSystemType());
            if (lastCallDate == null) {
                Calendar cal = Calendar.getInstance();
                cal.add(2, -1);
                lastCallDate = cal.getTime();
            }
            int hoursOffset = this.parseHoursOffset(readInvoiceFromStringParam);
            readInvoiceFrom = this.addHoursToDate(lastCallDate, hoursOffset);
        } else {
            readInvoiceFrom = this.parseDate(readInvoiceFromStringParam);
            if (readInvoiceFrom == null) {
                Calendar cal = Calendar.getInstance();
                cal.add(2, -1);
                readInvoiceFrom = cal.getTime();
            }
        }
        return readInvoiceFrom;
    }

    private int parseHoursOffset(String param) {
        int defaultOffset = 0;
        if (param.equals(LAST_CALL_DATE)) {
            return defaultOffset;
        }
        try {
            String offsetPart = param.substring(LAST_CALL_DATE.length());
            if (offsetPart.startsWith("-")) {
                String hoursStr = offsetPart.replaceAll("[hH]$", "");
                return Integer.parseInt(hoursStr);
            }
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            taskLog.warn((Object)("Failed to parse hours offset from parameter: " + param + ". Using default offset: " + defaultOffset + "h"));
        }
        return defaultOffset;
    }

    private Date parseDate(String dateString) throws ParseException {
        try {
            return this.dateFormatDDMMYYYY.parse(dateString);
        }
        catch (ParseException e) {
            return this.dateFormatYYYYMMDD.parse(dateString);
        }
    }

    private Date getReadingDateTo() {
        return this.addHoursToDate(new Date(), 1);
    }

    private Date addHoursToDate(Date date, int hours) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    private void executeKSeFv1(KsefImportConfig config, Date readInvoiceFrom, Date readInvoiceTo, ImportDocumentsFromKSeFSummary summary) {
        Timestamp invoiceQueryTime;
        InvoiceQueryResponse invoiceQueryResponse;
        SessionInfo sessionInfo = this.kSeFServiceApiV1.getSession(config);
        int offset = 0;
        do {
            invoiceQueryTime = Timestamp.from(Instant.now());
            invoiceQueryResponse = this.kSeFServiceApiV1.invoiceQuery(config.getKsefUrl(), sessionInfo.getSessionToken(), readInvoiceFrom, readInvoiceTo, 250, offset);
            taskLog.debug((Object)("Found " + invoiceQueryResponse.getInvoiceHeaderList().size() + " documents"));
            summary.increaseProcessedDocuments(invoiceQueryResponse.getInvoiceHeaderList().size());
            for (InvoiceQueryResponse.InvoiceHeader invoiceHeader : invoiceQueryResponse.getInvoiceHeaderList()) {
                this.loadDocumentV1(invoiceHeader, sessionInfo.getSessionToken(), config, summary);
            }
            offset += 250;
        } while (invoiceQueryResponse.getInvoiceHeaderList().size() >= 250);
        this.lastInvoiceQueryTimeService.addInfo(config.getNip(), config.getKsefSystemType(), invoiceQueryTime, null);
    }

    private void executeKSeFv2(KsefImportConfig config, Date readInvoiceFrom, Date readInvoiceTo, boolean includeSubject3, ImportDocumentsFromKSeFSummary summary) {
        Timestamp subject3Time;
        DefaultKsefClient ksefClient = this.kSeFServiceApiV2.initKsefClient(config.getKsefUrl(), config.getKsefSuffixUri(), config.getKsefQrUri());
        String accessToken = this.kSeFServiceApiV2.getAuthTokens(ksefClient, config).getAccessToken();
        Timestamp queryTime = Timestamp.from(Instant.now());
        Timestamp lastInvoiceDate = null;
        Timestamp subject2Time = this.processSubjectTypeQuery(ksefClient, accessToken, readInvoiceFrom, readInvoiceTo, InvoiceQuerySubjectType.SUBJECT2, config, summary);
        if (subject2Time != null) {
            lastInvoiceDate = subject2Time;
        }
        if (includeSubject3 && (subject3Time = this.processSubjectTypeQuery(ksefClient, accessToken, readInvoiceFrom, readInvoiceTo, InvoiceQuerySubjectType.SUBJECT3, config, summary)) != null && (lastInvoiceDate == null || subject3Time.after(lastInvoiceDate))) {
            lastInvoiceDate = subject3Time;
        }
        this.lastInvoiceQueryTimeService.addInfo(config.getNip(), config.getKsefSystemType(), queryTime, lastInvoiceDate);
    }

    private Timestamp processSubjectTypeQuery(KSeFClient ksefClient, String accessToken, Date readInvoiceFrom, Date readInvoiceTo, InvoiceQuerySubjectType subjectType, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary) {
        Timestamp lastInvoiceDateWithAttachment = this.processInvoiceMetadataPages(ksefClient, accessToken, readInvoiceFrom, readInvoiceTo, subjectType, config, summary, true);
        Timestamp lastInvoiceDateWithoutAttachment = this.processInvoiceMetadataPages(ksefClient, accessToken, readInvoiceFrom, readInvoiceTo, subjectType, config, summary, false);
        return ImportDocumentsFromKSeF.later(lastInvoiceDateWithAttachment, lastInvoiceDateWithoutAttachment);
    }

    private Timestamp processInvoiceMetadataPages(KSeFClient ksefClient, String accessToken, Date readInvoiceFrom, Date readInvoiceTo, InvoiceQuerySubjectType subjectType, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary, boolean withAttachment) {
        int pageOffset = 0;
        Timestamp lastInvoiceDate = null;
        try {
            while (true) {
                QueryInvoiceMetadataResponse invoiceMetadata = this.kSeFServiceApiV2.getInvoiceMetadata(ksefClient, accessToken, readInvoiceFrom, readInvoiceTo, 250, pageOffset, subjectType, withAttachment);
                taskLog.debug((Object)("Found " + invoiceMetadata.getInvoices().size() + " documents for " + (Object)((Object)subjectType) + " (" + (withAttachment ? "with attachments" : "without attachments") + ")"));
                summary.increaseProcessedDocuments(invoiceMetadata.getInvoices().size());
                for (InvoiceMetadata invoiceData : invoiceMetadata.getInvoices()) {
                    boolean documentLoaded;
                    if (invoiceData.getPermanentStorageDate() != null) {
                        Timestamp invoicePermanentStorageDate = Timestamp.from(invoiceData.getPermanentStorageDate().toInstant());
                        if (lastInvoiceDate == null || invoicePermanentStorageDate.after(lastInvoiceDate)) {
                            lastInvoiceDate = invoicePermanentStorageDate;
                        }
                    }
                    if (!(documentLoaded = this.loadDocumentV2(ksefClient, invoiceData, accessToken, config, summary))) continue;
                    Thread.sleep(3000L);
                }
                ++pageOffset;
                if (invoiceMetadata.getHasMore().booleanValue()) {
                    Thread.sleep(5000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage(), (Throwable)e);
            return lastInvoiceDate;
        }
        return lastInvoiceDate;
    }

    private static Timestamp later(Timestamp a, Timestamp b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.after(b) ? a : b;
    }

    private void loadDocumentV1(InvoiceQueryResponse.InvoiceHeader invoiceHeader, String sessionToken, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary) {
        if (this.importedDocumentTableService.isDocumentImported(invoiceHeader.getKsefReferenceNumber())) {
            taskLog.debug((Object)String.format("SKIP document: %s (already imported)", invoiceHeader.getKsefReferenceNumber()));
            summary.increaseSkippedDocuments();
            return;
        }
        byte[] invoice = this.kSeFServiceApiV1.getInvoice(config.getKsefUrl(), invoiceHeader.getKsefReferenceNumber(), sessionToken);
        taskLog.debug((Object)("Load document: " + invoiceHeader.getKsefReferenceNumber()));
        Map<Long, Object> indexes = this.createIndexesMapV1(invoiceHeader, config);
        WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(config.getDocumentClassId(), invoiceHeader.getKsefReferenceNumber() + XML_EXTENSION, invoice, indexes, true);
        this.documentClassActionService.executeArchiveActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_ARCHIVE);
        this.importedDocumentTableService.addInfo(config.getNip(), config.getConfigId(), config.getKsefSystemType(), invoiceHeader.getKsefReferenceNumber(), wfDocument.getFile().getId());
        summary.increaseLoadDocuments();
    }

    private boolean loadDocumentV2(KSeFClient ksefClient, InvoiceMetadata invoiceData, String accessToken, KsefImportConfig config, ImportDocumentsFromKSeFSummary summary) {
        byte[] invoice = this.kSeFServiceApiV2.getInvoice(ksefClient, invoiceData.getKsefNumber(), accessToken);
        boolean loaded = ImportDocumentsFromKSeFUtils.loadDocumentToArchive(config, invoiceData, invoice, this.importedDocumentTableService, this.archiveDocumentService, this.documentClassActionService);
        if (!loaded) {
            taskLog.debug((Object)String.format("SKIP document: %s (already imported)", invoiceData.getKsefNumber()));
            summary.increaseSkippedDocuments();
            return false;
        }
        taskLog.debug((Object)("Load document: " + invoiceData.getKsefNumber()));
        summary.increaseLoadDocuments();
        return true;
    }

    private Map<Long, Object> createIndexesMapV1(InvoiceQueryResponse.InvoiceHeader invoiceHeader, KsefImportConfig config) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        config.getMappings().forEach(mapping -> indexes.put(mapping.getDocClassIndex(), this.getIndexValueV1(mapping.getKsefParam(), invoiceHeader, config)));
        indexes.values().removeIf(Objects::isNull);
        return indexes;
    }

    private Object getIndexValueV1(String key, InvoiceQueryResponse.InvoiceHeader invoiceHeader, KsefImportConfig config) {
        switch (MappingsForIndexesApiV1Enum.enumByKey(key)) {
            case SUBJECT_BY_NAME: {
                return invoiceHeader.getSubjectBy().getIssuedByName() != null ? invoiceHeader.getSubjectBy().getIssuedByName().getFullName() : null;
            }
            case SUBJECT_BY_NIP: {
                return invoiceHeader.getSubjectBy().getIssuedByIdentifier() != null ? invoiceHeader.getSubjectBy().getIssuedByIdentifier().getIdentifier() : null;
            }
            case SUBJECT_TO_NAME: {
                return invoiceHeader.getSubjectTo().getIssuedToName() != null ? invoiceHeader.getSubjectTo().getIssuedToName().getFullName() : null;
            }
            case SUBJECT_TO_NIP: {
                return invoiceHeader.getSubjectTo().getIssuedToIdentifier() != null ? invoiceHeader.getSubjectTo().getIssuedToIdentifier().getIdentifier() : null;
            }
            case CONFIG_ID: {
                return config.getConfigId();
            }
            case CONFIG_NIP: {
                return config.getNip();
            }
            case CONFIG_SYSTEM_TYPE: {
                return config.getKsefSystemType();
            }
        }
        return ((Map)new ObjectMapper().convertValue((Object)invoiceHeader, Map.class)).get(key);
    }
}

