/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.document.controller;

import com.suncode.plugin.plusksef.document.dto.DocClassInfo;
import com.suncode.plugin.plusksef.document.enums.Language;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.search.CountedResult;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Transactional
@Controller
@RequestMapping(value={"/documents"})
public class DocumentController {
    @Autowired
    private DocumentClassService documentClassService;

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocClassInfo> getDocumentClassList(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List documentClassList = this.documentClassService.getAll(new String[0]).stream().filter(documentClass -> StringUtils.containsIgnoreCase((String)documentClass.getName(), (String)query)).sorted(Comparator.comparing(DocumentClass::getName)).collect(Collectors.toList());
        CountedResult result = new CountedResult();
        result.setTotal((long)documentClassList.size());
        if (documentClassList.size() >= start) {
            List docClassInfoList = documentClassList.stream().map(DocClassInfo::new).collect(Collectors.toList());
            result.setData(docClassInfoList.subList(start, Integer.min(start + limit, documentClassList.size())));
        } else {
            result.setData(Collections.emptyList());
        }
        return result;
    }

    @RequestMapping(value={"invoiceLanguages"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getInvoiceLanguages(@RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        List languages = Language.stream().map(language -> {
            LinkedHashMap<String, String> langMap = new LinkedHashMap<String, String>();
            langMap.put("code", language.getCode());
            langMap.put("display", language.getCode().toUpperCase());
            return langMap;
        }).collect(Collectors.toList());
        return new CountedResult((long)languages.size(), languages);
    }
}

