/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.configuration.dto;

import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v2.enums.KsefV2AuthenticationMethod;
import java.util.List;

public class KsefImportConfig {
    private String configId;
    private String apiVersion;
    private String ksefUrl;
    private String ksefSuffixUri;
    private String ksefQrUri;
    private String ksefSystemType;
    private String apiV2authenticationMethods;
    private String apiV2Token;
    private String apiV2CertificatePEM;
    private String apiV2PrivateKeyPEM;
    private String apiV2OfflineCertificateSerialNumber;
    private String apiV2OfflinePrivateKeyPEM;
    private String nip;
    private String tokenAuth;
    private Long documentClassId;
    private List<Mapping> mappings;

    public KsefV2AuthenticationMethod getApiV2authenticationMethods() {
        if (this.apiV2authenticationMethods == null) {
            return KsefV2AuthenticationMethod.QUALIFIED_SIGNATURE;
        }
        try {
            return KsefV2AuthenticationMethod.valueOf(this.apiV2authenticationMethods);
        }
        catch (IllegalArgumentException e) {
            return KsefV2AuthenticationMethod.QUALIFIED_SIGNATURE;
        }
    }

    public KsefApiVersion getApiVersion() {
        if (this.apiVersion == null) {
            return KsefApiVersion.V1;
        }
        try {
            return KsefApiVersion.valueOf(this.apiVersion.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return KsefApiVersion.V1;
        }
    }

    public String getConfigId() {
        return this.configId;
    }

    public String getKsefUrl() {
        return this.ksefUrl;
    }

    public String getKsefSuffixUri() {
        return this.ksefSuffixUri;
    }

    public String getKsefQrUri() {
        return this.ksefQrUri;
    }

    public String getKsefSystemType() {
        return this.ksefSystemType;
    }

    public String getApiV2Token() {
        return this.apiV2Token;
    }

    public String getApiV2CertificatePEM() {
        return this.apiV2CertificatePEM;
    }

    public String getApiV2PrivateKeyPEM() {
        return this.apiV2PrivateKeyPEM;
    }

    public String getApiV2OfflineCertificateSerialNumber() {
        return this.apiV2OfflineCertificateSerialNumber;
    }

    public String getApiV2OfflinePrivateKeyPEM() {
        return this.apiV2OfflinePrivateKeyPEM;
    }

    public String getNip() {
        return this.nip;
    }

    public String getTokenAuth() {
        return this.tokenAuth;
    }

    public Long getDocumentClassId() {
        return this.documentClassId;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setKsefUrl(String ksefUrl) {
        this.ksefUrl = ksefUrl;
    }

    public void setKsefSuffixUri(String ksefSuffixUri) {
        this.ksefSuffixUri = ksefSuffixUri;
    }

    public void setKsefQrUri(String ksefQrUri) {
        this.ksefQrUri = ksefQrUri;
    }

    public void setKsefSystemType(String ksefSystemType) {
        this.ksefSystemType = ksefSystemType;
    }

    public void setApiV2authenticationMethods(String apiV2authenticationMethods) {
        this.apiV2authenticationMethods = apiV2authenticationMethods;
    }

    public void setApiV2Token(String apiV2Token) {
        this.apiV2Token = apiV2Token;
    }

    public void setApiV2CertificatePEM(String apiV2CertificatePEM) {
        this.apiV2CertificatePEM = apiV2CertificatePEM;
    }

    public void setApiV2PrivateKeyPEM(String apiV2PrivateKeyPEM) {
        this.apiV2PrivateKeyPEM = apiV2PrivateKeyPEM;
    }

    public void setApiV2OfflineCertificateSerialNumber(String apiV2OfflineCertificateSerialNumber) {
        this.apiV2OfflineCertificateSerialNumber = apiV2OfflineCertificateSerialNumber;
    }

    public void setApiV2OfflinePrivateKeyPEM(String apiV2OfflinePrivateKeyPEM) {
        this.apiV2OfflinePrivateKeyPEM = apiV2OfflinePrivateKeyPEM;
    }

    public void setNip(String nip) {
        this.nip = nip;
    }

    public void setTokenAuth(String tokenAuth) {
        this.tokenAuth = tokenAuth;
    }

    public void setDocumentClassId(Long documentClassId) {
        this.documentClassId = documentClassId;
    }

    public void setMappings(List<Mapping> mappings) {
        this.mappings = mappings;
    }

    public static class Mapping {
        String ksefParam;
        Long docClassIndex;

        public String getKsefParam() {
            return this.ksefParam;
        }

        public Long getDocClassIndex() {
            return this.docClassIndex;
        }

        public void setKsefParam(String ksefParam) {
            this.ksefParam = ksefParam;
        }

        public void setDocClassIndex(Long docClassIndex) {
            this.docClassIndex = docClassIndex;
        }
    }
}

