/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.api.enums.InvoiceSendMethod;
import com.suncode.plugin.plusksef.api.enums.KsefApiVersion;
import com.suncode.plugin.plusksef.api.v1.model.invoice.SendInvoiceResponse;
import com.suncode.plugin.plusksef.api.v1.service.KSeFServiceApiV1;
import com.suncode.plugin.plusksef.api.v1.service.dto.SessionInfo;
import com.suncode.plugin.plusksef.api.v2.services.KSeFServiceApiV2;
import com.suncode.plugin.plusksef.api.v2.services.dto.SendInvoiceResponseV2;
import com.suncode.plugin.plusksef.configuration.dto.KsefImportConfig;
import com.suncode.plugin.plusksef.configuration.service.ConfigurationService;
import com.suncode.plugin.plusksef.db.service.ExportedDocumentTableService;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import org.joda.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/SendInvoiceToKSeF/pwe_dynamic_form.js")
public class SendInvoiceToKSeF {
    private static final Logger log = LoggerFactory.getLogger(SendInvoiceToKSeF.class);
    private static final String ID = "plusksef.autotask.SendInvoiceToKSeF";
    private static final String EXPORTED_STATUS = "Exported. Waiting for KSeF status.";
    public static final String PENDING_KSEF_BATCH_SUBMISSION_STATUS = "Pending KSeF Batch Submission.";
    private static final String ADMIN = "admin";
    @Autowired
    private KSeFServiceApiV1 kSeFServiceApiV1;
    @Autowired
    private KSeFServiceApiV2 kSeFServiceApiV2;
    @Autowired
    private ConfigurationService configService;
    @Autowired
    private KsefDocumentService ksefDocumentService;
    @Autowired
    private ExportedDocumentTableService exportedDocumentTableService;
    @Autowired
    private CommentService commentService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.UP)).parameter().id("configId").name(ID.concat(".param.configId.name")).description(ID.concat(".param.configId.desc")).type((Type)Types.STRING).create()).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("referenceNumber").name(ID.concat(".param.referenceNumber.name")).description(ID.concat(".param.referenceNumber.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("invoiceSendMethod").name(ID.concat(".param.invoiceSendMethod.name")).description(ID.concat(".param.invoiceSendMethod.desc")).type((Type)Types.STRING).defaultValue((Object)"interactiveSession").create()).parameter().id("plannedSendDate").name(ID.concat(".param.plannedSendDate.name")).description(ID.concat(".param.plannedSendDate.desc")).type((Type)Types.DATETIME).optional().create();
    }

    public void execute(@Param String configId, @Param Integer fileId, @Param(value="referenceNumber") Variable elementReferenceNumber, @Param String invoiceSendMethod, @Param(value="plannedSendDate") LocalDateTime plannedSendDate, ApplicationContext applicationContext) throws AcceptanceException, IOException {
        KsefImportConfig ksefImportConfig = this.configService.readConfigurationFromPCM(configId);
        InvoiceSendMethod sendMethod = InvoiceSendMethod.fromString(invoiceSendMethod);
        if (InvoiceSendMethod.BATCH_SESSION == sendMethod) {
            this.executeBatchSession(ksefImportConfig, fileId, plannedSendDate.toDate(), applicationContext, sendMethod);
        } else {
            this.executeInteractiveSession(ksefImportConfig, fileId, elementReferenceNumber, applicationContext, sendMethod);
        }
    }

    private void executeInteractiveSession(KsefImportConfig ksefImportConfig, Integer fileId, Variable elementReferenceNumber, ApplicationContext applicationContext, InvoiceSendMethod invoiceSendMethod) throws AcceptanceException {
        if (ksefImportConfig.getApiVersion() == KsefApiVersion.V2) {
            this.executeInteractiveSessionApiV2(ksefImportConfig, fileId, elementReferenceNumber, applicationContext, invoiceSendMethod);
        } else {
            this.executeInteractiveSessionApiV1(ksefImportConfig, fileId, elementReferenceNumber, applicationContext, invoiceSendMethod);
        }
    }

    private void executeInteractiveSessionApiV1(KsefImportConfig ksefImportConfig, Integer fileId, Variable elementReferenceNumber, ApplicationContext applicationContext, InvoiceSendMethod invoiceSendMethod) throws AcceptanceException {
        try {
            log.info("Send invoice to KSeF API v1 - Interactive Session");
            SessionInfo sessionInfo = this.kSeFServiceApiV1.getSession(ksefImportConfig);
            log.info("Document fileId: {}", (Object)fileId);
            byte[] invoiceBytes = this.ksefDocumentService.getDocumentBytes(fileId.longValue());
            SendInvoiceResponse sendInvoiceResponse = this.kSeFServiceApiV1.sendInvoice(ksefImportConfig.getKsefUrl(), sessionInfo.getSessionToken(), invoiceBytes);
            elementReferenceNumber.setValue((Object)sendInvoiceResponse.getElementReferenceNumber());
            try {
                this.exportedDocumentTableService.addInfo(ksefImportConfig, fileId.longValue(), sendInvoiceResponse.getReferenceNumber(), sendInvoiceResponse.getElementReferenceNumber(), applicationContext.getActivityId(), applicationContext.getProcessId(), sessionInfo.getSessionToken(), EXPORTED_STATUS, Timestamp.from(Instant.now()), invoiceSendMethod, null);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.addCommentToActivity(applicationContext.getActivityId(), applicationContext.getProcessId(), "There was a problem saving data in ExportedDocumentTable. " + e.getMessage());
            }
            log.info(String.format("DOCUMENT EXPORTED. Invoice reference number: %s. KSeF element reference number: %S", sendInvoiceResponse.getReferenceNumber(), sendInvoiceResponse.getElementReferenceNumber()));
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeInteractiveSessionApiV2(KsefImportConfig ksefImportConfig, Integer fileId, Variable elementReferenceNumber, ApplicationContext applicationContext, InvoiceSendMethod invoiceSendMethod) throws AcceptanceException {
        try {
            log.info("Send invoice to KSeF API v2 - Interactive Session");
            log.info("Document fileId: {}", (Object)fileId);
            byte[] invoiceBytes = this.ksefDocumentService.getDocumentBytes(fileId.longValue());
            SendInvoiceResponseV2 sendInvoiceResponse = this.kSeFServiceApiV2.sendInvoice(ksefImportConfig, invoiceBytes);
            elementReferenceNumber.setValue((Object)sendInvoiceResponse.getExportReferenceNumber());
            try {
                this.exportedDocumentTableService.addInfo(ksefImportConfig, fileId.longValue(), sendInvoiceResponse.getExportReferenceNumber(), sendInvoiceResponse.getSessionInfo().getSessionReferenceNumber(), applicationContext.getActivityId(), applicationContext.getProcessId(), sendInvoiceResponse.getSessionInfo().getAccessToken(), EXPORTED_STATUS, Timestamp.from(Instant.now()), invoiceSendMethod, null);
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.addCommentToActivity(applicationContext.getActivityId(), applicationContext.getProcessId(), "There was a problem saving data in ExportedDocumentTable. " + e.getMessage());
            }
            log.info(String.format("DOCUMENT EXPORTED. Invoice reference number: %s. Session reference number: %S", sendInvoiceResponse.getExportReferenceNumber(), sendInvoiceResponse.getSessionInfo().getSessionReferenceNumber()));
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void executeBatchSession(KsefImportConfig ksefImportConfig, Integer fileId, Date plannedSendDate, ApplicationContext applicationContext, InvoiceSendMethod invoiceSendMethod) throws AcceptanceException {
        if (ksefImportConfig.getApiVersion() == KsefApiVersion.V1) {
            throw new AcceptanceException("Batch session is not supported for KSeF API v1. Please use API v2 or switch to interactive session.");
        }
        try {
            log.info("Batch session - preparing invoice for scheduled sending. fileId: {}, plannedSendDate: {}", (Object)fileId, (Object)plannedSendDate);
            Timestamp batchPlannedSendDateTimestamp = plannedSendDate != null ? new Timestamp(plannedSendDate.getTime()) : null;
            this.exportedDocumentTableService.addInfo(ksefImportConfig, fileId.longValue(), "", "", applicationContext.getActivityId(), applicationContext.getProcessId(), "", PENDING_KSEF_BATCH_SUBMISSION_STATUS, null, invoiceSendMethod, batchPlannedSendDateTimestamp);
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private void addCommentToActivity(String activityId, String processId, String commentValue) {
        String username = UserContext.isActive() ? UserContext.current().getUser().getUserName() : ADMIN;
        Comment comment = new Comment();
        comment.setActivityId(activityId);
        comment.setProcessId(processId);
        comment.setUserId(username);
        comment.setTimestamp(Long.valueOf(new Date().getTime()));
        comment.setComment(commentValue);
        this.commentService.createComment(comment);
    }
}

