/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.autotask;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.plusksef.Categories;
import com.suncode.plugin.plusksef.document.service.ArchiveDocumentService;
import com.suncode.plugin.plusksef.document.service.KSeFQrURLGenerator;
import com.suncode.plugin.plusksef.document.service.KsefDocumentService;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.variable.Variable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import pl.akmf.ksef.sdk.api.services.DefaultQrCodeService;

@Application
@ComponentsFormScript(value="dist/plusksef/autotask/GenerateKsefQrCode/pwe_dynamic_form.js")
public class GenerateKsefQrCode {
    private static final String ID = "plusksef.autotask.GenerateKsefQrCode";
    private static final String QR1 = "QR1";
    private static final String QR2 = "QR2";
    private static final int PIXELS_PER_MODULE = 20;
    @Autowired
    private FileService fileService;
    @Autowired
    private KsefDocumentService ksefDocumentService;
    @Autowired
    private ArchiveDocumentService archiveDocumentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;
    @Autowired
    private KSeFQrURLGenerator kSeFQrURLGenerator;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.KSEF})).icon((Icon)DivanteIcon.IMAGE)).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).create()).parameter().id("qrType").name(ID.concat(".param.qrType.name")).description(ID.concat(".param.qrType.desc")).type((Type)Types.STRING).defaultValue((Object)QR1).create()).parameter().id("pcmConfigId").name(ID.concat(".param.pcmConfigId.name")).description(ID.concat(".param.pcmConfigId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("documentClassName").name(ID.concat(".param.documentClassName.name")).description(ID.concat(".param.documentClassName.desc")).type((Type)Types.STRING).create()).parameter().id("addDocumentToProcess").name(ID.concat(".param.addDocumentToProcess.name")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("saveAsNewVersion").name(ID.concat(".param.saveAsNewVersion.name")).description(ID.concat(".param.saveAsNewVersion.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("executeDocumentAction").name(ID.concat(".param.executeDocumentAction.name")).description(ID.concat(".param.executeDocumentAction.desc")).type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("variableToSaveFileId").name(ID.concat(".param.variableToSaveFileId.name")).description(ID.concat(".param.variableToSaveFileId.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("variableToSaveQrCodeUrl").name(ID.concat(".param.variableToSaveQrCodeUrl.name")).description(ID.concat(".param.variableToSaveQrCodeUrl.desc")).type((Type)Types.VARIABLE).optional().create()).parameter().id("fileName").name(ID.concat(".param.fileName.name")).description(ID.concat(".param.fileName.desc")).type((Type)Types.STRING).optional().create()).parameter().id("label").name(ID.concat(".param.label.name")).description(ID.concat(".param.label.desc")).type((Type)Types.STRING).optional().create()).parameter().id("qrCodeWidthAndHeight").name(ID.concat(".param.qrCodeWidthAndHeight.name")).description(ID.concat(".param.qrCodeWidthAndHeight.desc")).type((Type)Types.INTEGER).defaultValue((Object)300).create();
    }

    public void execute(@Param Integer fileId, @Param String qrType, @Param String pcmConfigId, @Param String documentClassName, @Param Boolean addDocumentToProcess, @Param Boolean saveAsNewVersion, @Param Boolean executeDocumentAction, @Param Variable variableToSaveFileId, @Param Variable variableToSaveQrCodeUrl, @Param String fileName, @Param String label, @Param Integer qrCodeWidthAndHeight, WorkflowContext context) throws Exception {
        try {
            String qrUrl;
            Assert.notNull((Object)fileId, (String)"fileId is required");
            Assert.hasText((String)qrType, (String)"qrType is required");
            Assert.hasText((String)documentClassName, (String)"documentClassName is required");
            WfFile wfFile = this.fileService.getFile(Long.valueOf(fileId.longValue()), new String[0]);
            Assert.isTrue((boolean)this.ksefDocumentService.isKsefInvoiceDocument(wfFile), (String)"The indicated xml file is not a ksef invoice.");
            if (QR1.equals(qrType)) {
                qrUrl = this.kSeFQrURLGenerator.buildInvoiceVerificationUrl(wfFile).getUrl();
            } else if (QR2.equals(qrType)) {
                Assert.hasText((String)pcmConfigId, (String)"pcmConfigId is required for QR2");
                qrUrl = this.kSeFQrURLGenerator.buildCertificateVerificationUrl(wfFile, pcmConfigId).getUrl();
            } else {
                throw new IllegalArgumentException("Invalid qrType: " + qrType + ". Expected QR1 or QR2.");
            }
            Assert.hasText((String)qrUrl, (String)"QR code URL cannot be empty");
            byte[] qrCodePngBytes = this.generateQrCodePng(qrUrl, label, qrCodeWidthAndHeight);
            String newFileName = this.createFileName(fileName, wfFile, qrType);
            WfDocument wfDocument = this.archiveDocumentService.addNewDocumentToArchive(documentClassName, newFileName, qrCodePngBytes, null, (boolean)saveAsNewVersion, (boolean)addDocumentToProcess, context.getActivityId(), context.getProcessId(), null);
            if (Boolean.TRUE.equals(executeDocumentAction)) {
                this.documentClassActionService.executeProcessActions(wfDocument, DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, context.getProcessId(), context.getActivityId());
            }
            if (variableToSaveFileId != null) {
                variableToSaveFileId.setValue((Object)wfDocument.getFile().getId());
            }
            if (variableToSaveQrCodeUrl != null) {
                variableToSaveQrCodeUrl.setValue((Object)qrUrl);
            }
        }
        catch (Exception e) {
            throw new AcceptanceException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] generateQrCodePng(String qrUrl, String label, int qrCodeWidthAndHeight) throws Exception {
        DefaultQrCodeService qrCodeService = new DefaultQrCodeService();
        byte[] qrBytes = qrCodeService.generateQrCode(qrUrl, 20, qrCodeWidthAndHeight);
        if (StringUtils.isNotBlank((CharSequence)label)) {
            return qrCodeService.addLabelToQrCode(qrBytes, label);
        }
        return qrBytes;
    }

    private String createFileName(String fileName, WfFile wfFile, String qrType) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            String newFileName = fileName.trim();
            if (!newFileName.toLowerCase().endsWith(".png")) {
                newFileName = newFileName + '.' + "png";
            }
            return newFileName;
        }
        String baseName = FilenameUtils.removeExtension((String)wfFile.getFileName());
        return baseName + "_" + qrType + '.' + "png";
    }
}

