/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.plusksef.api.v2.enums;

import com.suncode.pwfl.translation.LocalizedString;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.Translators;
import java.util.stream.Stream;

public enum KsefV2SystemType {
    TEST("https://api-test.ksef.mf.gov.pl", "v2", "https://qr-test.ksef.mf.gov.pl"),
    DEMO("https://api-demo.ksef.mf.gov.pl", "v2", "https://qr-demo.ksef.mf.gov.pl"),
    PROD("https://api.ksef.mf.gov.pl", "v2", "https://qr.ksef.mf.gov.pl");

    private static final Translator translator;
    private final String baseUri;
    private final String suffixUri;
    private final String qrUri;

    private KsefV2SystemType(String type, String suffixUri, String qrUri) {
        this.baseUri = type;
        this.suffixUri = suffixUri;
        this.qrUri = qrUri;
    }

    public static Stream<KsefV2SystemType> stream() {
        return Stream.of(KsefV2SystemType.values());
    }

    public String getTranslation() {
        LocalizedString text = new LocalizedString("plusksef.systemType.enum." + this.name().toLowerCase(), translator, new Object[0]);
        return text.getOptional();
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public String getSuffixUri() {
        return this.suffixUri;
    }

    public String getQrUri() {
        return this.qrUri;
    }

    static {
        translator = Translators.get((String)"com.suncode.plugin-plus-ksef");
    }
}

