/*
 * Decompiled with CFR 0.152.
 */
package pl.akmf.ksef.sdk.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleHttpClient {
    public static SimpleHttpResponse sendRequest(String url, String method, byte[] body, Map<String, String> headers) throws IOException {
        return SimpleHttpClient.sendRequest(url, method, body, headers, null);
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleHttpResponse sendRequest(String url, String method, byte[] body, Map<String, String> headers, Duration timeout) throws IOException {
        void var11_19;
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setRequestMethod(method);
        long timeoutMillis = timeout != null ? timeout.toMillis() : 30000L;
        int timeoutSeconds = (int)(timeoutMillis / 1000L);
        if (timeoutSeconds <= 0) {
            timeoutSeconds = 30;
        }
        connection.setConnectTimeout(timeoutSeconds * 1000);
        connection.setReadTimeout(timeoutSeconds * 1000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (body != null && (method.equals("POST") || method.equals("PUT"))) {
            connection.setDoOutput(true);
            Throwable throwable = null;
            try (OutputStream os = connection.getOutputStream();){
                os.write(body);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        int statusCode = connection.getResponseCode();
        try (InputStream is = connection.getInputStream();){
            byte[] byArray = SimpleHttpClient.readAllBytes(is);
        }
        catch (IOException e) {
            InputStream errorIs = connection.getErrorStream();
            Object object = null;
            try {
                if (errorIs != null) {
                    byte[] byArray = SimpleHttpClient.readAllBytes(errorIs);
                } else {
                    byte[] byArray = new byte[]{};
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (errorIs != null) {
                    if (object != null) {
                        try {
                            errorIs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        errorIs.close();
                    }
                }
            }
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        if (headerFields != null) {
            for (Map.Entry entry : headerFields.entrySet()) {
                List values;
                String key = (String)entry.getKey();
                if (key == null || (values = (List)entry.getValue()) == null || values.isEmpty()) continue;
                responseHeaders.put(key, (String)values.get(0));
            }
        }
        return new SimpleHttpResponse(statusCode, (byte[])var11_19, responseHeaders);
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleHttpResponse sendRequestWithStream(String url, String method, InputStream bodyStream, long contentLength, Map<String, String> headers, Duration timeout) throws IOException {
        void var13_20;
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        connection.setRequestMethod(method);
        long timeoutMillis = timeout != null ? timeout.toMillis() : 30000L;
        int timeoutSeconds = (int)(timeoutMillis / 1000L);
        if (timeoutSeconds <= 0) {
            timeoutSeconds = 30;
        }
        connection.setConnectTimeout(timeoutSeconds * 1000);
        connection.setReadTimeout(timeoutSeconds * 1000);
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (bodyStream != null && method.equals("PUT")) {
            connection.setDoOutput(true);
            if (contentLength > 0L) {
                connection.setFixedLengthStreamingMode(contentLength);
            }
            Throwable throwable = null;
            try (OutputStream os = connection.getOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = bodyStream.read(buffer)) != -1) {
                    os.write(buffer, 0, bytesRead);
                }
            }
            catch (Throwable buffer) {
                Throwable throwable2 = buffer;
                throw buffer;
            }
        }
        int statusCode = connection.getResponseCode();
        try (InputStream is = connection.getInputStream();){
            byte[] byArray = SimpleHttpClient.readAllBytes(is);
        }
        catch (IOException e) {
            InputStream errorIs = connection.getErrorStream();
            Object object = null;
            try {
                if (errorIs != null) {
                    byte[] byArray = SimpleHttpClient.readAllBytes(errorIs);
                } else {
                    byte[] byArray = new byte[]{};
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (errorIs != null) {
                    if (object != null) {
                        try {
                            errorIs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        errorIs.close();
                    }
                }
            }
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        if (headerFields != null) {
            for (Map.Entry entry : headerFields.entrySet()) {
                List values;
                String key = (String)entry.getKey();
                if (key == null || (values = (List)entry.getValue()) == null || values.isEmpty()) continue;
                responseHeaders.put(key, (String)values.get(0));
            }
        }
        return new SimpleHttpResponse(statusCode, (byte[])var13_20, responseHeaders);
    }

    private static byte[] readAllBytes(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static class SimpleHttpResponse {
        private final int statusCode;
        private final byte[] body;
        private final Map<String, String> headers;

        public SimpleHttpResponse(int statusCode, byte[] body, Map<String, String> headers) {
            this.statusCode = statusCode;
            this.body = body;
            this.headers = headers;
        }

        public int statusCode() {
            return this.statusCode;
        }

        public byte[] body() {
            return this.body;
        }

        public Map<String, String> headers() {
            return this.headers;
        }
    }
}

